/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_track_t;
import uk.co.caprica.vlcj.media.Multiview;
import uk.co.caprica.vlcj.media.TrackType;
import uk.co.caprica.vlcj.media.VideoOrientation;
import uk.co.caprica.vlcj.media.VideoProjection;
import uk.co.caprica.vlcj.player.base.Track;

public final class VideoTrack
extends Track {
    private final int width;
    private final int height;
    private final int sampleAspectRatio;
    private final int sampleAspectRatioBase;
    private final int frameRate;
    private final int frameRateBase;
    private final VideoOrientation orientation;
    private final VideoProjection projection;
    private final float yaw;
    private final float pitch;
    private final float roll;
    private final float fieldOfView;
    private final Multiview multiview;

    VideoTrack(libvlc_media_track_t instance) {
        super(TrackType.VIDEO, instance);
        instance.u.setType(libvlc_video_track_t.class);
        instance.u.read();
        this.width = instance.u.video.i_width;
        this.height = instance.u.video.i_height;
        this.sampleAspectRatio = instance.u.video.i_sar_num;
        this.sampleAspectRatioBase = instance.u.video.i_sar_den;
        this.frameRate = instance.u.video.i_frame_rate_num;
        this.frameRateBase = instance.u.video.i_frame_rate_den;
        this.orientation = VideoOrientation.videoOrientation(instance.u.video.i_orientation);
        this.projection = VideoProjection.videoProjection(instance.u.video.i_projection);
        this.yaw = instance.u.video.pose.f_yaw;
        this.pitch = instance.u.video.pose.f_pitch;
        this.roll = instance.u.video.pose.f_roll;
        this.fieldOfView = instance.u.video.pose.f_field_of_view;
        this.multiview = Multiview.multiview(instance.u.video.i_multiview);
    }

    public final int width() {
        return this.width;
    }

    public final int height() {
        return this.height;
    }

    public final int sampleAspectRatio() {
        return this.sampleAspectRatio;
    }

    public final int sampleAspectRatioBase() {
        return this.sampleAspectRatioBase;
    }

    public final int frameRate() {
        return this.frameRate;
    }

    public final int frameRateBase() {
        return this.frameRateBase;
    }

    public final VideoOrientation orientation() {
        return this.orientation;
    }

    public final VideoProjection projection() {
        return this.projection;
    }

    public final float yaw() {
        return this.yaw;
    }

    public final float pitch() {
        return this.pitch;
    }

    public final float roll() {
        return this.roll;
    }

    public final float fieldOfView() {
        return this.fieldOfView;
    }

    public final Multiview multiview() {
        return this.multiview;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(super.toString()).append('[');
        sb.append("width=").append(this.width).append(',');
        sb.append("height=").append(this.height).append(',');
        sb.append("sampleAspectRatio=").append(this.sampleAspectRatio).append(',');
        sb.append("sampleAspectRatioBase=").append(this.sampleAspectRatioBase).append(',');
        sb.append("frameRate=").append(this.frameRate).append(',');
        sb.append("frameRateBase=").append(this.frameRateBase).append(',');
        sb.append("orientation=").append((Object)this.orientation).append(',');
        sb.append("projection=").append((Object)this.projection).append(',');
        sb.append("yaw=").append(this.yaw).append(',');
        sb.append("pitch=").append(this.pitch).append(',');
        sb.append("roll=").append(this.roll).append(',');
        sb.append("fieldOfView=").append(this.fieldOfView).append(',');
        sb.append("multiview=").append((Object)this.multiview).append(']');
        return sb.toString();
    }
}

