/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;

final class WaitForSnapshot
extends MediaPlayerEventAdapter {
    private final MediaPlayer mediaPlayer;
    private final File file;
    private final int width;
    private final int height;
    private final CountDownLatch snapshotTakenLatch = new CountDownLatch(1);
    private volatile String snapshotResult;

    WaitForSnapshot(MediaPlayer mediaPlayer, File file, int width, int height) {
        this.mediaPlayer = mediaPlayer;
        this.file = file;
        this.width = width;
        this.height = height;
    }

    String getSnapshot() {
        return this.requestSnapshot(0L);
    }

    String getSnapshot(long timeout) {
        return this.requestSnapshot(timeout);
    }

    private String requestSnapshot(long timeout) {
        try {
            this.mediaPlayer.events().addMediaPlayerEventListener(this);
            if (this.mediaPlayer.snapshots().save(this.file, this.width, this.height)) {
                if (timeout == 0L) {
                    this.snapshotTakenLatch.await();
                } else {
                    this.snapshotTakenLatch.await(timeout, TimeUnit.MILLISECONDS);
                }
                String string = this.snapshotResult;
                return string;
            }
            String string = null;
            return string;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.mediaPlayer.events().removeMediaPlayerEventListener(this);
        }
    }

    @Override
    public void snapshotTaken(MediaPlayer mediaPlayer, String filename) {
        this.snapshotResult = filename;
        this.snapshotTakenLatch.countDown();
    }

    @Override
    public void stopped(MediaPlayer mediaPlayer) {
        this.snapshotResult = null;
        this.snapshotTakenLatch.countDown();
    }
}

