/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static PlayerInfo lastSender;
    @Nullable
    public static GuiMessage.Line lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static boolean serverSentUuid;
    public static final Set<ResourceLocation> blendedHeadTextures;

    public static void handleAddedMessage(Component message, @Nullable PlayerInfo playerInfo) {
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            lastSender = playerInfo;
            if (playerInfo != null) {
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message);
    }

    public static int getChatOffset(@NotNull GuiMessage.Line guiMessage) {
        PlayerInfo owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable PlayerInfo owner) {
        if (owner != null || CONFIG.offsetNonPlayerText()) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static PlayerInfo detectPlayer(Component message) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        HashMap<String, PlayerInfo> nicknameCache = new HashMap<String, PlayerInfo>();
        for (String word : message.getString().split("(\u00a7.)|[^\\w]")) {
            if (word.isEmpty()) continue;
            PlayerInfo player = connection.m_104938_(word = CONFIG.getProfileName(word));
            if (player != null) {
                return player;
            }
            player = ChatHeads.getPlayerFromNickname(word, connection, nicknameCache);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Nullable
    private static PlayerInfo getPlayerFromNickname(String word, ClientPacketListener connection, Map<String, PlayerInfo> nicknameCache) {
        if (nicknameCache.isEmpty()) {
            for (PlayerInfo p : connection.m_105142_()) {
                Component displayName = p.m_105342_();
                if (displayName == null) continue;
                String nickname = displayName.getString();
                if (word.equals(nickname)) {
                    nicknameCache.clear();
                    return p;
                }
                nicknameCache.put(nickname, p);
            }
        } else {
            return nicknameCache.get(word);
        }
        return null;
    }

    public static NativeImage extractBlendedHead(NativeImage skin) {
        NativeImage head = new NativeImage(8, 8, false);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                int headColor = skin.m_84985_(8 + x, 8 + y);
                int hatColor = skin.m_84985_(40 + x, 8 + y);
                head.m_84988_(x, y, headColor);
                head.m_166411_(x, y, hatColor);
            }
        }
        return head;
    }

    public static ResourceLocation getBlendedHeadLocation(ResourceLocation skinLocation) {
        return new ResourceLocation(MOD_ID, skinLocation.m_135815_());
    }

    public static void renderChatHead(PoseStack matrixStack, int x, int y, PlayerInfo owner) {
        ResourceLocation skinLocation = owner.m_105337_();
        if (blendedHeadTextures.contains(skinLocation)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ChatHeads.getBlendedHeadLocation(skinLocation));
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)skinLocation);
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)x, (int)y, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        }
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
        blendedHeadTextures = new HashSet<ResourceLocation>();
    }
}

