/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WorkbenchBlockEntityRenderer
implements BlockEntityRenderer<CraftingTableBlockEntity> {
    private final ItemRenderer itemRenderer;

    public WorkbenchBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(CraftingTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        combinedLightIn = blockEntity.combinedLight;
        for (int i = 0; i < blockEntity.m_6643_(); ++i) {
            ItemStack itemStack = blockEntity.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            this.renderIngredientItem(blockEntity, partialTicks, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, i, itemStack);
        }
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult && !blockEntity.getLastResult().m_41619_()) {
            this.renderResultItem(blockEntity.getLastResult(), blockEntity.m_58904_(), (float)blockEntity.ticks + partialTicks, poseStack, bufferIn, combinedLightIn);
        }
    }

    private void renderIngredientItem(CraftingTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, int i, ItemStack itemStack) {
        poseStack.m_85836_();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupLayingRenderer(blockEntity, partialTicks, poseStack, itemStack, i);
        } else {
            this.setupFloatingRenderer(blockEntity, partialTicks, poseStack, itemStack, i);
        }
        Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, (int)blockEntity.m_58899_().m_121878_() + i);
        poseStack.m_85849_();
    }

    private void setupFloatingRenderer(CraftingTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, ItemStack itemStack, int index) {
        float shift = (float)Math.abs(((double)((float)blockEntity.ticks + partialTicks) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        BakedModel model = this.itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean blockItem = model.m_7539_();
        poseStack.m_85837_(0.5, (double)shift, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)blockEntity.currentAngle, (float)blockEntity.nextAngle)));
        poseStack.m_85837_((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = blockItem ? 0.24f : 0.18f;
        poseStack.m_85841_(scale, scale, scale);
    }

    private void setupLayingRenderer(CraftingTableBlockEntity blockEntity, float partialTicks, PoseStack poseStack, ItemStack itemStack, int index) {
        BakedModel model = this.itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean blockItem = model.m_7539_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)blockEntity.currentAngle, (float)blockEntity.nextAngle)));
        poseStack.m_85837_((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, blockItem ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        float scale = blockItem ? 0.25f : 0.175f;
        poseStack.m_85841_(scale, scale, scale);
    }

    private void renderResultItem(ItemStack stack, @Nullable Level worldIn, float time, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, (double)1.15f, 0.5);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, worldIn, null, 0);
        float hoverOffset = Mth.m_14031_((float)(time / 10.0f)) * 0.04f + 0.1f;
        float modelYScale = model.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        poseStack.m_85837_(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_(time / 20.0f));
        if (!model.m_7539_()) {
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        }
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.GROUND, false, poseStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
    }
}

