/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.blocks.modifierblock.GuiModifier;
import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.network.BaseMessageClient;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ClientProxy
extends ClientProxyInterface {
    public ResourceLocation doubleJumpSoundLoc = new ResourceLocation("grapplemod", "doublejump");
    public ResourceLocation slideSoundLoc = new ResourceLocation("grapplemod", "slide");
    List<ItemStack> grapplingHookVariants = null;

    @Override
    public void startRocket(Player player, GrappleCustomization custom) {
        ClientControllerManager.instance.startRocket(player, custom);
    }

    @Override
    public String getKeyname(ClientProxyInterface.McKeys keyenum) {
        KeyMapping binding = null;
        Options gs = Minecraft.m_91087_().f_91066_;
        if (keyenum == ClientProxyInterface.McKeys.keyBindAttack) {
            binding = gs.f_92096_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindBack) {
            binding = gs.f_92087_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindForward) {
            binding = gs.f_92085_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindJump) {
            binding = gs.f_92089_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindLeft) {
            binding = gs.f_92086_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindRight) {
            binding = gs.f_92088_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindSneak) {
            binding = gs.f_92090_;
        } else if (keyenum == ClientProxyInterface.McKeys.keyBindUseItem) {
            binding = gs.f_92095_;
        }
        if (binding == null) {
            return "";
        }
        String displayname = binding.m_90863_().getString();
        if (displayname.equals("Button 1")) {
            return "Left Click";
        }
        if (displayname.equals("Button 2")) {
            return "Right Click";
        }
        return displayname;
    }

    @Override
    public void openModifierScreen(TileEntityGrappleModifier tileent) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiModifier(tileent));
    }

    @Override
    public String localize(String string) {
        return I18n.m_118938_((String)string, (Object[])new Object[0]);
    }

    @Override
    public void onMessageReceivedClient(BaseMessageClient msg, NetworkEvent.Context ctx) {
        msg.processMessage(ctx);
    }

    @Override
    public void playSlideSound(Entity entity) {
        this.playSound(this.slideSoundLoc, GrappleConfig.getClientConf().sounds.slide_sound_volume);
    }

    @Override
    public void playDoubleJumpSound(Entity entity) {
        this.playSound(this.doubleJumpSoundLoc, GrappleConfig.getClientConf().sounds.doublejump_sound_volume * 0.7f);
    }

    @Override
    public void playWallrunJumpSound(Entity entity) {
        this.playSound(this.doubleJumpSoundLoc, GrappleConfig.getClientConf().sounds.wallrunjump_sound_volume * 0.7f);
    }

    @Override
    public void fillGrappleVariants(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!Minecraft.m_91087_().m_91396_() || Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.f_19853_ == null || Minecraft.m_91087_().f_91074_.f_19853_.m_7465_() == null) {
            return;
        }
        if (this.grapplingHookVariants == null) {
            this.grapplingHookVariants = new ArrayList<ItemStack>();
            RecipeManager recipemanager = Minecraft.m_91087_().f_91074_.f_19853_.m_7465_();
            recipemanager.m_44073_().filter(loc -> loc.m_135827_().equals("grapplemod")).forEach(loc -> {
                ItemStack stack = ((Recipe)recipemanager.m_44043_(loc).get()).m_8043_();
                if (stack.m_41720_() instanceof GrapplehookItem && !((GrapplehookItem)CommonSetup.grapplingHookItem.get()).getCustomization(stack).equals(new GrappleCustomization())) {
                    this.grapplingHookVariants.add(stack);
                }
            });
        }
        items.addAll(this.grapplingHookVariants);
    }

    public Screen onConfigScreen(Minecraft mc, Screen screen) {
        return (Screen)AutoConfig.getConfigScreen(GrappleConfig.class, (Screen)screen).get();
    }

    @Override
    public void resetLauncherTime(int playerid) {
        ClientControllerManager.instance.resetLauncherTime(playerid);
    }

    @Override
    public void launchPlayer(Player player) {
        ClientControllerManager.instance.launchPlayer(player);
    }

    @Override
    public void updateRocketRegen(double rocket_active_time, double rocket_refuel_ratio) {
        ClientControllerManager.instance.updateRocketRegen(rocket_active_time, rocket_refuel_ratio);
    }

    @Override
    public double getRocketFunctioning() {
        return ClientControllerManager.instance.getRocketFunctioning();
    }

    @Override
    public boolean isWallRunning(Entity entity, Vec motion) {
        return ClientControllerManager.instance.isWallRunning(entity, motion);
    }

    @Override
    public boolean isSliding(Entity entity, Vec motion) {
        return ClientControllerManager.instance.isSliding(entity, motion);
    }

    @Override
    public GrappleController createControl(int id, int hookEntityId, int entityid, Level world, Vec pos, BlockPos blockpos, GrappleCustomization custom) {
        return ClientControllerManager.instance.createControl(id, hookEntityId, entityid, world, pos, blockpos, custom);
    }

    @Override
    public boolean isKeyDown(ClientProxyInterface.GrappleKeys key) {
        if (key == ClientProxyInterface.GrappleKeys.key_boththrow) {
            return ClientSetup.key_boththrow.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_leftthrow) {
            return ClientSetup.key_leftthrow.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_rightthrow) {
            return ClientSetup.key_rightthrow.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_motoronoff) {
            return ClientSetup.key_motoronoff.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_jumpanddetach) {
            return ClientSetup.key_jumpanddetach.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_slow) {
            return ClientSetup.key_slow.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climb) {
            return ClientSetup.key_climb.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climbup) {
            return ClientSetup.key_climbup.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_climbdown) {
            return ClientSetup.key_climbdown.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_enderlaunch) {
            return ClientSetup.key_enderlaunch.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_rocket) {
            return ClientSetup.key_rocket.m_90857_();
        }
        if (key == ClientProxyInterface.GrappleKeys.key_slide) {
            return ClientSetup.key_slide.m_90857_();
        }
        return false;
    }

    @Override
    public GrappleController unregisterController(int entityId) {
        return ClientControllerManager.unregisterController(entityId);
    }

    @Override
    public double getTimeSinceLastRopeJump(Level world) {
        return GrapplemodUtils.getTime(world) - ClientControllerManager.prevRopeJumpTime;
    }

    @Override
    public void resetRopeJumpTime(Level world) {
        ClientControllerManager.prevRopeJumpTime = GrapplemodUtils.getTime(world);
    }

    @Override
    public boolean isKeyDown(ClientProxyInterface.McKeys keyenum) {
        if (keyenum == ClientProxyInterface.McKeys.keyBindAttack) {
            return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindBack) {
            return Minecraft.m_91087_().f_91066_.f_92087_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindForward) {
            return Minecraft.m_91087_().f_91066_.f_92085_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindJump) {
            return Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindLeft) {
            return Minecraft.m_91087_().f_91066_.f_92086_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindRight) {
            return Minecraft.m_91087_().f_91066_.f_92088_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindSneak) {
            return Minecraft.m_91087_().f_91066_.f_92090_.m_90857_();
        }
        if (keyenum == ClientProxyInterface.McKeys.keyBindUseItem) {
            return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
        }
        return false;
    }

    @Override
    public boolean isMovingSlowly(Entity entity) {
        if (entity instanceof LocalPlayer) {
            return ((LocalPlayer)entity).m_108635_();
        }
        return false;
    }

    @Override
    public void playSound(ResourceLocation loc, float volume) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(loc, SoundSource.PLAYERS, volume, 1.0f, RandomSource.m_216327_(), false, 0, SoundInstance.Attenuation.NONE, player.m_20185_(), player.m_20186_(), player.m_20189_(), false));
    }

    @Override
    public int getWallrunTicks() {
        return ClientControllerManager.instance.ticksWallRunning;
    }

    @Override
    public void setWallrunTicks(int newWallrunTicks) {
        ClientControllerManager.instance.ticksWallRunning = newWallrunTicks;
    }
}

