/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.common;

import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.items.LongFallBoots;
import com.yyon.grapplinghook.network.GrappleDetachMessage;
import com.yyon.grapplinghook.network.LoggedInMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import java.util.HashSet;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class CommonEventHandlers {
    public CommonEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        AutoConfig.register(GrappleConfig.class, Toml4jConfigSerializer::new);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Item item;
        ItemStack stack;
        Player player = event.getPlayer();
        if (player != null && (stack = player.m_21120_(InteractionHand.MAIN_HAND)) != null && (item = stack.m_41720_()) instanceof GrapplehookItem) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity;
        int id;
        boolean isconnected;
        if (!event.getEntity().f_19853_.f_46443_ && (isconnected = ServerControllerManager.allGrapplehookEntities.containsKey(id = (entity = event.getEntity()).m_19879_()))) {
            HashSet<GrapplehookEntity> grapplehookEntities = ServerControllerManager.allGrapplehookEntities.get(id);
            for (GrapplehookEntity hookEntity : grapplehookEntities) {
                hookEntity.removeServer();
            }
            grapplehookEntities.clear();
            ServerControllerManager.attached.remove(id);
            if (GrapplehookItem.grapplehookEntitiesLeft.containsKey(entity)) {
                GrapplehookItem.grapplehookEntitiesLeft.remove(entity);
            }
            if (GrapplehookItem.grapplehookEntitiesRight.containsKey(entity)) {
                GrapplehookItem.grapplehookEntitiesRight.remove(entity);
            }
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entity.f_19853_);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            for (ItemStack armor : player.m_6168_()) {
                if (armor == null || !(armor.m_41720_() instanceof LongFallBoots) || event.getSource() != DamageSource.f_19316_) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            for (ItemStack armor : player.m_6168_()) {
                if (armor == null || !(armor.m_41720_() instanceof LongFallBoots)) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (GrappleConfig.getConf().other.override_allowflight) {
            event.getServer().m_129999_(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getEntity() instanceof ServerPlayer) {
            CommonSetup.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)e.getEntity()), (Object)new LoggedInMessage(GrappleConfig.getConf()));
        } else {
            System.out.println("Not an PlayerEntityMP");
        }
    }
}

