/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.items;

import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.network.DetachSingleHookMessage;
import com.yyon.grapplinghook.network.GrappleDetachMessage;
import com.yyon.grapplinghook.network.KeypressMessage;
import com.yyon.grapplinghook.server.ServerControllerManager;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.GrapplemodUtils;
import com.yyon.grapplinghook.utils.Vec;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrapplehookItem
extends Item
implements KeypressItem {
    public static HashMap<Entity, GrapplehookEntity> grapplehookEntitiesLeft = new HashMap();
    public static HashMap<Entity, GrapplehookEntity> grapplehookEntitiesRight = new HashMap();

    public GrapplehookItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(CommonSetup.tabGrapplemod).m_41503_(GrappleConfig.getConf().grapplinghook.other.default_durability));
    }

    public boolean hasHookEntity(Entity entity) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft(entity);
        GrapplehookEntity hookRight = this.getHookEntityRight(entity);
        return hookLeft != null || hookRight != null;
    }

    public void setHookEntityLeft(Entity entity, GrapplehookEntity hookEntity) {
        grapplehookEntitiesLeft.put(entity, hookEntity);
    }

    public void setHookEntityRight(Entity entity, GrapplehookEntity hookEntity) {
        grapplehookEntitiesRight.put(entity, hookEntity);
    }

    public GrapplehookEntity getHookEntityLeft(Entity entity) {
        GrapplehookEntity hookEntity;
        if (grapplehookEntitiesLeft.containsKey(entity) && (hookEntity = grapplehookEntitiesLeft.get(entity)) != null && hookEntity.m_6084_()) {
            return hookEntity;
        }
        return null;
    }

    public GrapplehookEntity getHookEntityRight(Entity entity) {
        GrapplehookEntity hookEntity;
        if (grapplehookEntitiesRight.containsKey(entity) && (hookEntity = grapplehookEntitiesRight.get(entity)) != null && hookEntity.m_6084_()) {
            return hookEntity;
        }
        return null;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repair) {
        if (repair != null && repair.m_41720_().equals(Items.f_42454_)) {
            return true;
        }
        return super.m_6832_(stack, repair);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return true;
    }

    public boolean m_6777_(BlockState p_195938_1_, Level p_195938_2_, BlockPos p_195938_3_, Player p_195938_4_) {
        return false;
    }

    @Override
    public void onCustomKeyDown(ItemStack stack, Player player, KeypressItem.Keys key, boolean ismainhand) {
        if (player.f_19853_.f_46443_) {
            if (key == KeypressItem.Keys.LAUNCHER) {
                if (this.getCustomization((ItemStack)stack).enderstaff) {
                    ClientProxyInterface.proxy.launchPlayer(player);
                }
            } else if (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT || key == KeypressItem.Keys.THROWBOTH) {
                CommonSetup.network.sendToServer((Object)new KeypressMessage(key, true));
            } else if (key == KeypressItem.Keys.ROCKET) {
                GrappleCustomization custom = this.getCustomization(stack);
                if (custom.rocket) {
                    ClientProxyInterface.proxy.startRocket(player, custom);
                }
            }
        } else {
            GrappleCustomization custom = this.getCustomization(stack);
            if (key == KeypressItem.Keys.THROWBOTH || !custom.doublehook && (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT)) {
                this.throwBoth(stack, player.f_19853_, (LivingEntity)player, ismainhand);
            } else if (key == KeypressItem.Keys.THROWLEFT) {
                GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)player);
                if (hookLeft != null) {
                    this.detachLeft((LivingEntity)player);
                    return;
                }
                stack.m_41622_(1, (LivingEntity)((ServerPlayer)player), p -> {});
                if (stack.m_41613_() <= 0) {
                    return;
                }
                boolean threw = this.throwLeft(stack, player.f_19853_, (LivingEntity)player, ismainhand);
                if (threw) {
                    player.f_19853_.m_6263_((Player)null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (player.m_217043_().m_188501_() * 0.4f + 1.2f) + 1.0f);
                }
            } else if (key == KeypressItem.Keys.THROWRIGHT) {
                GrapplehookEntity hookRight = this.getHookEntityRight((Entity)player);
                if (hookRight != null) {
                    this.detachRight((LivingEntity)player);
                    return;
                }
                stack.m_41622_(1, (LivingEntity)((ServerPlayer)player), p -> {});
                if (stack.m_41613_() <= 0) {
                    return;
                }
                this.throwRight(stack, player.f_19853_, (LivingEntity)player, ismainhand);
                player.f_19853_.m_6263_((Player)null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (player.m_217043_().m_188501_() * 0.4f + 1.2f) + 1.0f);
            }
        }
    }

    @Override
    public void onCustomKeyUp(ItemStack stack, Player player, KeypressItem.Keys key, boolean ismainhand) {
        if (player.f_19853_.f_46443_) {
            if (key == KeypressItem.Keys.THROWLEFT || key == KeypressItem.Keys.THROWRIGHT || key == KeypressItem.Keys.THROWBOTH) {
                CommonSetup.network.sendToServer((Object)new KeypressMessage(key, false));
            }
        } else {
            GrappleCustomization custom = this.getCustomization(stack);
            if (custom.detachonkeyrelease) {
                GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)player);
                GrapplehookEntity hookRight = this.getHookEntityRight((Entity)player);
                if (key == KeypressItem.Keys.THROWBOTH) {
                    this.detachBoth((LivingEntity)player);
                } else if (key == KeypressItem.Keys.THROWLEFT) {
                    if (hookLeft != null) {
                        this.detachLeft((LivingEntity)player);
                    }
                } else if (key == KeypressItem.Keys.THROWRIGHT && hookRight != null) {
                    this.detachRight((LivingEntity)player);
                }
            }
        }
    }

    public void throwBoth(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean righthand) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        if (hookLeft != null || hookRight != null) {
            this.detachBoth(entityLiving);
            return;
        }
        stack.m_41622_(1, (LivingEntity)((ServerPlayer)entityLiving), p -> {});
        if (stack.m_41613_() <= 0) {
            return;
        }
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        if (entityLiving.m_6047_()) {
            angle = custom.sneakingangle;
        }
        if (custom.doublehook && angle != 0.0) {
            this.throwLeft(stack, worldIn, entityLiving, righthand);
        }
        this.throwRight(stack, worldIn, entityLiving, righthand);
        entityLiving.f_19853_.m_6263_((Player)null, entityLiving.m_20182_().f_82479_, entityLiving.m_20182_().f_82480_, entityLiving.m_20182_().f_82481_, SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (worldIn.f_46441_.m_188501_() * 0.4f + 1.2f) + 1.0f);
    }

    public boolean throwLeft(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean righthand) {
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        double verticalangle = custom.verticalthrowangle;
        if (entityLiving.m_6047_()) {
            angle = custom.sneakingangle;
            verticalangle = custom.sneakingverticalthrowangle;
        }
        LivingEntity player = entityLiving;
        Vec anglevec = Vec.fromAngles(Math.toRadians(-angle), Math.toRadians(verticalangle));
        anglevec = anglevec.rotatePitch(Math.toRadians(-player.m_5686_(1.0f)));
        anglevec = anglevec.rotateYaw(Math.toRadians(player.m_5675_(1.0f)));
        float velx = -Mth.m_14031_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        float vely = -Mth.m_14031_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        float velz = Mth.m_14089_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
        GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, false, true);
        float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
        if (extravelocity < 0.0f) {
            extravelocity = 0.0f;
        }
        hookEntity.m_6686_(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
        worldIn.m_7967_((Entity)hookEntity);
        this.setHookEntityLeft((Entity)entityLiving, hookEntity);
        return true;
    }

    public void throwRight(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean righthand) {
        GrappleCustomization custom = this.getCustomization(stack);
        double angle = custom.angle;
        double verticalangle = custom.verticalthrowangle;
        if (entityLiving.m_6047_()) {
            angle = custom.sneakingangle;
            verticalangle = custom.sneakingverticalthrowangle;
        }
        if (!custom.doublehook || angle == 0.0) {
            GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, righthand, false);
            Vec anglevec = new Vec(0.0, 0.0, 1.0).rotatePitch(Math.toRadians(verticalangle));
            anglevec = anglevec.rotatePitch(Math.toRadians(-entityLiving.m_5686_(1.0f)));
            anglevec = anglevec.rotateYaw(Math.toRadians(entityLiving.m_5675_(1.0f)));
            float velx = -Mth.m_14031_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float vely = -Mth.m_14031_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float velz = Mth.m_14089_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
            if (extravelocity < 0.0f) {
                extravelocity = 0.0f;
            }
            hookEntity.m_6686_(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
            this.setHookEntityRight((Entity)entityLiving, hookEntity);
            worldIn.m_7967_((Entity)hookEntity);
        } else {
            LivingEntity player = entityLiving;
            Vec anglevec = Vec.fromAngles(Math.toRadians(angle), Math.toRadians(verticalangle));
            anglevec = anglevec.rotatePitch(Math.toRadians(-player.m_5686_(1.0f)));
            anglevec = anglevec.rotateYaw(Math.toRadians(player.m_5675_(1.0f)));
            float velx = -Mth.m_14031_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float vely = -Mth.m_14031_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            float velz = Mth.m_14089_((float)((float)anglevec.getYaw() * ((float)Math.PI / 180))) * Mth.m_14089_((float)((float)anglevec.getPitch() * ((float)Math.PI / 180)));
            GrapplehookEntity hookEntity = this.createGrapplehookEntity(stack, worldIn, entityLiving, true, true);
            float extravelocity = (float)Vec.motionVec((Entity)entityLiving).distAlong(new Vec(velx, vely, velz));
            if (extravelocity < 0.0f) {
                extravelocity = 0.0f;
            }
            hookEntity.m_6686_(velx, vely, velz, hookEntity.getVelocity() + extravelocity, 0.0f);
            worldIn.m_7967_((Entity)hookEntity);
            this.setHookEntityRight((Entity)entityLiving, hookEntity);
        }
    }

    public void detachBoth(LivingEntity entityLiving) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        this.setHookEntityLeft((Entity)entityLiving, null);
        this.setHookEntityRight((Entity)entityLiving, null);
        if (hookLeft != null) {
            hookLeft.removeServer();
        }
        if (hookRight != null) {
            hookRight.removeServer();
        }
        int id = entityLiving.m_19879_();
        GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), entityLiving.m_19879_(), entityLiving.f_19853_);
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public void detachLeft(LivingEntity entityLiving) {
        GrapplehookEntity hookLeft = this.getHookEntityLeft((Entity)entityLiving);
        this.setHookEntityLeft((Entity)entityLiving, null);
        if (hookLeft != null) {
            hookLeft.removeServer();
        }
        int id = entityLiving.m_19879_();
        if (this.getHookEntityRight((Entity)entityLiving) == null) {
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entityLiving.f_19853_);
        } else {
            GrapplemodUtils.sendToCorrectClient(new DetachSingleHookMessage(id, hookLeft.m_19879_()), id, entityLiving.f_19853_);
        }
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public void detachRight(LivingEntity entityLiving) {
        GrapplehookEntity hookRight = this.getHookEntityRight((Entity)entityLiving);
        this.setHookEntityRight((Entity)entityLiving, null);
        if (hookRight != null) {
            hookRight.removeServer();
        }
        int id = entityLiving.m_19879_();
        if (this.getHookEntityLeft((Entity)entityLiving) == null) {
            GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, entityLiving.f_19853_);
        } else {
            GrapplemodUtils.sendToCorrectClient(new DetachSingleHookMessage(id, hookRight.m_19879_()), id, entityLiving.f_19853_);
        }
        if (ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
    }

    public double getAngle(LivingEntity entity, ItemStack stack) {
        GrappleCustomization custom = this.getCustomization(stack);
        if (entity.m_6047_()) {
            return custom.sneakingangle;
        }
        return custom.angle;
    }

    public GrapplehookEntity createGrapplehookEntity(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean righthand, boolean isdouble) {
        GrapplehookEntity hookEntity = new GrapplehookEntity(worldIn, entityLiving, righthand, this.getCustomization(stack), isdouble);
        ServerControllerManager.addGrapplehookEntity(entityLiving.m_19879_(), hookEntity);
        return hookEntity;
    }

    public GrappleCustomization getCustomization(ItemStack itemstack) {
        CompoundTag tag = itemstack.m_41784_();
        if (tag.m_128441_("custom")) {
            GrappleCustomization custom = new GrappleCustomization();
            custom.loadNBT(tag.m_128469_("custom"));
            return custom;
        }
        GrappleCustomization custom = this.getDefaultCustomization();
        CompoundTag nbt = custom.writeNBT();
        tag.m_128365_("custom", (Tag)nbt);
        itemstack.m_41751_(tag);
        return custom;
    }

    public GrappleCustomization getDefaultCustomization() {
        return new GrappleCustomization();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag par4) {
        GrappleCustomization custom = this.getCustomization(stack);
        if (Screen.m_96638_()) {
            if (!custom.detachonkeyrelease) {
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_boththrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throw.desc"))));
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_boththrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.release.desc"))));
                list.add((Component)Component.m_237113_((String)(ClientProxyInterface.proxy.localize("grappletooltip.double.desc") + ClientSetup.key_boththrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.releaseandthrow.desc"))));
            } else {
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_boththrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwhold.desc"))));
            }
            list.add((Component)Component.m_237113_((String)(ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindForward) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindLeft) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindBack) + ", " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindRight) + " " + ClientProxyInterface.proxy.localize("grappletooltip.swing.desc"))));
            list.add((Component)Component.m_237113_((String)(ClientSetup.key_jumpanddetach.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.jump.desc"))));
            list.add((Component)Component.m_237113_((String)(ClientSetup.key_slow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.slow.desc"))));
            list.add((Component)Component.m_237113_((String)(ClientSetup.key_climb.m_90863_().getString() + " + " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindForward) + " / " + ClientSetup.key_climbup.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.climbup.desc"))));
            list.add((Component)Component.m_237113_((String)(ClientSetup.key_climb.m_90863_().getString() + " + " + ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindBack) + " / " + ClientSetup.key_climbdown.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.climbdown.desc"))));
            if (custom.enderstaff) {
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_enderlaunch.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.enderlaunch.desc"))));
            }
            if (custom.rocket) {
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_rocket.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.rocket.desc"))));
            }
            if (custom.motor) {
                if (custom.motorwhencrouching && !custom.motorwhennotcrouching) {
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_motoronoff.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.motoron.desc"))));
                } else if (!custom.motorwhencrouching && custom.motorwhennotcrouching) {
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_motoronoff.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.motoroff.desc"))));
                }
            }
            if (custom.doublehook) {
                if (!custom.detachonkeyrelease) {
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_leftthrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwleft.desc"))));
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_rightthrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwright.desc"))));
                } else {
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_leftthrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwlefthold.desc"))));
                    list.add((Component)Component.m_237113_((String)(ClientSetup.key_rightthrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwrighthold.desc"))));
                }
            } else {
                list.add((Component)Component.m_237113_((String)(ClientSetup.key_rightthrow.m_90863_().getString() + " " + ClientProxyInterface.proxy.localize("grappletooltip.throwalt.desc"))));
            }
            if (custom.reelin) {
                list.add((Component)Component.m_237113_((String)(ClientProxyInterface.proxy.getKeyname(ClientProxyInterface.McKeys.keyBindSneak) + " " + ClientProxyInterface.proxy.localize("grappletooltip.reelin.desc"))));
            }
        } else if (Screen.m_96637_()) {
            for (String option : GrappleCustomization.booleanoptions) {
                if (!custom.isOptionValid(option) || custom.getBoolean(option) == GrappleCustomization.DEFAULT.getBoolean(option)) continue;
                list.add((Component)Component.m_237113_((String)((String)(custom.getBoolean(option) ? "" : ClientProxyInterface.proxy.localize("grappletooltip.negate.desc") + " ") + ClientProxyInterface.proxy.localize(custom.getName(option)))));
            }
            for (String option : GrappleCustomization.doubleoptions) {
                if (!custom.isOptionValid(option) || custom.getDouble(option) == GrappleCustomization.DEFAULT.getDouble(option)) continue;
                list.add((Component)Component.m_237113_((String)(ClientProxyInterface.proxy.localize(custom.getName(option)) + ": " + Math.floor(custom.getDouble(option) * 100.0) / 100.0)));
            }
        } else {
            if (custom.doublehook) {
                list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("doublehook"))));
            }
            if (custom.motor) {
                if (custom.smartmotor) {
                    list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("smartmotor"))));
                } else {
                    list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("motor"))));
                }
            }
            if (custom.enderstaff) {
                list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("enderstaff"))));
            }
            if (custom.rocket) {
                list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("rocket"))));
            }
            if (custom.attract) {
                list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("attract"))));
            }
            if (custom.repel) {
                list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize(custom.getName("repel"))));
            }
            list.add((Component)Component.m_237113_((String)""));
            list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize("grappletooltip.shiftcontrols.desc")));
            list.add((Component)Component.m_237113_((String)ClientProxyInterface.proxy.localize("grappletooltip.controlconfiguration.desc")));
        }
    }

    public void setCustomOnServer(ItemStack helditemstack, GrappleCustomization custom, Player player) {
        CompoundTag tag = helditemstack.m_41784_();
        CompoundTag nbt = custom.writeNBT();
        tag.m_128365_("custom", (Tag)nbt);
        helditemstack.m_41751_(tag);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        int id = player.m_19879_();
        GrapplemodUtils.sendToCorrectClient(new GrappleDetachMessage(id), id, player.f_19853_);
        if (!player.f_19853_.f_46443_ && ServerControllerManager.attached.contains(id)) {
            ServerControllerManager.attached.remove(id);
        }
        if (grapplehookEntitiesLeft.containsKey(player)) {
            GrapplehookEntity hookLeft = grapplehookEntitiesLeft.get(player);
            this.setHookEntityLeft((Entity)player, null);
            if (hookLeft != null) {
                hookLeft.removeServer();
            }
        }
        if (grapplehookEntitiesRight.containsKey(player)) {
            GrapplehookEntity hookRight = grapplehookEntitiesRight.get(player);
            this.setHookEntityLeft((Entity)player, null);
            if (hookRight != null) {
                hookRight.removeServer();
            }
        }
        return super.onDroppedByPlayer(item, player);
    }

    public boolean getPropertyRocket(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).rocket;
    }

    public boolean getPropertyDouble(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).doublehook;
    }

    public boolean getPropertyMotor(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).motor;
    }

    public boolean getPropertySmart(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).smartmotor;
    }

    public boolean getPropertyEnderstaff(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).enderstaff;
    }

    public boolean getPropertyMagnet(ItemStack stack, Level world, LivingEntity entity) {
        return this.getCustomization((ItemStack)stack).attract || this.getCustomization((ItemStack)stack).repel;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            items.add((Object)stack);
            if (ClientProxyInterface.proxy != null) {
                ClientProxyInterface.proxy.fillGrappleVariants(tab, items);
            }
        }
    }

    public boolean getPropertyHook(ItemStack stack, Level world, LivingEntity entity) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("hook");
    }
}

