/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class DisplayEntryRenderHelper {
    private static final NavigableMap<Integer, Character> MAP = ImmutableSortedMap.naturalOrder().put((Object)1000, (Object)Character.valueOf('K')).put((Object)1000000, (Object)Character.valueOf('M')).put((Object)1000000000, (Object)Character.valueOf('B')).build();

    private static MutableComponent shortenValue(int value) {
        Map.Entry<Integer, Character> entry = MAP.floorEntry(value);
        if (entry == null) {
            return Component.m_237113_((String)String.valueOf(value));
        }
        return Component.m_237113_((String)(String.valueOf(value / entry.getKey()) + entry.getValue()));
    }

    public static void renderGuiItemDecorations(ItemRenderer itemRenderer, Font font, int count, int xPosition, int yPosition) {
        if (count <= 1 && !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        MutableComponent component = DisplayEntryRenderHelper.shortenValue(count);
        poseStack.m_85837_(0.0, 0.0, (double)(itemRenderer.f_115093_ + 200.0f));
        float scale = Math.min(1.0f, 16.0f / (float)font.m_92852_((FormattedText)component));
        poseStack.m_85841_(scale, scale, 1.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        float posX = (float)(xPosition + 17) / scale - (float)font.m_92852_((FormattedText)component);
        Objects.requireNonNull(font);
        float f = (float)(yPosition + 9 * 2) / scale;
        Objects.requireNonNull(font);
        float posY = f - 9.0f;
        font.m_92841_((Component)component, posX, posY, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)bufferSource, false, 0, 0xF000F0);
        bufferSource.m_109911_();
    }

    public static void renderTooltipInternal(PoseStack poseStack, int posX, int posY, int width, int height, int alpha) {
        poseStack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        int color = DisplayEntryRenderHelper.applyAlphaComponent(-267386864, alpha);
        int blitOffset = 0;
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 4, posX + width + 3, posY - 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY + height + 3, posX + width + 3, posY + height + 4, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3, posX + width + 3, posY + height + 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 4, posY - 3, posX - 3, posY + height + 3, blitOffset, color, color);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX + width + 3, posY - 3, posX + width + 4, posY + height + 3, blitOffset, color, color);
        int colorA = DisplayEntryRenderHelper.applyAlphaComponent(0x505000FF, alpha);
        int colorB = DisplayEntryRenderHelper.applyAlphaComponent(1344798847, alpha);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3 + 1, posX - 3 + 1, posY + height + 3 - 1, blitOffset, colorA, colorB);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX + width + 2, posY - 3 + 1, posX + width + 3, posY + height + 3 - 1, blitOffset, colorA, colorB);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY - 3, posX + width + 3, posY - 3 + 1, blitOffset, colorA, colorA);
        DisplayEntryRenderHelper.fillGradient(matrix4f, bufferBuilder, posX - 3, posY + height + 2, posX + width + 3, posY + height + 3, blitOffset, colorB, colorB);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        poseStack.m_85849_();
    }

    private static int applyAlphaComponent(int color, int alpha) {
        return color & 0xFFFFFF | Math.min(color >> 24 & 0xFF, alpha) << 24;
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int blitOffset, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float g = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float h = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float i = (float)(colorA & 0xFF) / 255.0f;
        float j = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float k = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float l = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float m = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, (float)blitOffset).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, (float)blitOffset).m_85950_(g, h, i, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, (float)blitOffset).m_85950_(k, l, m, j).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, (float)blitOffset).m_85950_(k, l, m, j).m_5752_();
    }
}

