/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class ItemDisplayEntry
extends DisplayEntry {
    private final ItemStack stack;

    public ItemDisplayEntry(ItemStack stack, int amount) {
        super(amount, stack.m_41791_());
        this.stack = stack;
    }

    @Override
    protected Component getEntryName() {
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries ? this.stack.m_41720_().m_7626_(this.stack) : this.stack.m_41786_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayMergeWith(DisplayEntry other) {
        if (!(other instanceof ItemDisplayEntry)) return false;
        ItemDisplayEntry itemDisplayEntry = (ItemDisplayEntry)other;
        if (!this.sameItem(itemDisplayEntry.stack)) return false;
        return true;
    }

    private boolean sameItem(ItemStack other) {
        return this.stack.m_41720_() == other.m_41720_() && this.stack.m_41720_().m_7626_(this.stack).equals(other.m_41720_().m_7626_(other));
    }

    @Override
    protected int getInventoryCount(Inventory inventory) {
        return ContainerHelper.m_18956_((Container)inventory, this::sameItem, (int)Integer.MAX_VALUE, (boolean)true);
    }

    @Override
    protected void renderSprite(Minecraft minecraft, PoseStack poseStack, int posX, int posY, float scale) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157182_();
        minecraft.m_91291_().m_115203_(this.stack, posX, posY);
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.sprite()) {
            DisplayEntryRenderHelper.renderGuiItemDecorations(minecraft.m_91291_(), minecraft.f_91062_, this.getDisplayAmount(), posX, posY);
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

