/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import me.flashyreese.mods.reeses_sodium_options.ReesesSodiumOptions;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.BasicFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.TabFrame;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SodiumVideoOptionsScreen
extends Screen {
    private static final AtomicReference<Component> tabFrameSelectedTab = new AtomicReference<Object>(null);
    private static final AtomicReference<Integer> tabFrameScrollBarOffset = new AtomicReference<Integer>(0);
    private static final AtomicReference<Integer> optionPageScrollBarOffset = new AtomicReference<Integer>(0);
    private final Screen prevScreen;
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private AbstractFrame frame;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;

    public SodiumVideoOptionsScreen(Screen prev, List<OptionPage> pages) {
        super((Component)Component.m_237113_((String)"Reese's Sodium Menu"));
        this.prevScreen = prev;
        this.pages.addAll(pages);
    }

    protected void m_7856_() {
        this.frame = this.parentFrameBuilder().build();
        this.m_142416_((GuiEventListener)this.frame);
    }

    protected BasicFrame.Builder parentFrameBuilder() {
        int newWidth = this.f_96543_;
        if ((double)((float)this.f_96543_ / (float)this.f_96544_) > 1.77777777778) {
            newWidth = (int)((double)this.f_96544_ * 1.77777777778);
        }
        Dim2i basicFrameDim = new Dim2i((this.f_96543_ - newWidth) / 2, 0, newWidth, this.f_96544_);
        Dim2i tabFrameDim = new Dim2i(basicFrameDim.x() + basicFrameDim.width() / 20 / 2, basicFrameDim.y() + basicFrameDim.height() / 4 / 2, basicFrameDim.width() - basicFrameDim.width() / 20, basicFrameDim.height() / 4 * 3);
        Dim2i undoButtonDim = new Dim2i(tabFrameDim.getLimitX() - 203, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i applyButtonDim = new Dim2i(tabFrameDim.getLimitX() - 134, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i closeButtonDim = new Dim2i(tabFrameDim.getLimitX() - 65, tabFrameDim.getLimitY() + 5, 65, 20);
        Dim2i donateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 122, tabFrameDim.y() - 26, 100, 20);
        Dim2i hideDonateButtonDim = new Dim2i(tabFrameDim.getLimitX() - 20, tabFrameDim.y() - 26, 20, 20);
        this.undoButton = new FlatButtonWidget(undoButtonDim, (Component)Component.m_237115_((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(applyButtonDim, (Component)Component.m_237115_((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(closeButtonDim, (Component)Component.m_237115_((String)"gui.done"), this::m_7379_);
        this.donateButton = new FlatButtonWidget(donateButtonDim, (Component)Component.m_237115_((String)"sodium.options.buttons.donate"), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(hideDonateButtonDim, (Component)Component.m_237113_((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hideDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        BasicFrame.Builder basicFrameBuilder = this.parentBasicFrameBuilder(basicFrameDim, tabFrameDim);
        if (ReesesSodiumOptions.oculusLoaded) {
            int size = this.f_96541_.f_91062_.m_92852_((FormattedText)Component.m_237115_((String)IrisApi.getInstance().getMainScreenLanguageKey()));
            Dim2i shaderPackButtonDim = !SodiumClientMod.options().notifications.hideDonationButton ? new Dim2i(tabFrameDim.getLimitX() - 134 - size, tabFrameDim.y() - 26, 10 + size, 20) : new Dim2i(tabFrameDim.getLimitX() - size - 10, tabFrameDim.y() - 26, 10 + size, 20);
            FlatButtonWidget shaderPackButton = new FlatButtonWidget(shaderPackButtonDim, (Component)Component.m_237115_((String)IrisApi.getInstance().getMainScreenLanguageKey()), () -> this.f_96541_.m_91152_((Screen)IrisApi.getInstance().openMainIrisScreenObj((Object)this)));
            basicFrameBuilder.addChild(dim -> shaderPackButton);
        }
        return basicFrameBuilder;
    }

    public BasicFrame.Builder parentBasicFrameBuilder(Dim2i parentBasicFrameDim, Dim2i tabFrameDim) {
        return BasicFrame.createBuilder().setDimension(parentBasicFrameDim).shouldRenderOutline(false).addChild(dim -> this.undoButton).addChild(dim -> this.applyButton).addChild(dim -> this.closeButton).addChild(dim -> this.donateButton).addChild(dim -> this.hideDonateButton).addChild(parentDim -> TabFrame.createBuilder().setDimension(tabFrameDim).shouldRenderOutline(false).setTabSectionScrollBarOffset(tabFrameScrollBarOffset).setTabSectionSelectedTab(tabFrameSelectedTab).addTabs(tabs -> this.pages.stream().filter(page -> !page.getGroups().isEmpty()).forEach(page -> tabs.add(Tab.createBuilder().from((OptionPage)page, optionPageScrollBarOffset)))).onSetTab(() -> optionPageScrollBarOffset.set(0)).build());
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_7333_(matrices);
        this.updateControls();
        this.frame.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private void updateControls() {
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hideDonationButton = true;
        try {
            options.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
        this.m_169411_((GuiEventListener)this.frame);
        this.frame = this.parentFrameBuilder().build();
        this.m_142416_((GuiEventListener)this.frame);
    }

    private void openDonationPage() {
        Util.m_137581_().m_137646_("https://caffeinemc.net/donate");
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        Minecraft client = Minecraft.m_91087_();
        if (flags.contains(OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            client.f_91060_.m_109818_();
        }
        if (flags.contains(OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.m_91312_(((Integer)client.f_91066_.m_232119_().m_231551_()).intValue());
            client.m_91088_();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 80 && (modifiers & 1) != 0) {
            Minecraft.m_91087_().m_91152_((Screen)new VideoSettingsScreen(this.prevScreen, Minecraft.m_91087_().f_91066_));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return !this.hasPendingChanges;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.prevScreen);
    }
}

