/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.cullleaves.mixin;

import eu.midnightdust.cullleaves.config.CullLeavesConfig;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.util.ElementRange;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.RegionChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RegionChunkRenderer.class}, remap=false, priority=1100)
public abstract class MixinRegionChunkRenderer
extends ShaderChunkRenderer {
    @Shadow
    @Final
    private boolean isBlockFaceCullingEnabled;
    @Unique
    private boolean doFix = false;
    @Unique
    private ChunkCameraContext camera;
    @Unique
    private ChunkRenderBounds bounds;

    @Shadow
    protected abstract void addDrawCall(ElementRange var1, long var2, int var4);

    public MixinRegionChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        super(device, vertexType);
    }

    @Inject(method={"buildDrawBatches"}, at={@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;getBounds()Lme/jellysquid/mods/sodium/client/render/chunk/data/ChunkRenderBounds;", ordinal=0)})
    public void cullleaves$shouldApplyTransparentBlockFaceCullingFix(List<RenderSection> sections, BlockRenderPass pass, ChunkCameraContext camera, CallbackInfoReturnable<Boolean> cir) {
        this.doFix = pass.getAlphaCutoff() != 0.0f && CullLeavesConfig.enabled && CullLeavesConfig.sodiumBlockFaceCullingFix && this.isBlockFaceCullingEnabled;
        this.camera = camera;
    }

    @Redirect(method={"buildDrawBatches"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;getBounds()Lme/jellysquid/mods/sodium/client/render/chunk/data/ChunkRenderBounds;", ordinal=0))
    public ChunkRenderBounds cullleaves$getChunkRenderBounds(RenderSection instance) {
        this.bounds = instance.getBounds();
        return this.bounds;
    }

    @Redirect(method={"buildDrawBatches"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/ChunkGraphicsState;getModelPart(Lme/jellysquid/mods/sodium/client/model/quad/properties/ModelQuadFacing;)Lme/jellysquid/mods/sodium/client/gl/util/ElementRange;", ordinal=0))
    public ElementRange cullleaves$fixTransparentBlockFaceCulling(ChunkGraphicsState state, ModelQuadFacing facing) {
        if (this.doFix) {
            long indexOffset = state.getIndexSegment().getOffset();
            int baseVertex = state.getVertexSegment().getOffset() / this.vertexFormat.getStride();
            if (this.isBlockFaceCullingEnabled) {
                if (this.camera.posY <= this.bounds.y1) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.UP), indexOffset, baseVertex);
                }
                if (this.camera.posY >= this.bounds.y2) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.DOWN), indexOffset, baseVertex);
                }
                if (this.camera.posX <= this.bounds.x1) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.EAST), indexOffset, baseVertex);
                }
                if (this.camera.posX >= this.bounds.x2) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.WEST), indexOffset, baseVertex);
                }
                if (this.camera.posZ <= this.bounds.z1) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.SOUTH), indexOffset, baseVertex);
                }
                if (this.camera.posZ >= this.bounds.z2) {
                    this.addDrawCall(state.getModelPart(ModelQuadFacing.NORTH), indexOffset, baseVertex);
                }
            }
        }
        return state.getModelPart(ModelQuadFacing.UNASSIGNED);
    }
}

