/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec ForgeConfigSpecBuilder;
    public final ForgeConfigSpec.ConfigValue<Integer> dragonDifficulty;
    public final ForgeConfigSpec.ConfigValue<Double> crystalRespawnTimeModifier;
    public final ForgeConfigSpec.ConfigValue<Double> lightningExplosionDensity;
    public final ForgeConfigSpec.ConfigValue<Boolean> disableLightning;
    public final ForgeConfigSpec.ConfigValue<Boolean> printDragonPhases;
    public final ForgeConfigSpec.ConfigValue<Boolean> disableDragonAreaSpawns;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawnoncrystaldestroy;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawnoncrystalrespawn;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> spawnwhilelanded;

    protected CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Dragon settings");
        builder.comment("Sets the dragon difficulty modifier, the higher the more difficult the dragon gets.Scales up mob spawn amount, dragon damage and health aswell as crystal respawn intervals. Note that the difficulty already scales on the playercount involved in the fight, this is a static bonus ontop.default:2, vanilla:0");
        this.dragonDifficulty = builder.defineInRange("dragonDifficulty", 2, 0, 100);
        builder.comment("Prints the dragon phase in chat if enabled: default:false");
        this.printDragonPhases = builder.define("printDragonPhases", false);
        builder.comment("Disables mob spawning on the Dragon island: default:true");
        this.disableDragonAreaSpawns = builder.define("disableDragonAreaSpawns", true);
        builder.comment("Disables lightning spawns: default:false");
        this.disableLightning = builder.define("disableLightning", false);
        builder.comment("Modifies crystal respawn time, 0.5 = spawns twice as fast, 2 = twice as slow. default:1.0");
        this.crystalRespawnTimeModifier = builder.defineInRange("crystalRespawnTimeModifier", 1.0, 0.1, 10.0);
        builder.comment("Modifies lightning and explosion density, 0.5 = half as many, 2 = twice as many. default:1.0");
        this.lightningExplosionDensity = builder.defineInRange("lightningExplosionDensity", 1.0, 0.1, 10.0);
        builder.comment("List of mobs spawning when a crystal is destroyed at range, intended to be flying or ranged to close the gap: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        this.spawnoncrystaldestroy = builder.defineList("spawnoncrystaldestroy", (List)Lists.newArrayList((Object[])new String[]{"minecraft:phantom"}), e -> e instanceof String);
        builder.comment("List of mobs spawning on crystal respawn, intended to be ranged to ward of players from a distance: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        this.spawnoncrystalrespawn = builder.defineList("spawnoncrystalrespawn", (List)Lists.newArrayList((Object[])new String[]{"minecraft:blaze"}), e -> e instanceof String);
        builder.comment("List of mobs spawning while the dragon is sitting in the middle, intended to be melee and not vulnerable to ranged: e.g. format :  [\"minecraft:zombie\", \"minecraft:creeper\"]");
        this.spawnwhilelanded = builder.defineList("spawnwhilelanded", (List)Lists.newArrayList((Object[])new String[]{"minecraft:enderman"}), e -> e instanceof String);
        builder.pop();
        this.ForgeConfigSpecBuilder = builder.build();
    }
}

