/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.modconfig;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.OldUtil;
import com.corosus.modconfig.ConfigComment;
import com.corosus.modconfig.ConfigEntryInfo;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.modconfig.ModConfigData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="coroutil")
public class ConfigMod {
    public static ConfigMod instance;
    public static List<ModConfigData> configs;
    public static List<ModConfigData> liveEditConfigs;
    public static HashMap<String, ModConfigData> lookupRegistryNameToConfig;
    public static HashMap<String, ModConfigData> lookupFilePathToConfig;
    public static final String MODID = "coroutil";

    public ConfigMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent event) {
        ConfigMod.dbg("Performing a full config mod force sync");
        ConfigMod.updateAllConfigsFromForge();
    }

    public static void onReload(ModConfigEvent.Reloading configEvent) {
        ModConfigData configData = lookupFilePathToConfig.get(configEvent.getConfig().getFileName());
        if (configData != null) {
            ConfigMod.dbg("Coro ConfigMod updating runtime values for file: " + configEvent.getConfig().getFileName());
            configData.updateConfigFieldValues();
            configData.configInstance.hookUpdatedValues();
        } else {
            ConfigMod.dbg("ERROR, cannot find ModConfigData reference for filename: " + configEvent.getConfig().getFileName());
        }
    }

    public static void updateAllConfigsFromForge() {
        for (ModConfigData configData : lookupFilePathToConfig.values()) {
            ConfigMod.dbg("Coro ConfigMod updating runtime values for file: " + configData.saveFilePath);
            configData.updateConfigFieldValues();
            configData.configInstance.hookUpdatedValues();
        }
    }

    public static void processHashMap(String modid, Map map) {
        for (Map.Entry pairs : map.entrySet()) {
            String name = (String)pairs.getKey();
            Object val = pairs.getValue();
            String comment = ConfigMod.getComment(modid, name);
            ConfigEntryInfo info = new ConfigEntryInfo(ConfigMod.lookupRegistryNameToConfig.get((Object)modid).configData.size(), name, val, comment);
            ConfigMod.lookupRegistryNameToConfig.get((Object)modid).configData.add(info);
        }
    }

    public void initData() {
    }

    public void writeConfigFiles(Boolean resetData) {
    }

    public static void dbg(Object obj) {
        System.out.println(obj);
    }

    public static void addConfigFile(String modID, IConfigCategory configCat) {
        ConfigMod.addConfigFile(modID, configCat.getRegistryName(), configCat, true);
    }

    public static void addConfigFile(String modID, String categoryName, IConfigCategory configCat, boolean liveEdit) {
        if (lookupRegistryNameToConfig.containsKey(configCat.getRegistryName())) {
            return;
        }
        ModConfigData configData = new ModConfigData(configCat.getConfigFileName(), categoryName, configCat.getClass(), configCat);
        configs.add(configData);
        if (liveEdit) {
            liveEditConfigs.add(configData);
        }
        lookupRegistryNameToConfig.put(categoryName, configData);
        lookupFilePathToConfig.put(configCat.getConfigFileName() + ".toml", configData);
        configData.initData();
        configData.writeConfigFile(false);
    }

    public static Object getField(String configID, String name) {
        try {
            return OldUtil.getPrivateValue(ConfigMod.lookupRegistryNameToConfig.get((Object)configID).configClass, instance, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getComment(String configID, String name) {
        try {
            Field field = ConfigMod.lookupRegistryNameToConfig.get((Object)configID).configClass.getDeclaredField(name);
            ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
            return anno_comment == null ? null : anno_comment.value()[0];
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean updateField(String configID, String name, Object obj) {
        if (lookupRegistryNameToConfig.get(configID).setFieldBasedOnType(name, obj)) {
            lookupRegistryNameToConfig.get(configID).writeConfigFile(true);
            return true;
        }
        return false;
    }

    public static void forceSaveAllFilesFromRuntimeSettings() {
        CULog.dbg("forceSaveAllFilesFromRuntimeSettings invoked");
        for (ModConfigData data : lookupRegistryNameToConfig.values()) {
            data.writeConfigFile(true);
        }
    }

    public static void forceLoadRuntimeSettingsFromFile() {
        CULog.dbg("forceSaveAllFilesFromRuntimeSettings invoked");
        for (ModConfigData data : lookupRegistryNameToConfig.values()) {
            data.writeConfigFile(false);
        }
    }

    public static void updateHashMaps() {
    }

    static {
        configs = new ArrayList<ModConfigData>();
        liveEditConfigs = new ArrayList<ModConfigData>();
        lookupRegistryNameToConfig = new HashMap();
        lookupFilePathToConfig = new HashMap();
    }
}

