/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.modconfig;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.OldUtil;
import com.corosus.modconfig.ConfigComment;
import com.corosus.modconfig.ConfigEntryInfo;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfigData {
    public String configID;
    public Class configClass;
    public IConfigCategory configInstance;
    public HashMap<String, String> valsString = new HashMap();
    public HashMap<String, Integer> valsInteger = new HashMap();
    public HashMap<String, Double> valsDouble = new HashMap();
    public HashMap<String, Boolean> valsBoolean = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<String>> valsStringConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Integer>> valsIntegerConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Double>> valsDoubleConfig = new HashMap();
    public HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>> valsBooleanConfig = new HashMap();
    public List<ConfigEntryInfo> configData = new ArrayList<ConfigEntryInfo>();
    public String saveFilePath;

    public ModConfigData(String savePath, String parStr, Class parClass, IConfigCategory parConfig) {
        this.configID = parStr;
        this.configClass = parClass;
        this.configInstance = parConfig;
        this.saveFilePath = savePath;
    }

    public void updateHashMaps() {
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.processField(name);
        }
    }

    public void updateConfigFieldValues() {
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.processFieldFromForgeConfig(name);
        }
    }

    private void processFieldFromForgeConfig(String fieldName) {
        try {
            Object obj = ConfigMod.getField(this.configID, fieldName);
            if (obj instanceof String) {
                this.valsString.put(fieldName, (String)obj);
                String val = (String)this.valsStringConfig.get(fieldName).get();
                this.setFieldBasedOnType(fieldName, val);
            } else if (obj instanceof Integer) {
                this.valsInteger.put(fieldName, (Integer)obj);
                int what = (Integer)this.valsIntegerConfig.get(fieldName).get();
                this.setFieldBasedOnType(fieldName, what);
            } else if (obj instanceof Double) {
                this.valsDouble.put(fieldName, (Double)obj);
                Double val = (Double)this.valsDoubleConfig.get(fieldName).get();
                this.setFieldBasedOnType(fieldName, val);
            } else if (obj instanceof Boolean) {
                this.valsBoolean.put(fieldName, (Boolean)obj);
                Boolean val = (Boolean)this.valsBooleanConfig.get(fieldName).get();
                this.setFieldBasedOnType(fieldName, val);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initData() {
        this.valsString.clear();
        this.valsInteger.clear();
        this.valsDouble.clear();
        this.valsBoolean.clear();
        this.updateHashMaps();
    }

    public boolean updateField(String name, Object obj) {
        if (this.setFieldBasedOnType(name, obj)) {
            this.writeConfigFile(true);
            return true;
        }
        return false;
    }

    public boolean setFieldBasedOnType(String name, Object obj) {
        try {
            if (this.valsString.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, this.configInstance, name, (String)obj);
                this.inputField(name, (String)obj);
            } else if (this.valsInteger.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, this.configInstance, name, Integer.valueOf(obj.toString()));
                this.inputField(name, Integer.valueOf(obj.toString()));
            } else if (this.valsDouble.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, this.configInstance, name, Double.valueOf(obj.toString()));
                this.inputField(name, Double.valueOf(obj.toString()));
            } else if (this.valsBoolean.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, this.configInstance, name, Boolean.valueOf(obj.toString()));
                this.inputField(name, Boolean.valueOf(obj.toString()));
            } else {
                return false;
            }
            this.configInstance.hookUpdatedValues();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void processField(String fieldName) {
        try {
            Object obj = ConfigMod.getField(this.configID, fieldName);
            if (obj instanceof String) {
                this.valsString.put(fieldName, (String)obj);
            } else if (obj instanceof Integer) {
                this.valsInteger.put(fieldName, (Integer)obj);
            } else if (obj instanceof Double) {
                this.valsDouble.put(fieldName, (Double)obj);
            } else if (obj instanceof Boolean) {
                this.valsBoolean.put(fieldName, (Boolean)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void inputField(String fieldName, Object obj) {
        if (obj instanceof String) {
            this.valsString.put(fieldName, (String)obj);
        } else if (obj instanceof Integer) {
            this.valsInteger.put(fieldName, (Integer)obj);
        } else if (obj instanceof Double) {
            this.valsDouble.put(fieldName, (Double)obj);
        } else if (obj instanceof Boolean) {
            this.valsBoolean.put(fieldName, (Boolean)obj);
        }
    }

    public void writeConfigFile(boolean resetConfig) {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment("General mod settings").push("general");
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.addToConfig(BUILDER, field, name);
        }
        CULog.dbg("writeConfigFile invoked for " + this.configID + ", resetConfig: " + resetConfig);
        BUILDER.pop();
        ForgeConfigSpec CONFIG = BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG, this.saveFilePath + ".toml");
    }

    private void addToConfig(ForgeConfigSpec.Builder builder, Field field, String name) {
        Object obj;
        String comment = "";
        ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
        if (anno_comment != null) {
            comment = anno_comment.value()[0];
        }
        if ((obj = ConfigMod.getField(this.configID, name)) instanceof String) {
            builder.comment(comment).define(name, (Object)((String)obj));
            this.valsStringConfig.put(name, (ForgeConfigSpec.ConfigValue<String>)builder.define(name, (Object)((String)obj)));
        } else if (obj instanceof Integer) {
            this.valsIntegerConfig.put(name, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment(comment).defineInRange(name, ((Integer)obj).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE));
        } else if (obj instanceof Double) {
            this.valsDoubleConfig.put(name, (ForgeConfigSpec.ConfigValue<Double>)builder.comment(comment).defineInRange(name, ((Double)obj).doubleValue(), Double.MIN_VALUE, Double.MAX_VALUE));
        } else if (obj instanceof Boolean) {
            this.valsBooleanConfig.put(name, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment(comment).define(name, (Object)((Boolean)obj)));
        }
        this.setFieldBasedOnType(name, obj);
    }
}

