/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.event.GunReloadEvent;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.C2SMessageReload;
import com.mrcrayfish.guns.network.message.C2SMessageUnload;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue() && this.reloadingSlot != player.m_150109_().f_35977_) {
                this.setReloading(false);
            }
            this.updateReloadTimer((Player)player);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (KeyBinds.KEY_RELOAD.m_90857_() && event.getAction() == 1) {
            this.setReloading((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player) == false);
        }
        if (KeyBinds.KEY_UNLOAD.m_90859_() && event.getAction() == 1) {
            this.setReloading(false);
            PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageUnload());
        }
    }

    public void setReloading(boolean reloading) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (reloading) {
                CompoundTag tag;
                ItemStack stack = player.m_21205_();
                if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null && !tag.m_128425_("IgnoreAmmo", 1)) {
                    Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
                    if (tag.m_128451_("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(stack, gun)) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((Player)player, stack))) {
                        return;
                    }
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageReload(true));
                    this.reloadingSlot = player.m_150109_().f_35977_;
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((Player)player, stack));
                }
            } else {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageReload(false));
                this.reloadingSlot = -1;
            }
        }
    }

    private void updateReloadTimer(Player player) {
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            if (this.startReloadTick == -1) {
                this.startReloadTick = player.f_19797_ + 5;
            }
            if (this.reloadTimer < 5) {
                ++this.reloadTimer;
            }
        } else {
            if (this.startReloadTick != -1) {
                this.startReloadTick = -1;
            }
            if (this.reloadTimer > 0) {
                --this.reloadTimer;
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public float getReloadProgress(float partialTicks) {
        return ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / 5.0f;
    }
}

