/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.item.SushiItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AmountItem
extends SushiItem {
    public static final String NBT_AMOUNT = "Amount";
    private final int minAmount;
    private final int maxAmount;
    private final int maxCombineAmount;

    public AmountItem(Item.Properties properties, String category, int minAmount, int maxAmount, int maxCombineAmount, boolean foodHurts) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.3f).m_38762_(new MobEffectInstance(MobEffects.f_19614_, 100, 0), foodHurts ? 0.6f : 0.01f).m_38767_()), category);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.maxCombineAmount = maxCombineAmount;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        super.m_7836_(stack, worldIn, playerIn);
        if (!stack.m_41782_()) {
            stack.m_41784_().m_128405_(NBT_AMOUNT, worldIn.f_46441_.m_188503_(this.maxAmount - this.minAmount) + this.minAmount);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_AMOUNT);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)stack.m_41784_().m_128451_(NBT_AMOUNT) * 13.0f / (float)this.maxCombineAmount);
    }

    public int m_142159_(ItemStack stack) {
        return Color.YELLOW.getRGB();
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Amount: " + stack.m_41783_().m_128451_(NBT_AMOUNT) + "/" + this.maxCombineAmount + " gr.")));
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128405_(NBT_AMOUNT, this.maxAmount / 2);
            items.add((Object)stack);
        }
    }

    public int getCurrentAmount(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_AMOUNT);
    }

    public int getMinAmount() {
        return this.minAmount;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public int getMaxCombineAmount() {
        return this.maxCombineAmount;
    }

    public ItemStack withAmount(int amount) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128405_(NBT_AMOUNT, amount);
        return stack;
    }

    public ItemStack random(Player entity, Level world) {
        int extra = 0;
        if (entity != null && entity.m_21023_((MobEffect)SushiContent.Effects.STEADY_HANDS.get())) {
            extra += (entity.m_21124_((MobEffect)SushiContent.Effects.STEADY_HANDS.get()).m_19564_() + 1) * this.getMinAmount();
        }
        return this.withAmount(Math.min(this.getMaxCombineAmount(), extra + world.f_46441_.m_188503_(this.getMaxAmount() - this.getMinAmount()) + this.getMinAmount()));
    }

    public void consume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)stack.m_41784_().m_128451_(NBT_AMOUNT) - (double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        stack.m_41784_().m_128405_(NBT_AMOUNT, amount);
        if (amount <= 0) {
            stack.m_41774_(1);
        }
    }

    public boolean canConsume(IFoodIngredient ingredient, ItemStack stack, int amountLevel) {
        int amount = (int)((double)(ingredient.getDefaultAmount() * (amountLevel + 1)) / 5.0);
        return !stack.m_41619_() && stack.m_41784_().m_128451_(NBT_AMOUNT) >= amount;
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), this.m_6061_(), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.4f);
            ((Player)entityLiving).m_36324_().m_38707_(stack.m_41720_().m_41473_().m_38744_(), stack.m_41720_().m_41473_().m_38745_());
            for (Pair pair : stack.m_41720_().m_41473_().m_38749_()) {
                if (worldIn.f_46443_ || pair.getFirst() == null || !(worldIn.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                entityLiving.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            if (!((Player)entityLiving).m_150110_().f_35937_) {
                this.consume(FoodAPI.get().getIngredientFromItem(this), stack, 6);
            }
        }
        return stack;
    }

    public static ItemStack combineStacks(ItemStack first, ItemStack second) {
        if (!first.m_150930_(second.m_41720_())) {
            return null;
        }
        Item item = first.m_41720_();
        if (item instanceof AmountItem) {
            AmountItem firstAmount = (AmountItem)item;
            item = second.m_41720_();
            if (item instanceof AmountItem) {
                AmountItem secondAmount = (AmountItem)item;
                first.m_41784_().m_128405_(NBT_AMOUNT, Math.min(firstAmount.getMaxCombineAmount(), firstAmount.getCurrentAmount(first) + secondAmount.getCurrentAmount(second)));
                return first;
            }
        }
        return null;
    }
}

