/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public record ItemStackKey(ItemStack stack) {
    private static final Field CAP_NBT = ObfuscationReflectionHelper.findField(ItemStack.class, (String)"capNBT");

    public ItemStackKey(ItemStack stack) {
        this.stack = stack.m_41777_();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)that.stack);
    }

    public boolean hashCodeNotEquals(ItemStack otherStack) {
        return this.hashCode() != ItemStackKey.getHashCode(otherStack);
    }

    @Override
    public int hashCode() {
        return ItemStackKey.getHashCode(this.stack);
    }

    public static int getHashCode(ItemStack stack) {
        CompoundTag capNbt;
        int hash = stack.m_41720_().hashCode();
        if (stack.m_41782_()) {
            hash = hash * 31 + stack.m_41783_().hashCode();
        }
        if ((capNbt = ItemStackKey.getCapNbt(stack)) != null && !capNbt.m_128456_()) {
            hash = hash * 31 + capNbt.hashCode();
        }
        return hash;
    }

    @Nullable
    private static CompoundTag getCapNbt(ItemStack stack) {
        try {
            return (CompoundTag)CAP_NBT.get(stack);
        }
        catch (IllegalAccessException e) {
            SophisticatedCore.LOGGER.error("Error getting capNBT of stack ", (Throwable)e);
            return null;
        }
    }

    public boolean matches(ItemStack stack) {
        return this.hashCode() == ItemStackKey.getHashCode(stack);
    }
}

