/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ParticleUtil {
    public static void spawnParticleOnBlockShape(Level level, BlockPos pos, ParticleOptions particleOptions, UniformInt uniformInt, float maxSpeed) {
        ParticleUtil.spawnParticleOnBoundingBox(level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83215_().m_82338_(pos), level, particleOptions, uniformInt, maxSpeed);
    }

    public static void spawnParticleOnBoundingBox(AABB bb, Level level, ParticleOptions particleOptions, UniformInt uniformInt, float maxSpeed) {
        double z;
        double z2;
        double dz;
        double dy;
        double dx;
        double y;
        double x;
        int j;
        RandomSource random = level.f_46441_;
        float offset = 0.1f;
        Vec3 blockCenter = new Vec3(bb.f_82288_ - 0.5 + (bb.f_82291_ - bb.f_82288_) / 2.0, bb.f_82289_ - 0.5 + (bb.f_82292_ - bb.f_82289_) / 2.0, bb.f_82290_ - 0.5 + (bb.f_82293_ - bb.f_82290_) / 2.0);
        bb = bb.m_82386_(-blockCenter.f_82479_, -blockCenter.f_82480_, -blockCenter.f_82481_);
        int i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            x = random.m_188500_();
            y = random.m_188500_();
            if (!(x > bb.f_82288_) || !(x < bb.f_82291_) || !(y > bb.f_82289_) || !(y < bb.f_82292_)) continue;
            dx = (double)maxSpeed * level.f_46441_.m_188500_();
            dy = (double)maxSpeed * level.f_46441_.m_188500_();
            dz = 0.0;
            level.m_7106_(particleOptions, blockCenter.f_82479_ + x, blockCenter.f_82480_ + y, blockCenter.f_82481_ + bb.f_82290_ - (double)offset, dx, dy, dz);
        }
        i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            x = random.m_188500_();
            y = random.m_188500_();
            if (!(x > bb.f_82288_) || !(x < bb.f_82291_) || !(y > bb.f_82289_) || !(y < bb.f_82292_)) continue;
            dx = (double)maxSpeed * level.f_46441_.m_188500_();
            dy = (double)maxSpeed * level.f_46441_.m_188500_();
            dz = 0.0;
            level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + y, blockCenter.m_7094_() + bb.f_82293_ + (double)offset, dx, dy, dz);
        }
        i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            z2 = random.m_188500_();
            y = random.m_188500_();
            if (!(z2 > bb.f_82290_) || !(z2 < bb.f_82293_) || !(y > bb.f_82289_) || !(y < bb.f_82292_)) continue;
            dx = 0.0;
            dy = (double)maxSpeed * level.f_46441_.m_188500_();
            dz = (double)maxSpeed * level.f_46441_.m_188500_();
            level.m_7106_(particleOptions, blockCenter.m_7096_() + bb.f_82288_ - (double)offset, blockCenter.m_7098_() + y, blockCenter.m_7094_() + z2, dx, dy, dz);
        }
        i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            z2 = random.m_188500_();
            y = random.m_188500_();
            if (!(z2 > bb.f_82290_) || !(z2 < bb.f_82293_) || !(y > bb.f_82289_) || !(y < bb.f_82292_)) continue;
            dx = 0.0;
            dy = (double)maxSpeed * level.f_46441_.m_188500_();
            dz = (double)maxSpeed * level.f_46441_.m_188500_();
            level.m_7106_(particleOptions, blockCenter.m_7096_() + bb.f_82291_ + (double)offset, blockCenter.m_7098_() + y, blockCenter.m_7094_() + z2, dx, dy, dz);
        }
        i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            x = random.m_188500_();
            z = random.m_188500_();
            if (!(x > bb.f_82288_) || !(x < bb.f_82291_) || !(z > bb.f_82290_) || !(z < bb.f_82293_)) continue;
            dx = (double)maxSpeed * level.f_46441_.m_188500_();
            dy = 0.0;
            dz = (double)maxSpeed * level.f_46441_.m_188500_();
            level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + bb.f_82289_ - (double)offset, blockCenter.m_7094_() + z, dx, dy, dz);
        }
        i = uniformInt.m_214085_(random);
        for (j = 0; j < i; ++j) {
            x = random.m_188500_();
            z = random.m_188500_();
            if (!(x > bb.f_82288_) || !(x < bb.f_82291_) || !(z > bb.f_82290_) || !(z < bb.f_82293_)) continue;
            dx = (double)maxSpeed * level.f_46441_.m_188500_();
            dy = 0.0;
            dz = (double)maxSpeed * level.f_46441_.m_188500_();
            level.m_7106_(particleOptions, blockCenter.m_7096_() + x, blockCenter.m_7098_() + bb.f_82292_ + (double)offset, blockCenter.m_7094_() + z, dx, dy, dz);
        }
    }

    public static void spawnParticlesOnBlockFaces(Level level, BlockPos pos, ParticleOptions particleOptions, UniformInt uniformInt, float minSpeed, float maxSpeed, boolean perpendicular) {
        for (Direction direction : Direction.values()) {
            int i = uniformInt.m_214085_(level.f_46441_);
            for (int j = 0; j < i; ++j) {
                ParticleUtil.spawnParticleOnFace(level, pos, direction, particleOptions, minSpeed, maxSpeed, perpendicular);
            }
        }
    }

    public static void spawnParticleOnFace(Level level, BlockPos pos, Direction direction, ParticleOptions particleOptions, float minSpeed, float maxSpeed, boolean perpendicular) {
        double dz;
        double dy;
        double dx;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.5, (double)0.5) : (double)k * 0.6);
        if (perpendicular) {
            dx = (float)i * Mth.m_216283_((RandomSource)level.f_46441_, (float)minSpeed, (float)maxSpeed);
            dy = (float)j * Mth.m_216283_((RandomSource)level.f_46441_, (float)minSpeed, (float)maxSpeed);
            dz = (float)k * Mth.m_216283_((RandomSource)level.f_46441_, (float)minSpeed, (float)maxSpeed);
        } else {
            float d = maxSpeed - minSpeed;
            dx = i == 0 ? (double)minSpeed + (double)d * level.f_46441_.m_188500_() : 0.0;
            dy = j == 0 ? (double)minSpeed + (double)d * level.f_46441_.m_188500_() : 0.0;
            dz = k == 0 ? (double)minSpeed + (double)d * level.f_46441_.m_188500_() : 0.0;
        }
        level.m_7106_(particleOptions, d0, d1, d2, dx, dy, dz);
    }

    public static void spawnBreakParticles(VoxelShape shape, BlockPos pPos, BlockState pState, Level level) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        shape.m_83286_((x0, y0, z0, x1, y1, z1) -> {
            double d1 = Math.min(1.0, x1 - x0);
            double d2 = Math.min(1.0, y1 - y0);
            double d3 = Math.min(1.0, z1 - z0);
            int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + x0;
                        double d8 = d5 * d2 + y0;
                        double d9 = d6 * d3 + z0;
                        particleEngine.m_107344_((Particle)new TerrainParticle((ClientLevel)level, (double)pPos.m_123341_() + d7, (double)pPos.m_123342_() + d8, (double)pPos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, pState, pPos));
                    }
                }
            }
        });
    }
}

