/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.forge;

import com.google.common.base.Supplier;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.forge.ConfigSpecWrapper;
import net.mehvahdjukaar.moonlight.core.databuddy.ConfigHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final List<ForgeConfigSpec.ConfigValue<?>> requireGameRestart = new ArrayList();
    private boolean currentGameRestart;
    private ForgeConfigSpec.ConfigValue<?> currentValue;
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private String cat = null;

    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(ResourceLocation name, ConfigType type) {
        super(name, type);
    }

    @Override
    public String currentCategory() {
        return this.cat;
    }

    @Override
    public ConfigSpecWrapper build() {
        return new ConfigSpecWrapper(this.getName(), this.builder.build(), this.type, this.synced, this.changeCallback, this.requireGameRestart);
    }

    @Override
    public ConfigBuilderImpl push(String category) {
        assert (this.cat == null);
        this.builder.push(category);
        this.cat = category;
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        assert (this.cat != null);
        this.builder.pop();
        this.cat = null;
        return this;
    }

    @Override
    public java.util.function.Supplier<Boolean> define(String name, boolean defaultValue) {
        ForgeConfigSpec.BooleanValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Double> define(String name, double defaultValue, double min, double max) {
        ForgeConfigSpec.DoubleValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Integer> define(String name, int defaultValue, int min, int max) {
        ForgeConfigSpec.IntValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public java.util.function.Supplier<Integer> defineColor(String name, int defaultValue) {
        ForgeConfigSpec.ConfigValue stringConfig;
        this.maybeAddTranslationString(name);
        this.currentValue = stringConfig = this.builder.define(name, (Object)Integer.toHexString(defaultValue), ConfigBuilder.COLOR_CHECK);
        this.maybeAddGameRestart();
        return () -> Integer.parseUnsignedInt(((String)stringConfig.get()).replace("0x", ""), 16);
    }

    @Override
    public java.util.function.Supplier<String> define(String name, String defaultValue, Predicate<Object> validator) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.define(name, (Object)defaultValue, validator);
        this.maybeAddGameRestart();
        return value;
    }

    @Override
    public <T extends String> java.util.function.Supplier<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ForgeConfigSpec.ConfigValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineList(name, defaultValue, predicate);
        this.maybeAddGameRestart();
        return () -> (List)value.get();
    }

    @Override
    public <T> java.util.function.Supplier<T> defineObject(String name, Supplier<T> defaultSupplier, Codec<T> codec) {
        if (this.usesConfigBuddy) {
            return ConfigHelper.defineObject(this.builder, name, codec, defaultSupplier);
        }
        return StringCodecConfigValue.define(this, name, defaultSupplier.get(), codec);
    }

    public StringJsonConfigValue defineJson(String path, JsonElement defaultValue) {
        return StringJsonConfigValue.define(this, path, defaultValue);
    }

    @Override
    public <V extends Enum<V>> java.util.function.Supplier<V> define(String name, V defaultValue) {
        ForgeConfigSpec.EnumValue value;
        this.maybeAddTranslationString(name);
        this.currentValue = value = this.builder.defineEnum(name, defaultValue);
        this.maybeAddGameRestart();
        return value;
    }

    private void maybeAddGameRestart() {
        if (this.currentGameRestart && this.currentValue != null) {
            this.requireGameRestart.add(this.currentValue);
            this.currentGameRestart = false;
            this.currentValue = null;
        }
    }

    @Override
    public ConfigBuilder gameRestart() {
        this.currentGameRestart = true;
        return this;
    }

    @Override
    public ConfigBuilder worldReload() {
        this.builder.worldRestart();
        return this;
    }

    @Override
    public ConfigBuilder comment(String comment) {
        this.builder.comment(comment);
        return super.comment(comment);
    }

    private static class StringCodecConfigValue<T>
    implements java.util.function.Supplier<T> {
        private final StringJsonConfigValue inner;
        private final Codec<T> codec;
        private T cache;

        public static <T> StringCodecConfigValue<T> define(ConfigBuilderImpl cfg, String name, T defaultValue, Codec<T> codec) {
            DataResult e = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, defaultValue);
            Optional json = e.resultOrPartial(s -> {
                throw new RuntimeException("Invalid default value for config " + name + ": " + s);
            });
            if (json.isEmpty()) {
                throw new RuntimeException("Invalid default value for config " + name);
            }
            StringJsonConfigValue jsonConfig = cfg.defineJson(name, (JsonElement)json.get());
            return new StringCodecConfigValue<T>(jsonConfig, codec);
        }

        public StringCodecConfigValue(StringJsonConfigValue jsonConfig, Codec<T> codec) {
            this.inner = jsonConfig;
            this.codec = codec;
        }

        @Override
        public T get() {
            if (this.inner.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                JsonElement j = this.inner.get();
                DataResult d = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)j);
                Optional o = d.resultOrPartial(s -> {
                    throw new RuntimeException("Failed to decode config: " + s);
                });
                if (o.isEmpty()) {
                    throw new RuntimeException("Failed to parse decode with value" + j);
                }
                return (T)((Pair)o.get()).getFirst();
            }
            return null;
        }
    }

    private static class StringJsonConfigValue
    implements java.util.function.Supplier<JsonElement> {
        private static final Field cachedValue = ObfuscationReflectionHelper.findField(ForgeConfigSpec.ConfigValue.class, (String)"cachedValue");
        private final ForgeConfigSpec.ConfigValue<String> inner;
        private JsonElement cache = null;

        public static StringJsonConfigValue define(ConfigBuilderImpl cfg, String path, JsonElement defaultValue) {
            return new StringJsonConfigValue(cfg.define(path, defaultValue.toString().replace(" ", "").replace("\"", "'")));
        }

        StringJsonConfigValue(java.util.function.Supplier<String> innerConfig) {
            this.inner = (ForgeConfigSpec.ConfigValue)innerConfig;
        }

        @Override
        public JsonElement get() {
            if (this.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                String s = ((String)this.inner.get()).replace("'", "\"");
                try {
                    this.cache = JsonParser.parseString((String)s);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse json config: ", e);
                }
            }
            return this.cache;
        }

        public boolean hasBeenReset() {
            try {
                return cachedValue.get(this.inner) == null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            cachedValue.setAccessible(true);
        }
    }
}

