/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FodderBlock
extends WaterBlock {
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[8];

    public FodderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(8))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.m_61143_((Property)LAYERS) <= 4;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)LAYERS) - 1];
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (facingState.m_60713_((Block)this)) {
            int layers;
            int missing;
            if (direction == Direction.UP) {
                int layers2 = (Integer)state.m_61143_((Property)LAYERS);
                int missing2 = 8 - layers2;
                if (missing2 > 0) {
                    int otherLayers = (Integer)facingState.m_61143_((Property)LAYERS);
                    int newOtherLayers = otherLayers - missing2;
                    BlockState newOtherState = newOtherLayers <= 0 ? Blocks.f_50016_.m_49966_() : (BlockState)facingState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(newOtherLayers));
                    BlockState newState = (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers2 + otherLayers - Math.max(0, newOtherLayers)));
                    world.m_7731_(currentPos, newState, 0);
                    world.m_7731_(otherPos, newOtherState, 0);
                    return newState;
                }
            } else if (direction == Direction.DOWN && (missing = 8 - (layers = ((Integer)facingState.m_61143_((Property)LAYERS)).intValue())) > 0) {
                int myLayers = (Integer)state.m_61143_((Property)LAYERS);
                int myNewLayers = myLayers - missing;
                BlockState myNewState = myNewLayers <= 0 ? Blocks.f_50016_.m_49966_() : (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(myNewLayers));
                world.m_7731_(otherPos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers + myLayers - Math.max(0, myNewLayers))), 0);
                return myNewState;
            }
        }
        return super.m_7417_(state, direction, facingState, world, currentPos, otherPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LAYERS});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof HoeItem) {
            world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                int layers = (Integer)state.m_61143_((Property)LAYERS);
                if (layers > 1) {
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers - 1)), 11);
                } else {
                    world.m_46961_(pos, false);
                }
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)l * 2.0 + 2.0), (double)16.0));
    }
}

