/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpeedometerItem
extends Item {
    public SpeedometerItem(Item.Properties properties) {
        super(properties);
    }

    private static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            this.calculateSpeed(player, (Entity)entity);
        }
        return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
    }

    private void calculateSpeed(Player player, Entity entity) {
        double speed = SpeedometerItem.getBPS(entity);
        double s = SpeedometerItem.roundToSignificantFigures(speed, 3);
        player.m_5661_((Component)Component.m_237110_((String)"message.supplementaries.speedometer", (Object[])new Object[]{s}), true);
    }

    private static double getBPS(Entity entity) {
        Entity mount = entity.m_20202_();
        Entity e = entity;
        if (mount != null) {
            e = mount;
        }
        Vec3 v = e.m_20184_();
        if (e.m_20096_()) {
            v = v.m_82492_(0.0, v.f_82480_, 0.0);
        }
        return v.m_82553_() * 20.0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            this.calculateSpeed(player, (Entity)player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static class SpeedometerItemProperty
    implements ItemPropertyFunction {
        public float m_141951_(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity player, int seed) {
            LivingEntity entity;
            Object object = entity = player != null ? player : stack.m_41609_();
            if (entity == null) {
                return 0.0f;
            }
            double speed = SpeedometerItem.getBPS((Entity)entity);
            double max = 60.0;
            return (float)Math.min(speed / max, 1.0);
        }
    }
}

