/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ServerBoundSetPresentPacket
implements Message {
    private final BlockPos pos;
    private final boolean packed;
    private final String sender;
    private final String recipient;
    private final String description;

    public ServerBoundSetPresentPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.packed = buf.readBoolean();
        this.recipient = buf.m_130277_();
        this.sender = buf.m_130277_();
        this.description = buf.m_130277_();
    }

    public ServerBoundSetPresentPacket(BlockPos pos, boolean packed, String recipient, String sender, String description) {
        this.pos = pos;
        this.packed = packed;
        this.recipient = recipient;
        this.sender = sender;
        this.description = description;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.packed);
        buf.m_130070_(this.recipient);
        buf.m_130070_(this.sender);
        buf.m_130070_(this.description);
    }

    public void handle(ChannelHandler.Context context) {
        ServerPlayer player = (ServerPlayer)Objects.requireNonNull(context.getSender());
        Level world = player.f_19853_;
        BlockPos pos = this.pos;
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (blockEntity instanceof PresentBlockTile) {
            PresentBlockTile present = (PresentBlockTile)blockEntity;
            present.updateState(this.packed, this.recipient, this.sender, this.description);
            BlockState state = world.m_8055_(pos);
            present.m_6596_();
            world.m_7260_(pos, state, state, 3);
            if (this.packed) {
                player.m_9230_();
            }
        }
    }
}

