/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgenRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.jetbrains.annotations.Nullable;

public class MineshaftElevatorPiece
extends MineshaftPieces.MineShaftPiece {
    private final Direction direction;
    private final byte floor;
    private final boolean hasChain;

    public MineshaftElevatorPiece(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        super(ModWorldgenRegistry.MINESHAFT_ELEVATOR.get(), compoundTag);
        this.direction = Direction.m_122407_((int)compoundTag.m_128451_("D"));
        this.floor = compoundTag.m_128445_("F");
        this.hasChain = compoundTag.m_128471_("C");
    }

    public MineshaftElevatorPiece(int depth, BoundingBox boundingBox, @Nullable Direction direction, byte floor, boolean hasChain, MineshaftStructure.Type type) {
        super(ModWorldgenRegistry.MINESHAFT_ELEVATOR.get(), depth, type, boundingBox);
        this.direction = direction;
        this.floor = floor;
        this.hasChain = hasChain;
    }

    @Nullable
    public static MineshaftPieces.MineShaftPiece getElevator(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth, MineshaftStructure.Type type) {
        if (y > 40) {
            return null;
        }
        if (random.m_188503_(100) < 2 && CommonConfigs.Redstone.PULLEY_ENABLED.get().booleanValue() && CommonConfigs.Redstone.TURN_TABLE_ENABLED.get().booleanValue()) {
            int height = 12;
            int floor = random.m_188503_(3);
            if (random.m_188499_() && floor != 2) {
                ++floor;
            }
            int yOffset = floor * 4;
            BoundingBox boundingBox = switch (direction) {
                default -> new BoundingBox(-1, -yOffset, -4, 3, height - yOffset, 0);
                case Direction.SOUTH -> new BoundingBox(-1, -yOffset, 0, 3, height - yOffset, 4);
                case Direction.WEST -> new BoundingBox(-4, -yOffset, -1, 0, height - yOffset, 3);
                case Direction.EAST -> new BoundingBox(0, -yOffset, -1, 4, height - yOffset, 3);
            };
            boundingBox.m_162367_(x, y, z);
            if (pieces.m_141921_(boundingBox) == null) {
                boolean hasChain = random.m_188503_(5) == 0;
                return new MineshaftElevatorPiece(genDepth, boundingBox, direction, (byte)floor, hasChain, type);
            }
        }
        return null;
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128405_("D", this.direction.m_122416_());
        tag.m_128344_("F", this.floor);
        tag.m_128379_("C", this.hasChain);
    }

    public void m_214092_(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
        int genDepth1 = this.m_73548_();
        for (int i = 0; i < 3; ++i) {
            int y = this.f_73383_.m_162396_() + i * 4;
            int c = 2 + Mth.m_14040_((int)(i - this.floor));
            if (random.m_188503_(c) != 0 && (i != this.floor || this.direction != Direction.SOUTH)) {
                MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() + 1), (int)y, (int)(this.f_73383_.m_162398_() - 1), (Direction)Direction.NORTH, (int)genDepth1);
            }
            if (random.m_188503_(c) != 0 && (i != this.floor || this.direction != Direction.EAST)) {
                MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() - 1), (int)y, (int)(this.f_73383_.m_162398_() + 1), (Direction)Direction.WEST, (int)genDepth1);
            }
            if (random.m_188503_(c) != 0 && (i != this.floor || this.direction != Direction.WEST)) {
                MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162399_() + 1), (int)y, (int)(this.f_73383_.m_162398_() + 1), (Direction)Direction.EAST, (int)genDepth1);
            }
            if (random.m_188503_(c) == 0 || i == this.floor && this.direction == Direction.NORTH) continue;
            MineshaftPieces.m_227706_((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.f_73383_.m_162395_() + 1), (int)y, (int)(this.f_73383_.m_162401_() + 1), (Direction)Direction.SOUTH, (int)genDepth1);
        }
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        if (!this.m_227881_((LevelAccessor)level, box)) {
            BlockState plank = this.f_227864_.m_227994_();
            int minY = this.f_73383_.m_162396_();
            int minZ = this.f_73383_.m_162398_();
            int maxZ = this.f_73383_.m_162401_();
            int minX = this.f_73383_.m_162395_();
            int maxX = this.f_73383_.m_162399_();
            for (int f = 0; f < 3; ++f) {
                int yInc = f * 4;
                this.m_73441_(level, box, minX + 1, minY + yInc, minZ, maxX - 1, minY + 3 - 1 + yInc, maxZ, f_73382_, f_73382_, false);
                this.m_73441_(level, box, minX, minY + yInc, minZ + 1, maxX, minY + 3 - 1 + yInc, maxZ - 1, f_73382_, f_73382_, false);
                this.m_73441_(level, box, minX + 1, minY + 4 + yInc - 1, minZ + 1, maxX - 1, minY + 4 + yInc - 1, maxZ - 1, f_73382_, f_73382_, false);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, maxZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, maxZ);
            }
            this.m_73441_(level, box, minX + 1, minY + 4 + 8, minZ + 1, maxX - 1, minY + 4 + 8, maxZ - 1, f_73382_, f_73382_, false);
            int maxY = this.f_73383_.m_162400_() - 1;
            int i = minY - 1;
            BlockState wood = this.f_227864_.m_227992_();
            boolean b1 = this.fillPillarDownOrChainUp(level, wood, minX, minZ, box);
            boolean b2 = this.fillPillarDownOrChainUp(level, wood, minX, maxZ, box);
            boolean b3 = this.fillPillarDownOrChainUp(level, wood, maxX, minZ, box);
            boolean b4 = this.fillPillarDownOrChainUp(level, wood, maxX, maxZ, box);
            if (!(b1 || b2 || b3 || b4)) {
                wood = plank;
            }
            boolean p1 = this.placeSidePillar(level, box, minX, minY, minZ, maxY - 1, wood);
            boolean p2 = this.placeSidePillar(level, box, minX, minY, maxZ, maxY - 1, wood);
            boolean p3 = this.placeSidePillar(level, box, maxX, minY, minZ, maxY - 1, wood);
            boolean p4 = this.placeSidePillar(level, box, maxX, minY, maxZ, maxY - 1, wood);
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    this.m_227890_(level, box, plank, j, i, k);
                    if (j != minX && j != maxX && k != minZ && k != maxZ) continue;
                    this.m_227890_(level, box, plank, j, i + 4, k);
                    this.m_227890_(level, box, plank, j, i + 8, k);
                    this.placeBlockSafe(level, plank, j, i + 12, k, box);
                }
            }
            if (p1 && p2 && p3 && p4) {
                this.addPulley(level, random, box, minZ, minX, maxY);
            }
        }
    }

    private void maybePlaceCobWeb(WorldGenLevel level, BoundingBox box, RandomSource random, float chance, int x, int y, int z) {
        if (this.m_73414_((LevelReader)level, x, y, z, box) && random.m_188501_() < chance && this.hasSturdyNeighbours(level, box, x, y, z, 2)) {
            this.placeBlockSafe(level, Blocks.f_50033_.m_49966_(), x, y, z, box);
        }
    }

    protected void placeBlockSafe(WorldGenLevel level, BlockState plankState, int x, int y, int z, BoundingBox box) {
        if (this.m_73414_((LevelReader)level, x, y, z, box)) {
            BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
            level.m_7731_((BlockPos)blockPos, plankState, 2);
        }
    }

    private boolean placeSidePillar(WorldGenLevel level, BoundingBox box, int x, int y, int z, int maxY, BlockState state) {
        if (this.m_73414_((LevelReader)level, x, y, z, box)) {
            Direction hack = this.m_73549_();
            this.m_73519_(hack);
            this.m_73441_(level, box, x, y, z, x, maxY, z, state, f_73382_, false);
            return true;
        }
        return false;
    }

    protected boolean fillPillarDownOrChainUp(WorldGenLevel level, BlockState state, int x, int z, BoundingBox box) {
        int minY = this.f_73383_.m_162396_();
        int maxY = this.f_73383_.m_162400_() - 1;
        if (!this.m_73414_((LevelReader)level, x, minY, z, box)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(x, minY, z);
        int j = 1;
        boolean canKeepGoingDown = this.m_163572_(level.m_8055_(new BlockPos(x, minY, z)));
        boolean canKeepGoingUp = this.m_163572_(level.m_8055_(new BlockPos(x, maxY, z)));
        if (!canKeepGoingDown) {
            return canKeepGoingUp;
        }
        while (canKeepGoingDown || canKeepGoingUp) {
            boolean canBeReplaced;
            BlockState blockState;
            if (canKeepGoingDown) {
                mutableBlockPos.m_142448_(minY - j);
                blockState = level.m_8055_((BlockPos)mutableBlockPos);
                boolean bl = canBeReplaced = this.m_163572_(blockState) && !blockState.m_60713_(Blocks.f_49991_);
                if (!canBeReplaced && blockState.m_60783_((BlockGetter)level, (BlockPos)mutableBlockPos, Direction.UP)) {
                    MineshaftElevatorPiece.fillColumnBetween(level, state, mutableBlockPos, minY - j + 1, minY);
                    return true;
                }
                boolean bl2 = canKeepGoingDown = j <= 20 && canBeReplaced && mutableBlockPos.m_123342_() > level.m_141937_() + 1;
            }
            if (canKeepGoingUp) {
                mutableBlockPos.m_142448_(maxY + j);
                blockState = level.m_8055_((BlockPos)mutableBlockPos);
                canBeReplaced = this.m_163572_(blockState);
                if (!canBeReplaced && this.canHangChainBelow((LevelReader)level, (BlockPos)mutableBlockPos, blockState)) {
                    level.m_7731_((BlockPos)mutableBlockPos.m_142448_(maxY + 1), this.f_227864_.m_227995_(), 2);
                    BlockState chain = maxY + 2 < MineshaftElevatorPiece.getRopeCutout() && CommonConfigs.Functional.ROPE_ENABLED.get() != false ? (BlockState)((BlockState)((BlockState)ModRegistry.ROPE.get().m_49966_().m_61124_((Property)RopeBlock.DISTANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true)) : Blocks.f_50184_.m_49966_();
                    MineshaftElevatorPiece.fillColumnBetween(level, chain, mutableBlockPos, maxY + 2, maxY + j);
                    return false;
                }
                canKeepGoingUp = j <= 50 && canBeReplaced && mutableBlockPos.m_123342_() < level.m_151558_() - 1;
            }
            ++j;
        }
        return false;
    }

    private boolean canHangChainBelow(LevelReader level, BlockPos pos, BlockState state) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.m_60734_() instanceof FallingBlock);
    }

    private static void fillColumnBetween(WorldGenLevel level, BlockState state, BlockPos.MutableBlockPos pos, int minY, int maxY) {
        for (int i = minY; i < maxY; ++i) {
            level.m_7731_((BlockPos)pos.m_142448_(i), state, 2);
        }
    }

    private boolean hasSturdyNeighbours(WorldGenLevel level, BoundingBox box, int x, int y, int z, int required) {
        BlockPos.MutableBlockPos mutableBlockPos = this.m_163582_(x, y, z);
        int i = 0;
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122173_(direction);
            if (box.m_71051_((Vec3i)mutableBlockPos) && level.m_8055_((BlockPos)mutableBlockPos).m_60783_((BlockGetter)level, (BlockPos)mutableBlockPos, direction.m_122424_()) && ++i >= required) {
                return true;
            }
            mutableBlockPos.m_122173_(direction.m_122424_());
        }
        return false;
    }

    public static int getRopeCutout() {
        return 22;
    }

    @Nullable
    public static BlockState getMineshaftRope() {
        Block rope = CommonConfigs.getSelectedRope();
        if (rope == null) {
            return null;
        }
        BlockState ropeState = rope.m_49966_();
        if (rope instanceof RopeBlock) {
            ropeState = (BlockState)((BlockState)((BlockState)ropeState.m_61124_((Property)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RopeBlock.DISTANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true));
        }
        return ropeState;
    }

    private void addPulley(WorldGenLevel level, RandomSource random, BoundingBox box, int minZ, int minX, int maxY) {
        boolean hasRope;
        BlockState wood = this.f_227864_.m_227992_();
        BlockState plank = this.f_227864_.m_227994_();
        Direction d = this.direction;
        BlockState ropeBlock = MineshaftElevatorPiece.getMineshaftRope();
        boolean bl = hasRope = !this.hasChain && ropeBlock != null;
        if (!hasRope) {
            ropeBlock = Blocks.f_50184_.m_49966_();
        }
        Item ropeItem = ropeBlock.m_60734_().m_5456_();
        BlockPos.MutableBlockPos contraptionPos = new BlockPos.MutableBlockPos(minX + 2, maxY + 1, minZ + 2);
        this.m_73434_(level, (BlockState)((BlockState)ModRegistry.PULLEY_BLOCK.get().m_49966_().m_61124_(PulleyBlock.TYPE, (Comparable)((Object)(hasRope ? ModBlockProperties.Winding.ROPE : ModBlockProperties.Winding.CHAIN)))).m_61124_((Property)PulleyBlock.f_55923_, (Comparable)d.m_122434_()), contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        BlockEntity blockEntity = level.m_7702_((BlockPos)contraptionPos);
        if (blockEntity instanceof PulleyBlockTile) {
            PulleyBlockTile tile = (PulleyBlockTile)blockEntity;
            tile.setDisplayedItem(new ItemStack((ItemLike)ropeItem, 16 + random.m_188503_(8)));
        }
        contraptionPos.m_122173_(d);
        Direction dOpposite = d.m_122424_();
        this.m_73434_(level, (BlockState)((BlockState)ModRegistry.TURN_TABLE.get().m_49966_().m_61124_((Property)TurnTableBlock.INVERTED, (Comparable)Boolean.valueOf(d.m_122421_() == Direction.AxisDirection.NEGATIVE))).m_61124_((Property)TurnTableBlock.FACING, (Comparable)dOpposite), contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122173_(d.m_122427_());
        this.m_73434_(level, Blocks.f_50716_.m_49966_(), contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122175_(dOpposite, 2).m_122173_(d.m_122428_());
        this.m_73434_(level, (BlockState)wood.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)d.m_122434_()), contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122173_(dOpposite);
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122173_(d.m_122427_());
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122175_(d.m_122428_(), 2);
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122175_(d, 4);
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122173_(d.m_122427_());
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        contraptionPos.m_122173_(d.m_122427_());
        this.m_73434_(level, plank, contraptionPos.m_123341_(), contraptionPos.m_123342_(), contraptionPos.m_123343_(), box);
        this.m_73434_(level, ropeBlock, minX + 2, maxY, minZ + 2, box);
        this.m_73434_(level, ropeBlock, minX + 2, maxY - 1, minZ + 2, box);
        BlockState chest = (hasRope ? ModRegistry.SACK.get() : Blocks.f_50087_).m_49966_();
        this.m_73434_(level, chest, minX + 2, maxY - 2, minZ + 2, box);
        BlockEntity blockEntity2 = level.m_7702_(new BlockPos(minX + 2, maxY - 2, minZ + 2));
        if (blockEntity2 instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity tile = (RandomizableContainerBlockEntity)blockEntity2;
            tile.m_59626_(BuiltInLootTables.f_78759_, random.m_188505_());
        }
    }
}

