/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.forge.TaterInAJarBlock;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import vazkii.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.automation.module.JukeboxAutomationModule;
import vazkii.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.module.VerticalSlabsModule;
import vazkii.quark.content.tools.module.SlimeInABucketModule;
import vazkii.quark.content.tweaks.module.DoubleDoorOpeningModule;
import vazkii.quark.content.tweaks.module.EnhancedLaddersModule;
import vazkii.quark.content.tweaks.module.MoreNoteBlockSoundsModule;

public class QuarkCompatImpl {
    private static final Field MOVEMENTS = ObfuscationReflectionHelper.findField(PistonsMoveTileEntitiesModule.class, (String)"movements");
    public static final String TATER_IN_A_JAR_NAME = "tater_in_a_jar";
    public static final Supplier<Block> TATER_IN_A_JAR = RegUtils.regWithItem("tater_in_a_jar", TaterInAJarBlock::new, new Item.Properties().m_41491_(null).m_41497_(Rarity.UNCOMMON), 0);
    public static final Supplier<BlockEntityType<TaterInAJarBlock.Tile>> TATER_IN_A_JAR_TILE = RegUtils.regTile("tater_in_a_jar", () -> BlockEntityType.Builder.m_155273_(TaterInAJarBlock.Tile::new, (Block[])new Block[]{TATER_IN_A_JAR.get()}).m_58966_(null));

    @Nullable
    public static BlockState updateWoodPostShape(BlockState post, Direction facing, BlockState facingState) {
        if (post.m_60734_() instanceof WoodPostBlock) {
            Direction.Axis axis = (Direction.Axis)post.m_61143_((Property)WoodPostBlock.AXIS);
            if (facing.m_122434_() != axis) {
                boolean chain = facingState.m_60734_() instanceof ChainBlock && facingState.m_61143_((Property)BlockStateProperties.f_61365_) == facing.m_122434_();
                return (BlockState)post.m_61124_((Property)WoodPostBlock.CHAINED[facing.ordinal()], (Comparable)Boolean.valueOf(chain));
            }
        }
        return null;
    }

    public static boolean isFastSlideModuleEnabled() {
        return EnhancedLaddersModule.allowSliding;
    }

    public static boolean isDoubleDoorEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class);
    }

    public static boolean canMoveBlockEntity(BlockState state) {
        return !PistonsMoveTileEntitiesModule.shouldMoveTE((boolean)true, (BlockState)state);
    }

    public static int getSacksInBackpack(ItemStack stack) {
        LazyOptional handlerOpt;
        int j = 0;
        if (stack.m_41720_() instanceof BackpackItem && (handlerOpt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
            IItemHandler handler = (IItemHandler)handlerOpt.resolve().get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                CompoundTag tag;
                ItemStack slotItem = handler.getStackInSlot(i);
                if (!(slotItem.m_41720_() instanceof SackItem) || (tag = slotItem.m_41783_()) == null || !tag.m_128441_("BlockEntityTag")) continue;
                ++j;
            }
        }
        return j;
    }

    public static boolean isVerticalSlabEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(VerticalSlabsModule.class);
    }

    public static void tickPiston(Level level, BlockPos pos, AABB pistonBB, boolean sameDir, BlockEntity movingTile) {
        List list = level.m_45933_(null, pistonBB);
        for (Entity entity : list) {
            BlockEntity blockEntity;
            AABB entityBB;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.m_6084_() || !pistonBB.m_82381_(entityBB = entity.m_20191_())) continue;
            if (CompatHandler.QUARK && (blockEntity = QuarkCompatImpl.getMovingBlockEntity(pos, level)) instanceof BambooSpikesBlockTile) {
                IBlockHolder te;
                BlockState state;
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
                if (tile.interactWithEntity(livingEntity, level) && movingTile instanceof IBlockHolder && (state = (te = (IBlockHolder)movingTile).getHeldBlock()).m_60734_() instanceof BambooSpikesBlock) {
                    te.setHeldBlock((BlockState)state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                QuarkCompatImpl.updateMovingTile(pos, level, tile);
            }
            entity.m_6469_(BambooSpikesBlock.getDamageSource(level), sameDir ? 3.0f : 1.0f);
        }
    }

    private static void updateMovingTile(BlockPos pos, Level world, BlockEntity tile) {
        try {
            Map worldMovements;
            WeakHashMap movements;
            Object o = MOVEMENTS.get(null);
            if (o instanceof WeakHashMap && (movements = (WeakHashMap)o).containsKey(world) && (worldMovements = (Map)movements.get(world)).containsKey(pos)) {
                worldMovements.remove(pos);
                worldMovements.put(pos, tile.m_187480_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BlockEntity getMovingBlockEntity(BlockPos pos, Level level) {
        return PistonsMoveTileEntitiesModule.getMovement((Level)level, (BlockPos)pos);
    }

    public static boolean isJukeboxModuleOn() {
        return ModuleLoader.INSTANCE.isModuleEnabled(JukeboxAutomationModule.class);
    }

    public static InteractionResult tryCaptureTater(JarItem item, UseOnContext context) {
        ItemStack stack;
        CompoundTag com;
        TinyPotatoBlockEntity te;
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TinyPotatoBlockEntity && (te = (TinyPotatoBlockEntity)blockEntity).m_58903_() != TATER_IN_A_JAR_TILE.get() && ((com = (stack = context.m_43722_()).m_41737_("BlockEntityTag")) == null || com.m_128456_())) {
            if (!world.f_46443_) {
                Player player = context.m_43723_();
                item.playCatchSound(player);
                ItemStack returnItem = new ItemStack((ItemLike)TATER_IN_A_JAR.get());
                if (te.m_8077_()) {
                    returnItem.m_41714_(te.m_7770_());
                }
                Utils.swapItemNBT((Player)player, (InteractionHand)context.m_43724_(), (ItemStack)stack, (ItemStack)returnItem);
                world.m_7471_(pos, false);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static void init() {
    }

    public static boolean isMoreNoteBlockSoundsOn() {
        return MoreNoteBlockSoundsModule.enableSkullSounds;
    }

    public static BlockState getMagnetStateForFlintBlock(BlockEntity be, Direction dir) {
        MagnetizedBlockBlockEntity magnet;
        if (be instanceof MagnetizedBlockBlockEntity && dir == (magnet = (MagnetizedBlockBlockEntity)be).getFacing()) {
            return magnet.getMagnetState();
        }
        return null;
    }

    public static ItemStack getSlimeBucket(Entity entity) {
        if (ModuleLoader.INSTANCE.isModuleEnabled(SlimeInABucketModule.class) && entity.m_6095_() == EntityType.f_20526_ && ((Slime)entity).m_33632_() == 1 && entity.m_6084_()) {
            ItemStack outStack = new ItemStack((ItemLike)SlimeInABucketModule.slime_in_a_bucket);
            CompoundTag cmp = entity.serializeNBT();
            ItemNBTHelper.setCompound((ItemStack)outStack, (String)"slime_nbt", (CompoundTag)cmp);
            return outStack;
        }
        return ItemStack.f_41583_;
    }
}

