/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.items.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.OptionalTagBlockItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModCreativeTabs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;

public class RegUtils {
    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicBlockRegistration(RegUtils::registerHangingSignBlocks, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerHangingSignItems, WoodType.class);
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
    }

    @Nullable
    public static CreativeModeTab getTab(CreativeModeTab g, String regName) {
        if (CommonConfigs.isEnabled(regName)) {
            return ModCreativeTabs.MOD_TAB == null ? g : ModCreativeTabs.MOD_TAB;
        }
        return null;
    }

    public static CreativeModeTab getTab(String modId, CreativeModeTab g, String regName) {
        return PlatformHelper.isModLoaded((String)modId) ? RegUtils.getTab(g, regName) : null;
    }

    public static Supplier<Block> regPlaceableItem(String name, Supplier<? extends Block> sup, String itemLocation, Supplier<Boolean> config) {
        Supplier<Item> itemSupp = () -> (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemLocation));
        return RegUtils.regPlaceableItem(name, sup, itemSupp, config);
    }

    public static Supplier<Block> regPlaceableItem(String name, Supplier<? extends Block> sup, Supplier<? extends Item> itemSupplier, Supplier<Boolean> config) {
        Supplier<Block> newSupp = () -> {
            Block b = (Block)sup.get();
            BlockPlacerItem.registerPlaceableItem(b, itemSupplier, config);
            return b;
        };
        return RegUtils.regBlock(name, newSupp);
    }

    public static <T extends Item> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)Supplementaries.res(name), sup);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, CreativeModeTab tab) {
        return RegUtils.regWithItem(name, blockFactory, new Item.Properties().m_41491_(RegUtils.getTab(tab, name)), 0);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, CreativeModeTab tab, int burnTime) {
        return RegUtils.regWithItem(name, blockFactory, new Item.Properties().m_41491_(RegUtils.getTab(tab, name)), burnTime);
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> blockFactory, Item.Properties properties, int burnTime) {
        Supplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static <T extends Block> Supplier<T> regWithItem(String name, Supplier<T> block, CreativeModeTab tab, String requiredMod) {
        CreativeModeTab t = PlatformHelper.isModLoaded((String)requiredMod) ? tab : null;
        return RegUtils.regWithItem(name, block, t);
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, CreativeModeTab group, String tagKey) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), () -> new OptionalTagBlockItem((Block)blockSup.get(), new Item.Properties().m_41491_(group), tagKey));
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties, int burnTime) {
        return RegHelper.registerItem((ResourceLocation)Supplementaries.res(name), () -> burnTime == 0 ? new BlockItem((Block)blockSup.get(), properties) : new WoodBasedBlockItem((Block)blockSup.get(), properties, burnTime));
    }

    public static Supplier<BlockItem> regBlockItem(String name, Supplier<? extends Block> blockSup, Item.Properties properties) {
        return RegUtils.regBlockItem(name, blockSup, properties, 0);
    }

    public static Map<DyeColor, Supplier<Block>> registerCandleHolders(String baseName) {
        HashMap<DyeColor, Supplier<Block>> map = new HashMap<DyeColor, Supplier<Block>>();
        Supplier<Block> block = RegUtils.regWithItem(baseName, () -> new CandleHolderBlock(null, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModRegistry.SCONCE.get()))), RegUtils.getTab(CreativeModeTab.f_40750_, baseName));
        map.put(null, block);
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            Supplier<Block> bb = RegUtils.regWithItem(name, () -> new CandleHolderBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModRegistry.SCONCE.get()))), RegUtils.getTab(CreativeModeTab.f_40750_, baseName));
            map.put(color, bb);
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerFlags(String baseName) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            Supplier<Block> block = RegUtils.regBlock(name, () -> new FlagBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56736_)));
            builder.put((Object)color, block);
            RegUtils.regItem(name, () -> new FlagItem((Block)block.get(), new Item.Properties().m_41487_(16).m_41491_(RegUtils.getTab(CreativeModeTab.f_40750_, baseName))));
        }
        return builder.build();
    }

    public static Map<DyeColor, Supplier<Block>> registerCeilingBanners(String baseName) {
        LinkedHashMap<DyeColor, Supplier<Block>> map = new LinkedHashMap<DyeColor, Supplier<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            map.put(color, RegUtils.regPlaceableItem(name, () -> new CeilingBannerBlock(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60910_().m_60918_(SoundType.f_56736_)), color.m_41065_() + "_banner", CommonConfigs.Tweaks.CEILING_BANNERS));
        }
        return map;
    }

    public static Map<DyeColor, Supplier<Block>> registerPresents(String baseName, BiFunction<DyeColor, BlockBehaviour.Properties, Block> presentFactory) {
        LinkedHashMap<DyeColor, Supplier<Block>> map = new LinkedHashMap<DyeColor, Supplier<Block>>();
        Supplier<Block> block = RegUtils.regBlock(baseName, () -> (Block)presentFactory.apply(null, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.0f).m_60918_((SoundType)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> new PresentItem((Block)block.get(), new Item.Properties().m_41491_(RegUtils.getTab(CreativeModeTab.f_40750_, baseName))));
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.m_41065_();
            Supplier<Block> bb = RegUtils.regBlock(name, () -> (Block)presentFactory.apply(color, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)color.m_41069_()).m_60978_(1.0f).m_60918_((SoundType)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> new PresentItem((Block)bb.get(), new Item.Properties().m_41491_(RegUtils.getTab(CreativeModeTab.f_40750_, baseName))));
        }
        return map;
    }

    private static void registerHangingSignBlocks(Registrator<Block> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("hanging_sign");
            HangingSignBlock block = new HangingSignBlock(BlockBehaviour.Properties.m_60944_((Material)wood.material, (MaterialColor)wood.material.m_76339_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60910_(), wood);
            wood.addChild("supplementaries:hanging_sign", (Object)block);
            event.register(Supplementaries.res(name), (Object)block);
            ModRegistry.HANGING_SIGNS.put(wood, block);
        }
    }

    public static void registerHangingSignItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (Map.Entry<WoodType, HangingSignBlock> entry : ModRegistry.HANGING_SIGNS.entrySet()) {
            WoodType wood = entry.getKey();
            Block block = (Block)entry.getValue();
            WoodBasedBlockItem item = new WoodBasedBlockItem(block, new Item.Properties().m_41487_(16).m_41491_(RegUtils.getTab(CreativeModeTab.f_40750_, "hanging_sign")), wood, 200);
            event.register(Utils.getID((Block)block), (Object)item);
        }
    }

    public static void registerSignPostItems(Registrator<Item> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            SignPostItem item = new SignPostItem(new Item.Properties().m_41487_(16).m_41491_(RegUtils.getTab(CreativeModeTab.f_40750_, "sign_post")), wood);
            wood.addChild("supplementaries:sign_post", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.SIGN_POST_ITEMS.put(wood, item);
        }
    }
}

