/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;

public class WildfirePlayerList
extends ObjectSelectionList<Entry> {
    private static final ResourceLocation TXTR_SYNC = new ResourceLocation("wildfire_gender", "textures/sync.png");
    private static final ResourceLocation TXTR_CACHED = new ResourceLocation("wildfire_gender", "textures/cached.png");
    private static final ResourceLocation TXTR_UNKNOWN = new ResourceLocation("wildfire_gender", "textures/unknown.png");
    private final int listWidth;
    private WildfirePlayerListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtil.m_14406_((String)value);
    }

    public WildfirePlayerList(WildfirePlayerListScreen parent, int listWidth, int top, int bottom) {
        super(parent.getMinecraft(), parent.f_96543_ - 4, parent.f_96544_, top - 6, bottom, 20);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int m_5756_() {
        return this.parent.f_96543_ / 2 + 53;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    public void refreshList() {
        PlayerInfo[] playersC;
        this.m_93516_();
        for (PlayerInfo loadedPlayer : playersC = this.f_93386_.m_91403_().m_105142_().toArray(new PlayerInfo[0])) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(loadedPlayer));
        }
    }

    protected void m_7733_(@Nonnull PoseStack mStack) {
    }

    public boolean isLoadingPlayers() {
        boolean loadingPlayers = false;
        for (Entry child : this.m_6702_()) {
            GenderPlayer aPlr = WildfireGender.getPlayerById(child.nInfo.m_105312_().getId());
            if (aPlr != null) continue;
            loadingPlayers = true;
        }
        return loadingPlayers;
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final String name;
        public final PlayerInfo nInfo;
        private final WildfireButton btnOpenGUI;

        private Entry(PlayerInfo nInfo) {
            this.nInfo = nInfo;
            this.name = nInfo.m_105312_().getName();
            this.btnOpenGUI = new WildfireButton(0, 0, 112, 20, (Component)Component.m_237119_(), button -> {
                GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.m_105312_().getId());
                if (aPlr == null) {
                    return;
                }
                try {
                    Minecraft.m_91087_().m_91152_((Screen)new WardrobeBrowserScreen(WildfirePlayerList.this.parent, nInfo.m_105312_().getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            GenderPlayer aPlr = WildfireGender.getPlayerById(nInfo.m_105312_().getId());
            if (aPlr != null) {
                this.btnOpenGUI.f_93623_ = !aPlr.lockSettings;
            }
        }

        public PlayerInfo getNetworkInfo() {
            return this.nInfo;
        }

        public void m_6311_(@Nonnull PoseStack m, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            Font font = ((WildfirePlayerList)WildfirePlayerList.this).f_93386_.f_91062_;
            Player playerentity = ((WildfirePlayerList)WildfirePlayerList.this).f_93386_.f_91073_.m_46003_(this.nInfo.m_105312_().getId());
            GenderPlayer aPlr = WildfireGender.getPlayerById(this.nInfo.m_105312_().getId());
            boolean flag1 = false;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.nInfo.m_105337_());
            int i3 = 8 + (flag1 ? 8 : 0);
            int j3 = 8 * (flag1 ? -1 : 1);
            GuiComponent.m_93160_((PoseStack)m, (int)(left + 2), (int)(top + 2), (int)16, (int)16, (float)8.0f, (float)i3, (int)8, (int)j3, (int)64, (int)64);
            if (playerentity != null && playerentity.m_36170_(PlayerModelPart.HAT)) {
                int k3 = 8 + (flag1 ? 8 : 0);
                int l3 = 8 * (flag1 ? -1 : 1);
                GuiComponent.m_93160_((PoseStack)m, (int)(left + 1), (int)(top + 1), (int)18, (int)18, (float)40.0f, (float)k3, (int)8, (int)l3, (int)64, (int)64);
            }
            font.m_92883_(m, this.name, (float)(left + 23), (float)(top + 2), 0xFFFFFF);
            if (aPlr != null) {
                this.btnOpenGUI.f_93623_ = !aPlr.lockSettings;
                font.m_92889_(m, aPlr.getGender().getDisplayName(), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
                if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.SYNCED) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TXTR_SYNC);
                    GuiComponent.m_93160_((PoseStack)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                    if (mouseX > left + 98 - 2 && mouseY > top + 11 - 2 && mouseX < left + 98 + 12 + 2 && mouseY < top + 20) {
                        WildfirePlayerList.this.parent.setTooltip((Component)Component.m_237115_((String)"wildfire_gender.player_list.state.synced"));
                    }
                } else if (aPlr.getSyncStatus() == GenderPlayer.SyncStatus.UNKNOWN) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TXTR_UNKNOWN);
                    GuiComponent.m_93160_((PoseStack)m, (int)(left + 98), (int)(top + 11), (int)12, (int)8, (float)0.0f, (float)0.0f, (int)12, (int)8, (int)12, (int)8);
                }
            } else {
                this.btnOpenGUI.f_93623_ = false;
                font.m_92889_(m, (Component)Component.m_237115_((String)"wildfire_gender.label.too_far").m_130940_(ChatFormatting.RED), (float)(left + 23), (float)(top + 11), 0xFFFFFF);
            }
            this.btnOpenGUI.f_93620_ = left;
            this.btnOpenGUI.f_93621_ = top;
            this.btnOpenGUI.m_6305_(m, mouseX, mouseY, partialTicks);
            if (this.btnOpenGUI.m_198029_()) {
                WildfirePlayerListScreen.HOVER_PLAYER = aPlr;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.btnOpenGUI.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.btnOpenGUI.m_6348_(mouseX, mouseY, button);
        }

        @Nonnull
        public Component m_142172_() {
            return Component.m_237119_();
        }
    }
}

