/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.WildfireSlider;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.config.ClientConfiguration;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class WildfireCharacterSettingsScreen
extends BaseWildfireScreen {
    private static final Component ENABLED = Component.m_237115_((String)"wildfire_gender.label.enabled").m_130940_(ChatFormatting.GREEN);
    private static final Component DISABLED = Component.m_237115_((String)"wildfire_gender.label.disabled").m_130940_(ChatFormatting.RED);
    private WildfireSlider bounceSlider;
    private WildfireSlider floppySlider;
    private ResourceLocation BACKGROUND;
    private int yPos = 0;
    private boolean bounceWarning;

    protected WildfireCharacterSettingsScreen(Screen parent, UUID uuid) {
        super((Component)Component.m_237115_((String)"wildfire_gender.char_settings.title"), parent, uuid);
    }

    public void m_7856_() {
        GenderPlayer aPlr = this.getPlayer();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.yPos = y - 47;
        int xPos = x - 78 - 1;
        this.m_142416_((GuiEventListener)new WildfireButton(this.f_96543_ / 2 + 73, this.yPos - 11, 9, 9, (Component)Component.m_237115_((String)"wildfire_gender.label.exit"), button -> Minecraft.m_91087_().m_91152_(this.parent)));
        this.m_142416_((GuiEventListener)new WildfireButton(xPos, this.yPos, 157, 20, (Component)Component.m_237110_((String)"wildfire_gender.char_settings.physics", (Object[])new Object[]{aPlr.hasBreastPhysics() ? ENABLED : DISABLED}), button -> {
            boolean enablePhysics;
            boolean bl = enablePhysics = !aPlr.hasBreastPhysics();
            if (aPlr.updateBreastPhysics(enablePhysics)) {
                button.m_93666_((Component)Component.m_237110_((String)"wildfire_gender.char_settings.physics", (Object[])new Object[]{enablePhysics ? ENABLED : DISABLED}));
                GenderPlayer.saveGenderInfo(aPlr);
            }
        }, (button, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)Component.m_237115_((String)"wildfire_gender.tooltip.breast_physics"), mouseX, mouseY)));
        this.m_142416_((GuiEventListener)new WildfireButton(xPos, this.yPos + 20, 157, 20, (Component)Component.m_237110_((String)"wildfire_gender.char_settings.armor_physics", (Object[])new Object[]{aPlr.hasArmorBreastPhysics() ? ENABLED : DISABLED}), button -> {
            boolean enablePhysicsArmor;
            boolean bl = enablePhysicsArmor = !aPlr.hasArmorBreastPhysics();
            if (aPlr.updateArmorBreastPhysics(enablePhysicsArmor)) {
                button.m_93666_((Component)Component.m_237110_((String)"wildfire_gender.char_settings.armor_physics", (Object[])new Object[]{enablePhysicsArmor ? ENABLED : DISABLED}));
                GenderPlayer.saveGenderInfo(aPlr);
            }
        }, (button, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)Component.m_237115_((String)"wildfire_gender.tooltip.armor_physics"), mouseX, mouseY)));
        this.m_142416_((GuiEventListener)new WildfireButton(xPos, this.yPos + 40, 157, 20, (Component)Component.m_237110_((String)"wildfire_gender.char_settings.hide_in_armor", (Object[])new Object[]{aPlr.showBreastsInArmor() ? DISABLED : ENABLED}), button -> {
            boolean enableShowInArmor;
            boolean bl = enableShowInArmor = !aPlr.showBreastsInArmor();
            if (aPlr.updateShowBreastsInArmor(enableShowInArmor)) {
                button.m_93666_((Component)Component.m_237110_((String)"wildfire_gender.char_settings.hide_in_armor", (Object[])new Object[]{enableShowInArmor ? DISABLED : ENABLED}));
                GenderPlayer.saveGenderInfo(aPlr);
            }
        }, (button, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)Component.m_237115_((String)"wildfire_gender.tooltip.hide_in_armor"), mouseX, mouseY)));
        this.bounceSlider = new WildfireSlider(xPos, this.yPos + 60, 158, 22, ClientConfiguration.BOUNCE_MULTIPLIER, aPlr.getBounceMultiplierRaw(), value -> {}, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> {
            float bounceText = 3.0f * value;
            float v = (float)Math.round(bounceText * 10.0f) / 10.0f;
            boolean bl = this.bounceWarning = v > 1.0f;
            if (v == 3.0f) {
                return Component.m_237115_((String)"wildfire_gender.slider.max_bounce");
            }
            if ((float)Math.round(bounceText * 100.0f) / 100.0f == 0.0f) {
                return Component.m_237115_((String)"wildfire_gender.slider.min_bounce");
            }
            return Component.m_237110_((String)"wildfire_gender.slider.bounce", (Object[])new Object[]{Float.valueOf(v)});
        }), value -> {
            if (aPlr.updateBounceMultiplier(value)) {
                GenderPlayer.saveGenderInfo(aPlr);
            }
        });
        this.m_142416_((GuiEventListener)this.bounceSlider);
        this.floppySlider = new WildfireSlider(xPos, this.yPos + 80, 158, 22, ClientConfiguration.FLOPPY_MULTIPLIER, aPlr.getFloppiness(), value -> {}, (Float2ObjectFunction<Component>)((Float2ObjectFunction)value -> Component.m_237110_((String)"wildfire_gender.slider.floppy", (Object[])new Object[]{Math.round(value * 100.0f)})), value -> {
            if (aPlr.updateFloppiness(value)) {
                GenderPlayer.saveGenderInfo(aPlr);
            }
        });
        this.m_142416_((GuiEventListener)this.floppySlider);
        this.m_142416_((GuiEventListener)new WildfireButton(xPos, this.yPos + 100, 157, 20, (Component)Component.m_237110_((String)"wildfire_gender.char_settings.hurt_sounds", (Object[])new Object[]{aPlr.hasHurtSounds() ? ENABLED : DISABLED}), button -> {
            boolean enableHurtSounds;
            boolean bl = enableHurtSounds = !aPlr.hasHurtSounds();
            if (aPlr.updateHurtSounds(enableHurtSounds)) {
                button.m_93666_((Component)Component.m_237110_((String)"wildfire_gender.char_settings.hurt_sounds", (Object[])new Object[]{enableHurtSounds ? ENABLED : DISABLED}));
                GenderPlayer.saveGenderInfo(aPlr);
            }
        }, (button, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)Component.m_237115_((String)"wildfire_gender.tooltip.hurt_sounds"), mouseX, mouseY)));
        this.BACKGROUND = new ResourceLocation("wildfire_gender", "textures/gui/settings_bg.png");
        super.m_7856_();
    }

    public void m_6305_(@Nonnull PoseStack m, int f1, int f2, float f3) {
        super.m_7333_(m);
        Player plrEntity = Minecraft.m_91087_().f_91073_.m_46003_(this.playerUUID);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.BACKGROUND != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.BACKGROUND);
        }
        int i = (this.f_96543_ - 172) / 2;
        int j = (this.f_96544_ - 124) / 2;
        this.m_93228_(m, i, j, 0, 0, 172, 144);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.f_96547_.m_92889_(m, this.f_96539_, (float)(x - 79), (float)(this.yPos - 10), 0x444444);
        super.m_6305_(m, f1, f2, f3);
        if (plrEntity != null) {
            Screen.m_93215_((PoseStack)m, (Font)this.f_96547_, (Component)plrEntity.m_5446_(), (int)x, (int)(this.yPos - 30), (int)0xFFFFFF);
        }
        if (this.bounceWarning) {
            Screen.m_93215_((PoseStack)m, (Font)this.f_96547_, (Component)Component.m_237115_((String)"wildfire_gender.tooltip.bounce_warning").m_130940_(ChatFormatting.ITALIC), (int)x, (int)(y + 90), (int)0xFF6666);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.bounceSlider.save();
        this.floppySlider.save();
        return super.m_6348_(mouseX, mouseY, state);
    }
}

