/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.config.ConfigKey;

public class GenderConfigKey
extends ConfigKey<GenderPlayer.Gender> {
    private static final GenderPlayer.Gender[] GENDERS = GenderPlayer.Gender.values();

    public GenderConfigKey(String key) {
        super(key, GenderPlayer.Gender.MALE);
    }

    @Override
    protected GenderPlayer.Gender read(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                int ordinal = primitive.getAsInt();
                if (ordinal >= 0 && ordinal < GENDERS.length) {
                    return GENDERS[ordinal];
                }
            } else {
                return primitive.getAsBoolean() ? GenderPlayer.Gender.MALE : GenderPlayer.Gender.FEMALE;
            }
        }
        return (GenderPlayer.Gender)((Object)this.defaultValue);
    }

    @Override
    public void save(JsonObject object, GenderPlayer.Gender value) {
        object.addProperty(this.key, (Number)value.ordinal());
    }
}

