/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.util;

import bre2el.fpsreducer.util.Logger;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ModLib {
    private static MBeanServer mbs;
    private static ObjectName name;
    private static OperatingSystemMXBean osbean;
    private static ThreadMXBean threadbean;
    private static RuntimeMXBean runbean;
    private static int processors;
    private static boolean mxbeanFailed;
    private static long lastProcessCpuTime;
    private static long lastUptime;
    private static long lastThreadCpuTime;

    @Deprecated
    public static double getProcessCpuLoad() {
        AttributeList list;
        try {
            list = mbs.getAttributes(name, new String[]{"ProcessCpuLoad"});
        }
        catch (Exception e) {
            return Double.NaN;
        }
        if (list.isEmpty()) {
            return Double.NaN;
        }
        Attribute attrib = (Attribute)list.get(0);
        Double value = (Double)attrib.getValue();
        if (value == -1.0) {
            return Double.NaN;
        }
        return (double)((int)(value * 1000.0)) / 10.0;
    }

    public static double getCpuUsage(boolean allCpuBasis) {
        if (mxbeanFailed) {
            return -1.0;
        }
        long uptime = runbean.getUptime();
        long processCpuTime = osbean.getProcessCpuTime();
        int cpus = allCpuBasis ? processors : 1;
        double cpu = (float)(processCpuTime - lastProcessCpuTime) / ((float)(uptime - lastUptime) * 10000.0f * (float)cpus);
        lastProcessCpuTime = processCpuTime;
        lastUptime = uptime;
        return cpu;
    }

    public static double getThreadCpuUsage(boolean allCpuBasis) {
        if (mxbeanFailed) {
            return -1.0;
        }
        long uptime = runbean.getUptime();
        long threadId = Thread.currentThread().getId();
        long threadCpuTime = threadbean.getThreadCpuTime(threadId);
        int cpus = allCpuBasis ? processors : 1;
        double cpu = (float)(threadCpuTime - lastThreadCpuTime) / ((float)(uptime - lastUptime) * 10000.0f * (float)cpus);
        lastThreadCpuTime = threadCpuTime;
        lastUptime = uptime;
        return cpu;
    }

    static {
        try {
            mbs = ManagementFactory.getPlatformMBeanServer();
            name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            osbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            threadbean = ManagementFactory.getThreadMXBean();
            runbean = ManagementFactory.getRuntimeMXBean();
            processors = osbean.getAvailableProcessors();
        }
        catch (Exception e) {
            Logger.error("Failed to get MXBeans.");
            e.printStackTrace();
            mxbeanFailed = true;
        }
    }
}

