/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.google.common.io.ByteStreams;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerEvents;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.ControllerToast;
import com.mrcrayfish.controllable.client.IControllerListener;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.RenderEvents;
import com.mrcrayfish.controllable.client.ScreenEvents;
import com.mrcrayfish.controllable.client.gui.screens.ButtonBindingScreen;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

@Mod(value="controllable")
public class Controllable {
    public static final Logger LOGGER = LogManager.getLogger((String)"Controllable");
    private static ControllerManager manager;
    private static Controller controller;
    private static ControllerInput input;
    private static File configFolder;
    private static boolean jeiLoaded;
    private static final Queue<ButtonStates> INPUT_QUEUE;

    public Controllable() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @Nullable
    public static Controller getController() {
        return controller;
    }

    public static ControllerInput getInput() {
        return input;
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded;
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            configFolder = new File(mc.f_91069_, "config");
            jeiLoaded = ModList.get().isLoaded("jei");
            ControllerProperties.load(configFolder);
            try (InputStream is = Mappings.class.getResourceAsStream("/gamecontrollerdb.txt");){
                byte[] bytes;
                ByteBuffer buffer;
                if (is != null && (buffer = MemoryUtil.memASCIISafe((CharSequence)new String(bytes = ByteStreams.toByteArray((InputStream)is)))) != null && GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer)) {
                    LOGGER.info("Successfully updated gamepad mappings");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            manager = new ControllerManager();
            manager.addControllerListener(new IControllerListener(){

                @Override
                public void connected(int jid) {
                    Minecraft.m_91087_().m_6367_(() -> {
                        if (controller == null) {
                            if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue()) {
                                Controllable.setController(new Controller(jid));
                            }
                            Minecraft mc = Minecraft.m_91087_();
                            if (mc.f_91074_ != null && controller != null) {
                                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ControllerToast(true, controller.getName()));
                            }
                        }
                    });
                }

                @Override
                public void disconnected(int jid) {
                    Minecraft.m_91087_().m_6367_(() -> {
                        if (controller != null && controller.getJid() == jid) {
                            Controller oldController = controller;
                            Controllable.setController(null);
                            if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue() && manager.getControllerCount() > 0) {
                                Optional<Integer> optional = manager.getControllers().keySet().stream().min(Comparator.comparing(i -> i));
                                optional.ifPresent(minJid -> Controllable.setController(new Controller((int)minJid)));
                            }
                            Minecraft mc = Minecraft.m_91087_();
                            if (mc.f_91074_ != null) {
                                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ControllerToast(false, oldController.getName()));
                            }
                        }
                    });
                }
            });
            if (((Boolean)Config.CLIENT.options.autoSelect.get()).booleanValue() && GLFW.glfwJoystickPresent((int)0) && GLFW.glfwJoystickIsGamepad((int)0)) {
                Controllable.setController(new Controller(0));
            }
            Mappings.load(configFolder);
            MinecraftForge.EVENT_BUS.register((Object)this);
            input = new ControllerInput();
            MinecraftForge.EVENT_BUS.register((Object)input);
            MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
            MinecraftForge.EVENT_BUS.register((Object)new ScreenEvents(manager));
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
            MinecraftForge.EVENT_BUS.register((Object)RadialMenuHandler.instance());
            MinecraftForge.EVENT_BUS.addListener(this::controllerTick);
            MinecraftForge.EVENT_BUS.addListener(this::renderTick);
        });
    }

    public static void setController(@Nullable Controller controller) {
        if (controller != null) {
            Controllable.controller = controller;
            Mappings.updateControllerMappings(controller);
        } else {
            Controllable.controller = null;
        }
    }

    private void controllerTick(TickEvent.ClientTickEvent event) {
        Controllable.gatherAndQueueControllerInput();
        if (event.phase == TickEvent.Phase.START) {
            while (!INPUT_QUEUE.isEmpty()) {
                Controllable.processButtonStates(INPUT_QUEUE.poll());
            }
        }
    }

    private void renderTick(TickEvent.RenderTickEvent event) {
        Controllable.gatherAndQueueControllerInput();
    }

    private static void gatherAndQueueControllerInput() {
        Controller currentController;
        if (manager != null) {
            manager.update();
        }
        if ((currentController = controller) == null) {
            return;
        }
        currentController.updateGamepadState();
        ButtonStates states = new ButtonStates();
        states.setState(0, Controllable.getButtonState(0));
        states.setState(1, Controllable.getButtonState(1));
        states.setState(2, Controllable.getButtonState(2));
        states.setState(3, Controllable.getButtonState(3));
        states.setState(4, Controllable.getButtonState(6));
        states.setState(5, Controllable.getButtonState(8));
        states.setState(6, Controllable.getButtonState(7));
        states.setState(7, Controllable.getButtonState(9));
        states.setState(8, Controllable.getButtonState(10));
        states.setState(9, Controllable.getButtonState(4));
        states.setState(10, Controllable.getButtonState(5));
        states.setState(11, currentController.getLTriggerValue() >= 0.5f);
        states.setState(12, currentController.getRTriggerValue() >= 0.5f);
        states.setState(13, Controllable.getButtonState(11));
        states.setState(14, Controllable.getButtonState(13));
        states.setState(15, Controllable.getButtonState(14));
        states.setState(16, Controllable.getButtonState(12));
        INPUT_QUEUE.offer(states);
    }

    private static void processButtonStates(ButtonStates states) {
        ButtonBinding.tick();
        for (int i = 0; i < Buttons.BUTTONS.length; ++i) {
            Controllable.processButton(Buttons.BUTTONS[i], states);
        }
    }

    private static void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ControllerLayoutScreen) {
            ((ControllerLayoutScreen)screen).processButton(index, newStates);
            return;
        }
        if (controller == null) {
            return;
        }
        if (controller.getMapping() != null) {
            index = controller.getMapping().remap(index);
        }
        if (index == -1) {
            return;
        }
        ButtonStates states = controller.getButtonsStates();
        if (state) {
            if (!states.getState(index)) {
                states.setState(index, true);
                if (screen instanceof ButtonBindingScreen && ((ButtonBindingScreen)screen).processButton(index)) {
                    return;
                }
                input.handleButtonInput(controller, index, true, false);
            }
        } else if (states.getState(index)) {
            states.setState(index, false);
            input.handleButtonInput(controller, index, false, false);
        }
    }

    public static void queueInputsWait() {
        Minecraft mc = Minecraft.m_91087_();
        int fps = mc.f_91073_ != null || mc.f_91080_ == null && mc.m_91265_() == null ? mc.m_91268_().m_85434_() : 60;
        int captureCount = 4;
        for (int i = 0; i < captureCount; ++i) {
            RenderSystem.m_69830_((int)(fps * captureCount));
            Controllable.gatherAndQueueControllerInput();
        }
    }

    public static boolean isButtonPressed(int button) {
        return controller != null && controller.getButtonsStates().getState(button);
    }

    private static boolean getButtonState(int buttonCode) {
        return controller != null && controller.getGamepadState().buttons(buttonCode) == 1;
    }

    static {
        INPUT_QUEUE = new ArrayDeque<ButtonStates>();
    }
}

