/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ControllerEvents {
    private float prevHealth = -1.0f;

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerUsingItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntity() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (!((Boolean)Config.CLIENT.options.forceFeedback.get()).booleanValue()) {
            return;
        }
        if (Controllable.getInput().getLastUse() <= 0) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller != null) {
            float magnitudeFactor = 0.5f;
            UseAnim action = event.getItem().m_41780_();
            switch (action) {
                case BLOCK: {
                    magnitudeFactor = 0.25f;
                    break;
                }
                case SPEAR: {
                    magnitudeFactor = Mth.m_14036_((float)((float)(event.getItem().m_41779_() - event.getDuration()) / 20.0f), (float)0.0f, (float)0.25f) / 0.25f;
                    break;
                }
                case BOW: {
                    magnitudeFactor = Mth.m_14036_((float)((float)(event.getItem().m_41779_() - event.getDuration()) / 20.0f), (float)0.0f, (float)1.0f) / 1.0f;
                    break;
                }
                case CROSSBOW: {
                    float f = Mth.m_14036_((float)((float)(event.getItem().m_41779_() - event.getDuration()) / 20.0f), (float)0.0f, (float)1.5f) / 1.5f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && ((Boolean)Config.CLIENT.options.forceFeedback.get()).booleanValue()) {
            if (this.prevHealth == -1.0f) {
                this.prevHealth = mc.f_91074_.m_21223_();
            } else if (this.prevHealth > mc.f_91074_.m_21223_()) {
                float difference = this.prevHealth - mc.f_91074_.m_21223_();
                float magnitude = difference / mc.f_91074_.m_21233_();
                this.prevHealth = mc.f_91074_.m_21223_();
            } else {
                this.prevHealth = mc.f_91074_.m_21223_();
            }
        } else if (this.prevHealth != -1.0f) {
            this.prevHealth = -1.0f;
        }
    }
}

