/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.SneakMode;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListEntryNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListWidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ReflectUtil;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.GatherNavigationPointsEvent;
import com.mrcrayfish.controllable.integration.ControllableJeiPlugin;
import com.mrcrayfish.controllable.mixin.client.CreativeModeInventoryScreenMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookComponentMixin;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;

public class ControllerInput {
    private static final ResourceLocation CURSOR_TEXTURE = new ResourceLocation("controllable", "textures/gui/cursor.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private boolean nearSlot = false;
    private boolean moving = false;
    private boolean preventReset;
    private boolean ignoreInput;
    private double virtualMouseX;
    private double virtualMouseY;
    private int prevMouseX;
    private int prevMouseY;
    private int mouseX;
    private int mouseY;
    private double mouseSpeedX;
    private double mouseSpeedY;
    private boolean moved;
    private float targetPitch;
    private float targetYaw;
    private long lastMerchantScroll;
    private int dropCounter = -1;

    public double getVirtualMouseX() {
        return this.virtualMouseX;
    }

    public double getVirtualMouseY() {
        return this.virtualMouseY;
    }

    private void setControllerInUse() {
        this.lastUse = 100;
    }

    public boolean isControllerInUse() {
        return this.lastUse > 0;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void resetLastUse() {
        if (!this.preventReset) {
            this.lastUse = 0;
        }
        this.preventReset = false;
    }

    public boolean isMovingCursor() {
        return this.moving;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Controller controller;
            this.prevMouseX = this.mouseX;
            this.prevMouseY = this.mouseY;
            if (this.lastUse > 0) {
                --this.lastUse;
            }
            if ((controller = Controllable.getController()) == null) {
                return;
            }
            if ((Math.abs(controller.getLTriggerValue()) >= 0.2f || Math.abs(controller.getRTriggerValue()) >= 0.2f) && !(Minecraft.m_91087_().f_91080_ instanceof ControllerLayoutScreen)) {
                this.setControllerInUse();
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91067_.m_91600_()) {
                return;
            }
            if (mc.f_91080_ == null || mc.f_91080_ instanceof ControllerLayoutScreen) {
                return;
            }
            float deadZone = (float)Math.min(1.0, (Double)Config.CLIENT.options.deadZone.get() + 0.25);
            boolean lastMoving = this.moving;
            float xAxis = Config.CLIENT.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickXValue() : controller.getRThumbStickXValue();
            float yAxis = Config.CLIENT.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickYValue() : controller.getRThumbStickYValue();
            boolean bl = this.moving = Math.abs(xAxis) >= deadZone || Math.abs(yAxis) >= deadZone;
            if (this.moving) {
                if (!lastMoving) {
                    double mouseX = mc.f_91067_.m_91589_();
                    double mouseY = mc.f_91067_.m_91594_();
                    if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue()) {
                        mouseX = this.virtualMouseX;
                        mouseY = this.virtualMouseY;
                    }
                    this.prevMouseX = this.mouseX = (int)mouseX;
                    this.prevMouseY = this.mouseY = (int)mouseY;
                }
                this.mouseSpeedX = Math.abs(xAxis) >= deadZone ? (double)(Math.signum(xAxis) * (Math.abs(xAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                this.mouseSpeedY = Math.abs(yAxis) >= deadZone ? (double)(Math.signum(yAxis) * (Math.abs(yAxis) - deadZone) / (1.0f - deadZone)) : 0.0;
                this.setControllerInUse();
            }
            if (this.lastUse <= 0) {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
                return;
            }
            if (Math.abs(this.mouseSpeedX) > 0.0 || Math.abs(this.mouseSpeedY) > 0.0) {
                GuiEventListener hoveredListener;
                RecipeBookComponent recipeBook;
                AbstractContainerScreen screen;
                double mouseSpeed = (Double)Config.CLIENT.options.mouseSpeed.get() * mc.m_91268_().m_85449_();
                Screen screen2 = mc.f_91080_;
                if (screen2 instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse() != null) {
                    mouseSpeed *= ((Double)Config.CLIENT.options.hoverModifier.get()).doubleValue();
                }
                double mouseX = this.virtualMouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
                double mouseY = this.virtualMouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
                ArrayList<Object> eventListeners = new ArrayList<Object>(mc.f_91080_.m_6702_());
                if (mc.f_91080_ instanceof RecipeUpdateListener && (recipeBook = ((RecipeUpdateListener)mc.f_91080_).m_5564_()).m_100385_()) {
                    eventListeners.add(((RecipeBookComponentMixin)recipeBook).getFilterButton());
                    eventListeners.addAll(((RecipeBookComponentMixin)recipeBook).getRecipeTabs());
                    RecipeBookPage recipeBookPage = ((RecipeBookComponentMixin)recipeBook).getRecipeBookPage();
                    eventListeners.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
                    eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
                    eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
                }
                if ((hoveredListener = (GuiEventListener)eventListeners.stream().filter(o -> o != null && o.m_5953_(mouseX, mouseY)).findFirst().orElse(null)) instanceof AbstractSelectionList) {
                    AbstractSelectionList list = (AbstractSelectionList)hoveredListener;
                    hoveredListener = null;
                    int count = list.m_6702_().size();
                    for (int i = 0; i < count; ++i) {
                        ContainerEventHandler handler;
                        GuiEventListener hovered;
                        AbstractSelectionList.Entry entry;
                        int rowTop = ReflectUtil.getAbstractListRowTop(list, i);
                        int rowBottom = ReflectUtil.getAbstractListRowBottom(list, i);
                        if (rowTop < list.getTop() && rowBottom > list.getBottom() || !((entry = (AbstractSelectionList.Entry)list.m_6702_().get(i)) instanceof ContainerEventHandler) || (hovered = (GuiEventListener)(handler = (ContainerEventHandler)entry).m_6702_().stream().filter(o -> o != null && o.m_5953_(mouseX, mouseY)).findFirst().orElse(null)) == null) continue;
                        hoveredListener = hovered;
                        break;
                    }
                }
                if (hoveredListener != null) {
                    mouseSpeed *= ((Double)Config.CLIENT.options.hoverModifier.get()).doubleValue();
                }
                this.mouseX = (int)((double)this.mouseX + mouseSpeed * this.mouseSpeedX);
                this.mouseX = Mth.m_14045_((int)this.mouseX, (int)0, (int)mc.m_91268_().m_85441_());
                this.mouseY = (int)((double)this.mouseY + mouseSpeed * this.mouseSpeedY);
                this.mouseY = Mth.m_14045_((int)this.mouseY, (int)0, (int)mc.m_91268_().m_85442_());
                this.setControllerInUse();
                this.moved = true;
            }
            this.moveMouseToClosestSlot(this.moving, mc.f_91080_);
            if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
                this.handleCreativeScrolling((CreativeModeInventoryScreen)mc.f_91080_, controller);
            }
            if (((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && (this.mouseX != this.prevMouseX || this.mouseY != this.prevMouseY)) {
                this.performMouseDrag(this.virtualMouseX, this.virtualMouseY, this.mouseX - this.prevMouseX, this.mouseY - this.prevMouseY);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onScreenInit(ScreenEvent.Opening event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            this.nearSlot = false;
            this.moved = false;
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
            this.mouseX = this.prevMouseX = (int)((float)mc.m_91268_().m_85441_() / 2.0f);
            this.virtualMouseX = this.prevMouseX;
            this.mouseY = this.prevMouseY = (int)((float)mc.m_91268_().m_85442_() / 2.0f);
            this.virtualMouseY = this.prevMouseY;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(ScreenEvent.Render.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!(mc.f_91080_ == null || this.mouseX == this.prevMouseX && this.mouseY == this.prevMouseY || mc.f_91080_ instanceof ControllerLayoutScreen)) {
            float partialTicks = Minecraft.m_91087_().m_91296_();
            double mouseX = (double)((float)this.prevMouseX + (float)(this.mouseX - this.prevMouseX) * partialTicks) + 0.5;
            double mouseY = (double)((float)this.prevMouseY + (float)(this.mouseY - this.prevMouseY) * partialTicks) + 0.5;
            this.setMousePosition(mouseX, mouseY);
        }
    }

    private void performMouseDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (Controllable.getController() != null) {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen != null && mc.m_91265_() == null) {
                double finalMouseX = mouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
                double finalMouseY = mouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
                Screen.m_96579_(() -> screen.m_94757_(finalMouseX, finalMouseY), (String)"mouseMoved event handler", (String)screen.getClass().getCanonicalName());
                if (mc.f_91067_.f_91510_ != -1 && mc.f_91067_.f_91519_ > 0.0) {
                    Screen.m_96579_(() -> {
                        double finalDragY;
                        double finalDragX = dragX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
                        if (ForgeHooksClient.onScreenMouseDragPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)mc.f_91067_.f_91510_, (double)finalDragX, (double)(finalDragY = dragY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_()))) {
                            return;
                        }
                        if (screen.m_7979_(finalMouseX, finalMouseY, mc.f_91067_.f_91510_, finalDragX, finalDragY)) {
                            return;
                        }
                        ForgeHooksClient.onScreenMouseDragPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)mc.f_91067_.f_91510_, (double)finalDragX, (double)finalDragY);
                    }, (String)"mouseDragged event handler", (String)screen.getClass().getCanonicalName());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(ScreenEvent.Render.Post event) {
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            CursorType type = (CursorType)Config.CLIENT.options.cursorType.get();
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null || minecraft.f_91074_.f_36095_.m_142621_().m_41619_() || type == CursorType.CONSOLE) {
                double mouseX = (float)this.prevMouseX + (float)(this.mouseX - this.prevMouseX) * Minecraft.m_91087_().m_91296_();
                double mouseY = (float)this.prevMouseY + (float)(this.mouseY - this.prevMouseY) * Minecraft.m_91087_().m_91296_();
                poseStack.m_85837_(mouseX / minecraft.m_91268_().m_85449_(), mouseY / minecraft.m_91268_().m_85449_(), 500.0);
                RenderSystem.m_157456_((int)0, (ResourceLocation)CURSOR_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (type == CursorType.CONSOLE) {
                    poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                }
                Screen.m_93160_((PoseStack)poseStack, (int)-8, (int)-8, (int)16, (int)16, (float)(this.nearSlot ? 16.0f : 0.0f), (float)(type.ordinal() * 16), (int)16, (int)16, (int)32, (int)(CursorType.values().length * 16));
            }
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        LocalPlayer player;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double mouseX = this.virtualMouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
        double mouseY = this.virtualMouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
        if (mc.f_91080_ != null && this.lastUse > 0) {
            Screen screen = mc.f_91080_;
            if (screen instanceof MerchantScreen) {
                MerchantScreen screen2 = (MerchantScreen)screen;
                this.handleMerchantScrolling(screen2, controller);
                return;
            }
            GuiEventListener hoveredListener = mc.f_91080_.m_6702_().stream().filter(o -> o.m_5953_(mouseX, mouseY)).findFirst().orElse(null);
            if (hoveredListener instanceof AbstractSelectionList) {
                AbstractSelectionList selectionList = (AbstractSelectionList)hoveredListener;
                this.handleListScrolling(selectionList, controller);
            }
        }
        if ((player = mc.f_91074_) == null) {
            return;
        }
        if (mc.f_91080_ == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = Minecraft.m_91087_().m_91297_();
            if (!RadialMenuHandler.instance().isVisible()) {
                player.m_19884_((double)this.targetYaw / 0.15 * (double)((Boolean)Config.CLIENT.options.invertRotation.get() != false ? -1 : 1) * (double)elapsedTicks, (double)this.targetPitch / 0.15 * (double)((Boolean)Config.CLIENT.options.invertLook.get() != false ? -1 : 1) * (double)elapsedTicks);
            }
            if (player.m_20202_() != null) {
                player.m_20202_().m_7340_((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.f_91080_ == null) {
            ControllerEvent.Turn turnEvent;
            double rotationSpeed;
            float deadZone = ((Double)Config.CLIENT.options.deadZone.get()).floatValue();
            float pitchSensitivity = ((Double)Config.CLIENT.options.pitchSensitivity.get()).floatValue();
            float yawSensitivity = ((Double)Config.CLIENT.options.yawSensitivity.get()).floatValue();
            if (Math.abs(controller.getRThumbStickXValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = (Double)Config.CLIENT.options.rotationSpeed.get();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed * yawSensitivity, (float)rotationSpeed * pitchSensitivity);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimX = (float)(controller.getRThumbStickXValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetYaw = turnEvent.getYawSpeed() * (controller.getRThumbStickXValue() - deadZoneTrimX) / (1.0f - deadZone) * 0.33f;
                }
            }
            if (Math.abs(controller.getRThumbStickYValue()) >= deadZone) {
                this.setControllerInUse();
                rotationSpeed = (Double)Config.CLIENT.options.rotationSpeed.get();
                turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed * yawSensitivity, (float)rotationSpeed * pitchSensitivity);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimY = (float)(controller.getRThumbStickYValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetPitch = turnEvent.getPitchSpeed() * (controller.getRThumbStickYValue() - deadZoneTrimY) / (1.0f - deadZone) * 0.33f;
                }
            }
        }
        if (mc.f_91080_ == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.setControllerInUse();
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.f_91074_.m_5833_()) {
                mc.f_91074_.m_108700_(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.f_91074_.m_5833_()) {
                mc.f_91074_.m_108700_(false);
            }
            this.dropCounter = 0;
        }
    }

    @SubscribeEvent
    public void onOpenScreen(ScreenEvent.Opening event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && ((Boolean)Config.SERVER.restrictToController.get()).booleanValue() && !this.isControllerInUse() && event.getScreen() instanceof ContainerScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMouseClicked(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (mc.f_91080_ == null || mc.f_91080_ instanceof ContainerScreen) && ((Boolean)Config.SERVER.restrictToController.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInputUpdate(MovementInputUpdateEvent event) {
        Controller controller;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (((Boolean)Config.SERVER.restrictToController.get()).booleanValue()) {
            Input input = event.getInput();
            input.f_108566_ = 0.0f;
            input.f_108567_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
        }
        if ((controller = Controllable.getController()) == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (this.keyboardSneaking && !mc.f_91066_.f_92090_.m_90857_()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (Config.CLIENT.options.sneakMode.get() == SneakMode.HOLD) {
            this.sneaking = ButtonBindings.SNEAK.isButtonDown();
        }
        if (mc.f_91066_.f_92090_.m_90857_()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (mc.f_91074_.m_150110_().f_35935_ || mc.f_91074_.m_20159_()) {
            this.sneaking = mc.f_91066_.f_92090_.m_90857_();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            if (ButtonBindings.SNEAK.isButtonDown()) {
                this.setControllerInUse();
            }
            this.isFlying = true;
        } else if (this.isFlying) {
            this.isFlying = false;
        }
        event.getInput().f_108573_ = this.sneaking;
        if (mc.f_91080_ == null) {
            if (!(RadialMenuHandler.instance().isVisible() && Config.CLIENT.options.radialThumbstick.get() == Thumbstick.LEFT || MinecraftForge.EVENT_BUS.post((Event)new ControllerEvent.Move(controller)))) {
                int dir;
                float deadZone = ((Double)Config.CLIENT.options.deadZone.get()).floatValue();
                if (Math.abs(controller.getLThumbStickYValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickYValue() > 0.0f ? -1 : 1;
                    event.getInput().f_108568_ = dir > 0;
                    event.getInput().f_108569_ = dir < 0;
                    event.getInput().f_108567_ = (float)dir * Mth.m_14036_((float)((Math.abs(controller.getLThumbStickYValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                }
                if (player.m_20202_() instanceof Boat) {
                    deadZone = 0.5f;
                }
                if (Math.abs(controller.getLThumbStickXValue()) >= deadZone) {
                    this.setControllerInUse();
                    dir = controller.getLThumbStickXValue() > 0.0f ? -1 : 1;
                    event.getInput().f_108571_ = dir < 0;
                    event.getInput().f_108570_ = dir > 0;
                    event.getInput().f_108566_ = (float)dir * Mth.m_14036_((float)((Math.abs(controller.getLThumbStickXValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                }
            }
            if (this.ignoreInput && !ButtonBindings.JUMP.isButtonDown()) {
                this.ignoreInput = false;
            }
            if (ButtonBindings.JUMP.isButtonDown() && !this.ignoreInput) {
                event.getInput().f_108572_ = true;
            }
        }
        if (ButtonBindings.USE_ITEM.isButtonDown() && mc.f_91011_ == 0 && !mc.f_91074_.m_6117_()) {
            mc.m_91277_();
        }
        float sneakBonus = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)player)), (float)0.0f, (float)1.0f);
        if (player.m_108635_()) {
            event.getInput().f_108567_ *= sneakBonus;
            event.getInput().f_108566_ *= sneakBonus;
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state, boolean virtual) {
        ControllerEvent.Button event;
        if (controller == null) {
            return;
        }
        this.setControllerInUse();
        if (button != -1) {
            ControllerEvent.ButtonInput eventInput = new ControllerEvent.ButtonInput(controller, button, state);
            if (MinecraftForge.EVENT_BUS.post((Event)eventInput)) {
                return;
            }
            button = eventInput.getModifiedButton();
            ButtonBinding.setButtonState(button, state);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new ControllerEvent.Button(controller)))) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (state) {
            if (ButtonBindings.FULLSCREEN.isButtonPressed()) {
                mc.m_91268_().m_85438_();
                mc.f_91066_.m_231829_().m_231514_((Object)mc.m_91268_().m_85440_());
                mc.f_91066_.m_92169_();
            } else if (ButtonBindings.SCREENSHOT.isButtonPressed()) {
                if (mc.f_91073_ != null) {
                    Screenshot.m_92289_((File)mc.f_91069_, (RenderTarget)mc.m_91385_(), component -> mc.execute(() -> mc.f_91065_.m_93076_().m_93785_(component)));
                }
            } else if (mc.f_91080_ == null) {
                if (ButtonBindings.OPEN_INVENTORY.isButtonPressed() && mc.f_91072_ != null && mc.f_91074_ != null) {
                    if (mc.f_91072_.m_105292_()) {
                        mc.f_91074_.m_108628_();
                    } else {
                        mc.m_91301_().m_120564_();
                        mc.m_91152_((Screen)new InventoryScreen((Player)mc.f_91074_));
                    }
                } else if (ButtonBindings.SPRINT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_6858_(true);
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (!(mc.f_91074_ == null || mc.f_91074_.m_150110_().f_35935_ || this.isFlying || mc.f_91074_.m_20159_() || Config.CLIENT.options.sneakMode.get() != SneakMode.TOGGLE)) {
                        this.sneaking = !this.sneaking;
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_150109_().m_35988_(-1.0);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91074_.m_150109_().m_35988_(1.0);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.f_91074_ != null && !mc.f_91074_.m_5833_() && mc.m_91403_() != null) {
                        mc.m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.m_91358_(false);
                    }
                } else if (ButtonBindings.ADVANCEMENTS.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.m_91152_((Screen)new AdvancementsScreen(mc.f_91074_.f_108617_.m_105145_()));
                    }
                } else if (ButtonBindings.CINEMATIC_CAMERA.isButtonPressed()) {
                    if (mc.f_91074_ != null) {
                        mc.f_91066_.f_92067_ = !mc.f_91066_.f_92067_;
                    }
                } else if (ButtonBindings.DEBUG_INFO.isButtonPressed()) {
                    mc.f_91066_.f_92063_ = !mc.f_91066_.f_92063_;
                } else if (ButtonBindings.RADIAL_MENU.isButtonPressed() && !virtual) {
                    RadialMenuHandler.instance().interact();
                } else if (mc.f_91074_ != null) {
                    for (int i = 0; i < 9; ++i) {
                        if (!ButtonBindings.HOTBAR_SLOTS[i].isButtonPressed()) continue;
                        mc.f_91074_.m_150109_().f_35977_ = i;
                        return;
                    }
                    if (!mc.f_91074_.m_6117_()) {
                        if (ButtonBindings.ATTACK.isButtonPressed()) {
                            mc.m_202354_();
                        } else if (ButtonBindings.USE_ITEM.isButtonPressed()) {
                            mc.m_91277_();
                        } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                            mc.m_91280_();
                        }
                    }
                }
            } else if (ButtonBindings.CLOSE_INVENTORY.isButtonPressed()) {
                if (mc.f_91080_ != null) {
                    mc.f_91080_.m_7933_(256, GLFW.glfwGetKeyScancode((int)256), 0);
                }
            } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonPressed()) {
                if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
                    this.scrollCreativeTabs((CreativeModeInventoryScreen)mc.f_91080_, 1);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                } else {
                    Screen screen = mc.f_91080_;
                    if (screen instanceof RecipeUpdateListener) {
                        RecipeUpdateListener listener = (RecipeUpdateListener)screen;
                        this.scrollRecipePage(listener.m_5564_(), 1);
                    }
                }
            } else if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonPressed()) {
                if (mc.f_91080_ instanceof CreativeModeInventoryScreen) {
                    this.scrollCreativeTabs((CreativeModeInventoryScreen)mc.f_91080_, -1);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                } else {
                    Screen screen = mc.f_91080_;
                    if (screen instanceof RecipeUpdateListener) {
                        RecipeUpdateListener listener = (RecipeUpdateListener)screen;
                        this.scrollRecipePage(listener.m_5564_(), -1);
                    }
                }
            } else if (ButtonBindings.NEXT_RECIPE_TAB.isButtonPressed()) {
                Screen screen = mc.f_91080_;
                if (screen instanceof RecipeUpdateListener) {
                    RecipeUpdateListener listener = (RecipeUpdateListener)screen;
                    this.scrollRecipeTab(listener.m_5564_(), -1);
                }
            } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonPressed()) {
                Screen screen = mc.f_91080_;
                if (screen instanceof RecipeUpdateListener) {
                    RecipeUpdateListener listener = (RecipeUpdateListener)screen;
                    this.scrollRecipeTab(listener.m_5564_(), 1);
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.f_91080_ instanceof PauseScreen) {
                    mc.m_91152_(null);
                }
            } else if (ButtonBindings.NAVIGATE_UP.isButtonPressed()) {
                this.navigateMouse(mc.f_91080_, Navigate.UP);
            } else if (ButtonBindings.NAVIGATE_DOWN.isButtonPressed()) {
                this.navigateMouse(mc.f_91080_, Navigate.DOWN);
            } else if (ButtonBindings.NAVIGATE_LEFT.isButtonPressed()) {
                this.navigateMouse(mc.f_91080_, Navigate.LEFT);
            } else if (ButtonBindings.NAVIGATE_RIGHT.isButtonPressed()) {
                this.navigateMouse(mc.f_91080_, Navigate.RIGHT);
            } else if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseClick(mc.f_91080_, 0);
                if (mc.f_91080_ == null) {
                    this.ignoreInput = true;
                }
                if (((Boolean)Config.CLIENT.options.quickCraft.get()).booleanValue()) {
                    this.craftRecipeBookItem();
                }
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseClick(mc.f_91080_, 1);
            } else if (button == ButtonBindings.QUICK_MOVE.getButton() && mc.f_91074_ != null) {
                if (mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    this.invokeMouseClick(mc.f_91080_, 0);
                } else {
                    this.invokeMouseReleased(mc.f_91080_, 1);
                }
            }
        } else if (mc.f_91080_ != null) {
            if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseReleased(mc.f_91080_, 0);
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseReleased(mc.f_91080_, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.m_91087_();
        CameraType cameraType = mc.f_91066_.m_92176_();
        mc.f_91066_.m_92157_(cameraType.m_90614_());
        if (cameraType.m_90612_() != mc.f_91066_.m_92176_().m_90612_()) {
            mc.f_91063_.m_109106_(mc.f_91066_.m_92176_().m_90612_() ? mc.m_91288_() : null);
        }
    }

    private void scrollCreativeTabs(CreativeModeInventoryScreen screen, int dir) {
        this.setControllerInUse();
        try {
            Method method = ObfuscationReflectionHelper.findMethod(CreativeModeInventoryScreen.class, (String)"m_98560_", (Class[])new Class[]{CreativeModeTab.class});
            method.setAccessible(true);
            if (dir > 0) {
                if (screen.m_98628_() < CreativeModeTab.f_40748_.length - 1) {
                    method.invoke((Object)screen, CreativeModeTab.f_40748_[screen.m_98628_() + 1]);
                }
            } else if (dir < 0 && screen.m_98628_() > 0) {
                method.invoke((Object)screen, CreativeModeTab.f_40748_[screen.m_98628_() - 1]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void scrollRecipeTab(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.m_100385_()) {
            return;
        }
        RecipeBookComponentMixin recipeBookMixin = (RecipeBookComponentMixin)recipeBook;
        RecipeBookTabButton currentTab = recipeBookMixin.getCurrentTab();
        List<RecipeBookTabButton> tabs = recipeBookMixin.getRecipeTabs();
        int nextTabIndex = tabs.indexOf(currentTab) + dir;
        if (nextTabIndex >= 0 && nextTabIndex < tabs.size()) {
            RecipeBookTabButton newTab = tabs.get(nextTabIndex);
            currentTab.m_94635_(false);
            recipeBookMixin.setCurrentTab(newTab);
            newTab.m_94635_(true);
            recipeBookMixin.invokeUpdateCollections(true);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private void scrollRecipePage(RecipeBookComponent recipeBook, int dir) {
        if (!recipeBook.m_100385_()) {
            return;
        }
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookComponentMixin)recipeBook).getRecipeBookPage();
        if (dir > 0 && page.getForwardButton().f_93624_ || dir < 0 && page.getBackButton().f_93624_) {
            int currentPage = page.getCurrentPage();
            page.setCurrentPage(currentPage + dir);
            page.invokeUpdateButtonsForPage();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private void navigateMouse(Screen screen, Navigate navigate) {
        Minecraft mc = Minecraft.m_91087_();
        int mouseX = (int)((double)this.mouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_());
        int mouseY = (int)((double)this.mouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_());
        List<NavigationPoint> points = this.gatherNavigationPoints(screen, navigate, mouseX, mouseY);
        GatherNavigationPointsEvent event = new GatherNavigationPointsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        points.addAll(event.getPoints());
        points.removeIf(p -> !navigate.getPredicate().test((NavigationPoint)p, mouseX, mouseY));
        if (points.isEmpty()) {
            return;
        }
        Vector3d mousePos = new Vector3d((double)mouseX, (double)mouseY, 0.0);
        Optional<NavigationPoint> minimumPointOptional = points.stream().min(navigate.getMinComparator(mouseX, mouseY));
        double minimumDelta = navigate.getKeyExtractor().apply(minimumPointOptional.get(), mousePos) + 10.0;
        Optional<NavigationPoint> targetPointOptional = points.stream().filter(point -> navigate.getKeyExtractor().apply((NavigationPoint)point, mousePos) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(mouseX, mouseY)));
        if (targetPointOptional.isPresent()) {
            NavigationPoint targetPoint = targetPointOptional.get();
            targetPoint.onNavigate();
            mc.m_6937_(() -> {
                this.performMouseDrag(this.mouseX, this.mouseY, 0.0, 0.0);
                int screenX = (int)(targetPoint.getX() / ((double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_()));
                int screenY = (int)(targetPoint.getY() / ((double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_()));
                double lastTarxpos = this.mouseX;
                double lastTarypos = this.mouseY;
                this.mouseX = this.prevMouseX = screenX;
                this.mouseY = this.prevMouseY = screenY;
                this.setMousePosition(screenX, screenY);
                if (((Boolean)Config.CLIENT.options.uiSounds.get()).booleanValue()) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12019_, (float)2.0f));
                }
                this.performMouseDrag(this.mouseX, this.mouseY, (double)screenX - lastTarxpos, (double)screenY - lastTarypos);
            });
        }
    }

    private List<NavigationPoint> gatherNavigationPoints(Screen screen, Navigate navigate, int mouseX, int mouseY) {
        RecipeBookComponent recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            int guiLeft = containerScreen.getGuiLeft();
            int n = containerScreen.getGuiTop();
            for (Slot slot : containerScreen.m_6262_().f_38839_) {
                if (containerScreen.getSlotUnderMouse() == slot) continue;
                int posX = guiLeft + slot.f_40220_ + 8;
                int posY = n + slot.f_40221_ + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        ArrayList<Object> widgets = new ArrayList<Object>();
        for (GuiEventListener guiEventListener : screen.m_6702_()) {
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                if (widget.f_93623_ && widget.f_93624_) {
                    widgets.add((AbstractWidget)guiEventListener);
                    continue;
                }
            }
            if (!(guiEventListener instanceof AbstractSelectionList)) continue;
            AbstractSelectionList list = (AbstractSelectionList)guiEventListener;
            int count = list.m_6702_().size();
            int itemHeight = ReflectUtil.getListItemHeight(list);
            for (int i = 0; i < count; ++i) {
                AbstractSelectionList.Entry entry = (AbstractSelectionList.Entry)list.m_6702_().get(i);
                int rowTop = ReflectUtil.getAbstractListRowTop(list, i);
                int rowBottom = ReflectUtil.getAbstractListRowBottom(list, i);
                if (rowTop > list.getTop() - itemHeight && rowBottom < list.getBottom() + itemHeight) {
                    if (navigate == Navigate.UP || navigate == Navigate.DOWN) {
                        points.add(new ListEntryNavigationPoint(list, entry, i));
                    }
                    if (!(entry instanceof ContainerEventHandler)) continue;
                    ContainerEventHandler handler = (ContainerEventHandler)entry;
                    for (GuiEventListener child : handler.m_6702_()) {
                        if (!(child instanceof AbstractWidget)) continue;
                        AbstractWidget widget = (AbstractWidget)child;
                        if (!widget.f_93623_ || !widget.f_93624_) continue;
                        points.add(new ListWidgetNavigationPoint(widget, list, entry));
                    }
                    continue;
                }
                if (!list.m_5953_((double)mouseX, (double)mouseY)) continue;
                points.add(new ListEntryNavigationPoint(list, entry, i));
            }
        }
        if (screen instanceof RecipeUpdateListener && (recipeBook = ((RecipeUpdateListener)screen).m_5564_()).m_100385_()) {
            widgets.add(((RecipeBookComponentMixin)recipeBook).getFilterButton());
            widgets.addAll(((RecipeBookComponentMixin)recipeBook).getRecipeTabs());
            RecipeBookPage recipeBookPage = ((RecipeBookComponentMixin)recipeBook).getRecipeBookPage();
            widgets.addAll(((RecipeBookPageAccessor)recipeBookPage).getButtons());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getForwardButton());
            widgets.add(((RecipeBookPageAccessor)recipeBookPage).getBackButton());
        }
        for (AbstractWidget abstractWidget : widgets) {
            if (abstractWidget == null || abstractWidget.m_198029_() || !abstractWidget.f_93624_ || !abstractWidget.f_93623_) continue;
            int posX = abstractWidget.f_93620_ + abstractWidget.m_5711_() / 2;
            int posY = abstractWidget.f_93621_ + abstractWidget.m_93694_() / 2;
            points.add(new WidgetNavigationPoint((double)posX, (double)posY, (Widget)abstractWidget));
        }
        if (screen instanceof CreativeModeInventoryScreen) {
            int tabPage = CreativeModeInventoryScreenMixin.getTabPage();
            int n = tabPage * 10;
            int end = Math.min(CreativeModeTab.f_40748_.length, (tabPage + 1) * 10 + 2);
            for (int i = n; i < end; ++i) {
                CreativeModeTab group = CreativeModeTab.f_40748_[i];
                if (group == null) continue;
                points.add(this.getCreativeTabPoint((AbstractContainerScreen<?>)((CreativeModeInventoryScreen)screen), group));
            }
        }
        if (Controllable.isJeiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(ControllableJeiPlugin.getNavigationPoints());
        }
        return points;
    }

    private BasicNavigationPoint getCreativeTabPoint(AbstractContainerScreen<?> screen, CreativeModeTab tab) {
        boolean topRow = tab.m_40794_();
        int column = tab.m_40793_();
        int width = 28;
        int height = 32;
        int x = screen.getGuiLeft() + width * column;
        int y = screen.getGuiTop();
        x = tab.m_6563_() ? screen.getGuiLeft() + screen.getXSize() - width * (6 - column) : (column > 0 ? x + column : x);
        y = topRow ? y - width : y + (screen.getYSize() - 4);
        return new BasicNavigationPoint((double)x + (double)width / 2.0, (double)y + (double)height / 2.0);
    }

    private void craftRecipeBookItem() {
        AbstractContainerScreen screen;
        Screen screen2;
        block10: {
            block9: {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ == null) {
                    return;
                }
                screen2 = mc.f_91080_;
                if (!(screen2 instanceof AbstractContainerScreen)) break block9;
                screen = (AbstractContainerScreen)screen2;
                screen2 = mc.f_91080_;
                if (screen2 instanceof RecipeUpdateListener) break block10;
            }
            return;
        }
        RecipeUpdateListener listener = (RecipeUpdateListener)screen2;
        if (!listener.m_5564_().m_100385_()) {
            return;
        }
        if (!(screen.m_6262_() instanceof RecipeBookMenu)) {
            return;
        }
        RecipeBookPage recipeBookPage = ((RecipeBookComponentMixin)listener.m_5564_()).getRecipeBookPage();
        RecipeButton recipeButton = ((RecipeBookPageAccessor)recipeBookPage).getButtons().stream().filter(AbstractWidget::m_198029_).findFirst().orElse(null);
        if (recipeButton != null) {
            RecipeBookMenu menu = (RecipeBookMenu)screen.m_6262_();
            Slot slot = menu.m_38853_(menu.m_6636_());
            if (menu.m_142621_().m_41619_()) {
                this.invokeMouseClick((Screen)screen, 0, screen.getGuiLeft() + slot.f_40220_ + 8, screen.getGuiTop() + slot.f_40221_ + 8);
            } else {
                this.invokeMouseReleased((Screen)screen, 0, screen.getGuiLeft() + slot.f_40220_ + 8, screen.getGuiTop() + slot.f_40221_ + 8);
            }
        }
    }

    private void moveMouseToClosestSlot(boolean moving, Screen screen) {
        this.nearSlot = false;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (!this.moved) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            int guiLeft = containerScreen.getGuiLeft();
            int guiTop = containerScreen.getGuiTop();
            int mouseX = (int)((double)this.mouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_());
            int mouseY = (int)((double)this.mouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_());
            Slot closestSlot = null;
            double closestDistance = -1.0;
            for (Slot slot : containerScreen.m_6262_().f_38839_) {
                int posX = guiLeft + slot.f_40220_ + 8;
                int posY = guiTop + slot.f_40221_ + 8;
                double distance = Math.sqrt(Math.pow(posX - mouseX, 2.0) + Math.pow(posY - mouseY, 2.0));
                if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                closestSlot = slot;
                closestDistance = distance;
            }
            if (closestSlot != null && (closestSlot.m_6657_() || !containerScreen.m_6262_().m_142621_().m_41619_())) {
                this.nearSlot = true;
                int slotCenterXScaled = guiLeft + closestSlot.f_40220_ + 8;
                int slotCenterYScaled = guiTop + closestSlot.f_40221_ + 8;
                int slotCenterX = (int)((double)slotCenterXScaled / ((double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_()));
                int slotCenterY = (int)((double)slotCenterYScaled / ((double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_()));
                double deltaX = slotCenterX - this.mouseX;
                double deltaY = slotCenterY - this.mouseY;
                if (!moving) {
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.mouseX = (int)((double)this.mouseX + deltaX * 0.75);
                        this.mouseY = (int)((double)this.mouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX = 0.0;
                        this.mouseSpeedY = 0.0;
                    }
                }
                this.mouseSpeedX *= 0.75;
                this.mouseSpeedY *= 0.75;
            } else {
                this.mouseSpeedX = 0.0;
                this.mouseSpeedY = 0.0;
            }
        } else {
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
        }
    }

    private void setMousePosition(double mouseX, double mouseY) {
        if (((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue()) {
            this.virtualMouseX = mouseX;
            this.virtualMouseY = mouseY;
        } else {
            Minecraft mc = Minecraft.m_91087_();
            GLFW.glfwSetCursorPos((long)mc.m_91268_().m_85439_(), (double)mouseX, (double)mouseY);
            this.preventReset = true;
        }
    }

    private void handleCreativeScrolling(CreativeModeInventoryScreen creative, Controller controller) {
        try {
            int i = (((CreativeModeInventoryScreen.ItemPickerMenu)creative.m_6262_()).f_98639_.size() + 9 - 1) / 9 - 5;
            int dir = 0;
            if (controller.getRThumbStickYValue() <= -0.8f) {
                dir = 1;
            } else if (controller.getRThumbStickYValue() >= 0.8f) {
                dir = -1;
            }
            Field field = ObfuscationReflectionHelper.findField(CreativeModeInventoryScreen.class, (String)"f_98508_");
            field.setAccessible(true);
            float currentScroll = field.getFloat(creative);
            currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
            currentScroll = Mth.m_14036_((float)currentScroll, (float)0.0f, (float)1.0f);
            field.setFloat(creative, currentScroll);
            ((CreativeModeInventoryScreen.ItemPickerMenu)creative.m_6262_()).m_98642_(currentScroll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void handleListScrolling(AbstractSelectionList<?> list, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.2f) {
            this.setControllerInUse();
            dir = yValue;
        }
        list.m_93410_(list.m_93517_() + (dir *= (double)Minecraft.m_91087_().m_91297_()) * (Double)Config.CLIENT.options.listScrollSpeed.get());
    }

    private void handleMerchantScrolling(MerchantScreen screen, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.5f) {
            this.setControllerInUse();
            dir = -yValue;
        } else {
            this.lastMerchantScroll = 0L;
        }
        long scrollTime = Util.m_137550_();
        if (dir != 0.0 && scrollTime - this.lastMerchantScroll >= 150L) {
            screen.m_6050_(this.getMouseX(), this.getMouseY(), Math.signum(dir));
            this.lastMerchantScroll = scrollTime;
        }
    }

    private double getMouseX() {
        Minecraft mc = Minecraft.m_91087_();
        double mouseX = mc.f_91067_.m_91589_();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            mouseX = this.virtualMouseX;
        }
        return mouseX * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85441_();
    }

    private double getMouseY() {
        Minecraft mc = Minecraft.m_91087_();
        double mouseY = mc.f_91067_.m_91594_();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.options.virtualMouse.get()).booleanValue() && this.lastUse > 0) {
            mouseY = this.virtualMouseY;
        }
        return mouseY * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85442_();
    }

    private void invokeMouseClick(Screen screen, int button) {
        if (screen != null) {
            double mouseX = this.getMouseX();
            double mouseY = this.getMouseY();
            this.invokeMouseClick(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseClick(Screen screen, int button, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (screen != null) {
            mc.f_91067_.f_91510_ = button;
            mc.f_91067_.f_91519_ = Blaze3D.m_83640_();
            Screen.m_96579_(() -> {
                boolean cancelled = ForgeHooksClient.onScreenMouseClickedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.m_6375_(mouseX, mouseY, button);
                    ForgeHooksClient.onScreenMouseClickedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)cancelled);
                }
            }, (String)"mouseClicked event handler", (String)screen.getClass().getCanonicalName());
        }
    }

    private void invokeMouseReleased(Screen screen, int button) {
        if (screen != null) {
            double mouseX = this.getMouseX();
            double mouseY = this.getMouseY();
            this.invokeMouseReleased(screen, button, mouseX, mouseY);
        }
    }

    private void invokeMouseReleased(Screen screen, int button, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (screen != null) {
            mc.f_91067_.f_91510_ = -1;
            Screen.m_96579_(() -> {
                boolean cancelled = ForgeHooksClient.onScreenMouseReleasedPre((Screen)screen, (double)mouseX, (double)mouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.m_6348_(mouseX, mouseY, button);
                    ForgeHooksClient.onScreenMouseReleasedPost((Screen)screen, (double)mouseX, (double)mouseY, (int)button, (boolean)cancelled);
                }
            }, (String)"mouseReleased event handler", (String)screen.getClass().getCanonicalName());
        }
    }

    private static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.f_86214_)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.f_86214_)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.f_86215_)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.f_86215_));

        private NavigatePredicate predicate;
        private BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate getPredicate() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vector3d, Double> getKeyExtractor() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> getMinComparator(int mouseX, int mouseY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vector3d((double)mouseX, (double)mouseY, 0.0)));
        }

        public static void main(String[] args) {
            int slotX = 10;
            int slotY = 20;
            int mouseX = 50;
            int mouseY = 20;
            Navigate.angle(new SlotNavigationPoint((double)slotX, (double)slotY, null), mouseX, mouseY, 0.0);
        }

        private static boolean angle(NavigationPoint point, int mouseX, int mouseY, double offset) {
            double angle = Math.toDegrees(Math.atan2(point.getY() - (double)mouseY, point.getX() - (double)mouseX)) + offset;
            return angle > -45.0 && angle < 45.0;
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }
}

