/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.client.IControllerListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lwjgl.glfw.GLFW;

public class ControllerManager {
    private Set<IControllerListener> listeners = new HashSet<IControllerListener>();
    private Map<Integer, String> controllers = new HashMap<Integer, String>();

    public void update() {
        int connectedCount = 0;
        for (int jid2 = 0; jid2 <= 15; ++jid2) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid2)) continue;
            ++connectedCount;
        }
        if (connectedCount == this.controllers.size()) {
            return;
        }
        Map<Integer, String> oldControllers = this.controllers;
        HashMap<Integer, String> newControllers = new HashMap<Integer, String>();
        for (int jid3 = 0; jid3 <= 15; ++jid3) {
            if (!GLFW.glfwJoystickIsGamepad((int)jid3)) continue;
            String controllerName = GLFW.glfwGetGamepadName((int)jid3);
            newControllers.put(jid3, controllerName);
        }
        this.controllers = newControllers;
        newControllers.forEach((jid, name) -> {
            if (!oldControllers.containsKey(jid)) {
                this.listeners.forEach(listener -> listener.connected((int)jid));
            }
        });
        oldControllers.forEach((jid, name) -> {
            if (!newControllers.containsKey(jid)) {
                this.listeners.forEach(listener -> listener.disconnected((int)jid));
            }
        });
    }

    public Map<Integer, String> getControllers() {
        return this.controllers;
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    public void addControllerListener(IControllerListener listener) {
        this.listeners.add(listener);
    }
}

