/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.client.ButtonBinding;
import java.lang.reflect.Field;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class KeyAdapterBinding
extends ButtonBinding {
    private static Field pressedTimeField;
    private final KeyMapping keyMapping;
    private final String labelKey;

    public KeyAdapterBinding(int button, KeyMapping keyMapping) {
        super(button, keyMapping.m_90860_() + ".custom", "key.categories.controllable_custom", keyMapping.getKeyConflictContext());
        this.keyMapping = keyMapping;
        this.labelKey = keyMapping.m_90860_();
    }

    @Override
    public String getLabelKey() {
        return this.labelKey;
    }

    public KeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    @Override
    protected void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.keyMapping.m_7249_(pressed);
        if (pressed) {
            this.updateKeyBindPressTime();
        }
        this.handlePressed(pressed ? 1 : 0, this.keyMapping.getKey().m_84873_(), 0);
    }

    @Override
    protected void onPressTick() {
    }

    private void updateKeyBindPressTime() {
        if (pressedTimeField == null) {
            pressedTimeField = ObfuscationReflectionHelper.findField(KeyMapping.class, (String)"f_90818_");
        }
        try {
            pressedTimeField.set(this.keyMapping, 1);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void handlePressed(int action, int key, int modifiers) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null) {
            boolean[] cancelled = new boolean[]{false};
            Screen.m_96579_(() -> {
                if (action == 0) {
                    cancelled[0] = ForgeHooksClient.onScreenKeyReleasedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    if (!cancelled[0]) {
                        cancelled[0] = screen.m_7920_(key, -1, modifiers);
                    }
                    if (!cancelled[0]) {
                        cancelled[0] = ForgeHooksClient.onScreenKeyReleasedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    }
                } else if (action == 1) {
                    cancelled[0] = ForgeHooksClient.onScreenKeyPressedPre((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    if (!cancelled[0]) {
                        cancelled[0] = screen.m_7933_(key, -1, modifiers);
                    }
                    if (!cancelled[0]) {
                        cancelled[0] = ForgeHooksClient.onScreenKeyPressedPost((Screen)screen, (int)key, (int)-1, (int)modifiers);
                    }
                }
            }, (String)"keyPressed event handler", (String)screen.getClass().getCanonicalName());
            if (cancelled[0]) {
                return;
            }
        }
        ForgeHooksClient.onKeyInput((int)this.keyMapping.getKey().m_84873_(), (int)0, (int)action, (int)0);
    }
}

