/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.event.GatherRadialMenuItemsEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RadialMenuHandler {
    private static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private static final int ANIMATE_DURATION = 5;
    private static RadialMenuHandler instance;
    private boolean loaded;
    private boolean visible;
    private int animateTicks;
    private int prevAnimateTicks;
    private Set<ButtonBindingData> bindings = new LinkedHashSet<ButtonBindingData>();
    private AbstractRadialItem settingsItem;
    private AbstractRadialItem closeItem;
    private List<AbstractRadialItem> allItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> leftItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> rightItems = new ArrayList<AbstractRadialItem>();
    private AbstractRadialItem selected;

    public static RadialMenuHandler instance() {
        if (instance == null) {
            instance = new RadialMenuHandler();
        }
        return instance;
    }

    private RadialMenuHandler() {
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
                JsonArray bindings = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
                bindings.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String key = GsonHelper.m_13906_((JsonObject)object, (String)"key");
                    String colorName = GsonHelper.m_13906_((JsonObject)object, (String)"color");
                    ButtonBinding binding = BindingRegistry.getInstance().getBindingByDescriptionKey(key);
                    if (binding != null) {
                        ChatFormatting color = ChatFormatting.m_126657_((String)colorName);
                        if (color == null || color.m_126665_() == null) {
                            color = ChatFormatting.YELLOW;
                        }
                        this.bindings.add(new ButtonBindingData(binding, color));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.bindings.addAll(this.getBindings());
            this.save();
        }
        this.loaded = true;
    }

    private void save() {
        JsonArray array = new JsonArray();
        this.bindings.forEach(data -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", data.getBinding().getDescription());
            object.addProperty("color", data.getColor().name());
            array.add((JsonElement)object);
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)array);
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            writer.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ButtonBindingData> getDefaults() {
        ArrayList<ButtonBindingData> defaults = new ArrayList<ButtonBindingData>();
        defaults.add(new ButtonBindingData(ButtonBindings.ADVANCEMENTS, ChatFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.DEBUG_INFO, ChatFormatting.AQUA));
        defaults.add(new ButtonBindingData(ButtonBindings.SCREENSHOT, ChatFormatting.GOLD));
        defaults.add(new ButtonBindingData(ButtonBindings.FULLSCREEN, ChatFormatting.YELLOW));
        defaults.add(new ButtonBindingData(ButtonBindings.CINEMATIC_CAMERA, ChatFormatting.GREEN));
        defaults.add(new ButtonBindingData(ButtonBindings.HIGHLIGHT_PLAYERS, ChatFormatting.GREEN));
        return defaults;
    }

    public void interact() {
        if (this.visible) {
            if (this.selected != null) {
                this.selected.onUseItem(this);
            }
        } else {
            this.load();
            this.setVisibility(true);
            this.populateAndConstruct();
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12492_, (float)1.5f));
        }
    }

    public AbstractRadialItem getSelected() {
        return this.selected;
    }

    public LinkedHashSet<ButtonBindingData> getBindings() {
        return new LinkedHashSet<ButtonBindingData>(this.bindings);
    }

    public void setBindings(Set<ButtonBindingData> bindings) {
        this.bindings = bindings;
        this.save();
        this.populateAndConstruct();
    }

    public void removeBinding(ButtonBinding binding) {
        if (this.bindings.removeIf(data -> data.getBinding() == binding)) {
            this.save();
            this.populateAndConstruct();
        }
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public void clearAnimation() {
        this.animateTicks = 0;
        this.prevAnimateTicks = 0;
    }

    private void populateAndConstruct() {
        this.rightItems.clear();
        this.leftItems.clear();
        ArrayList<AbstractRadialItem> items = new ArrayList<AbstractRadialItem>();
        this.bindings.forEach(binding -> items.add(new ButtonBindingItem((ButtonBindingData)binding)));
        GatherRadialMenuItemsEvent event = new GatherRadialMenuItemsEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        items.addAll(event.getItems());
        int rightSize = items.size() / 2;
        for (int i = 0; i < rightSize; ++i) {
            float gap = 180.0f / (float)(rightSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(gap * (float)i + gap);
            this.rightItems.add(item);
        }
        int leftSize = items.size() - rightSize;
        for (int i = rightSize; i < items.size(); ++i) {
            float gap = 180.0f / (float)(leftSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(360.0f - gap * (float)(i - rightSize) - gap);
            this.leftItems.add((AbstractRadialItem)items.get(i));
        }
        this.settingsItem = new RadialSettingsItem();
        this.settingsItem.setAngle(0.0f);
        items.add(this.settingsItem);
        this.closeItem = new CloseRadialMenuItem();
        this.closeItem.setAngle(180.0f);
        items.add(this.closeItem);
        this.selected = this.closeItem;
        this.allItems = items;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !this.visible || !Controllable.getInput().isControllerInUse()) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null) {
            return;
        }
        if (Controllable.getController() != null && (this.visible || this.animateTicks > 0 || this.prevAnimateTicks > 0)) {
            this.renderRadialMenu(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevAnimateTicks = this.animateTicks;
        if (this.visible) {
            if (this.animateTicks < 5) {
                ++this.animateTicks;
            }
        } else if (this.animateTicks > 0) {
            --this.animateTicks;
        }
    }

    private void renderRadialMenu(float partialTicks) {
        this.updateSelected();
        PoseStack poseStack = new PoseStack();
        Minecraft mc = Minecraft.m_91087_();
        float animation = Mth.m_14179_((float)partialTicks, (float)this.prevAnimateTicks, (float)this.animateTicks) / 5.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        animation = (float)(1.0 + (double)c3 * Math.pow(animation - 1.0f, 3.0) + (double)c1 * Math.pow(animation - 1.0f, 2.0));
        Screen.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_(), (int)2014318608);
        poseStack.m_85837_(0.0, -10.0, 0.0);
        poseStack.m_85837_((double)((int)((float)mc.m_91268_().m_85445_() / 2.0f)), (double)((int)((float)mc.m_91268_().m_85446_() / 2.0f)), 0.0);
        poseStack.m_85836_();
        this.settingsItem.draw(poseStack, mc, false, this.selected == this.settingsItem, animation);
        poseStack.m_85849_();
        poseStack.m_85836_();
        this.closeItem.draw(poseStack, mc, false, this.selected == this.closeItem, animation);
        poseStack.m_85849_();
        this.drawRadialItems(this.rightItems, poseStack, mc, animation);
        this.drawRadialItems(this.leftItems, poseStack, mc, animation);
    }

    private void drawRadialItems(List<AbstractRadialItem> items, PoseStack matrixStack, Minecraft mc, float animation) {
        for (int i = 0; i < items.size(); ++i) {
            AbstractRadialItem item = items.get(i);
            matrixStack.m_85836_();
            if (i == 0) {
                matrixStack.m_85837_(0.0, -10.0, 0.0);
            }
            if (i == items.size() - 1) {
                matrixStack.m_85837_(0.0, 10.0, 0.0);
            }
            boolean left = item.angle >= 180.0f;
            float x = (float)Math.cos(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            float y = (float)Math.sin(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            matrixStack.m_85837_((double)((int)x), (double)((int)y), 0.0);
            item.draw(matrixStack, mc, left, this.selected == item, animation);
            matrixStack.m_85849_();
        }
    }

    private void updateSelected() {
        float yValue;
        if (!this.visible) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float xValue = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickXValue() : controller.getLThumbStickXValue();
        float f = yValue = Config.CLIENT.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(xValue) <= 0.5f && Math.abs(yValue) <= 0.5f) {
            return;
        }
        float selectedAngle = (float)(Mth.m_14175_((double)(Math.toDegrees(Math.atan2(yValue, xValue)) - 90.0)) + 180.0);
        Optional closest = this.allItems.stream().min((o1, o2) -> Mth.m_14145_((float)o1.angle, (float)selectedAngle) > Mth.m_14145_((float)o2.angle, (float)selectedAngle) ? 1 : 0);
        if (closest.isEmpty()) {
            return;
        }
        if (closest.get() == this.selected) {
            return;
        }
        this.selected = (AbstractRadialItem)closest.get();
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)Config.CLIENT.options.uiSounds.get()).booleanValue()) {
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12019_, (float)1.5f));
        }
    }

    private Optional<AbstractRadialItem> getSelectedItem() {
        return Optional.empty();
    }

    public static abstract class AbstractRadialItem {
        protected Component label;
        protected Component description;
        private float angle;

        protected AbstractRadialItem(Component label) {
            this(label, null);
        }

        protected AbstractRadialItem(Component label, Component description) {
            this.label = label;
            this.description = description;
        }

        public Component getLabel() {
            return this.label;
        }

        @Nullable
        public Component getDescription() {
            return this.description;
        }

        public boolean isEmpty() {
            return false;
        }

        public abstract void onUseItem(RadialMenuHandler var1);

        protected abstract void draw(PoseStack var1, Minecraft var2, boolean var3, boolean var4, float var5);

        protected void playSound(SoundEvent event, float pitch) {
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)pitch));
        }

        void setAngle(float angle) {
            this.angle = angle;
        }
    }

    public static final class RadialSettingsItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.m_237115_((String)"controllable.gui.configure");

        public RadialSettingsItem() {
            super((Component)Component.m_237115_((String)"controllable.gui.radial.settings"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            handler.clearAnimation();
            Minecraft.m_91087_().m_91152_((Screen)new RadialMenuConfigureScreen(handler.getBindings()));
        }

        @Override
        protected void draw(PoseStack matrixStack, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color >> 0 & 0xFF) / 255.0f;
            matrixStack.m_85837_(0.0, -90.0, 0.0);
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69464_();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            RenderSystem.m_69481_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Screen.m_93160_((PoseStack)matrixStack, (int)-10, (int)-10, (int)20, (int)20, (float)88.0f, (float)15.0f, (int)10, (int)10, (int)256, (int)256);
            if (selected) {
                Screen.m_93215_((PoseStack)matrixStack, (Font)mc.f_91062_, (Component)LABEL, (int)0, (int)21, (int)0xFFFFFF);
            }
        }
    }

    public static final class CloseRadialMenuItem
    extends AbstractRadialItem {
        private static final Component LABEL = Component.m_237115_((String)"controllable.gui.close");

        public CloseRadialMenuItem() {
            super((Component)Component.m_237115_((String)"controllable.gui.radial.close"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12492_, (float)1.3f));
        }

        @Override
        protected void draw(PoseStack matrixStack, Minecraft mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color >> 0 & 0xFF) / 255.0f;
            matrixStack.m_85837_(0.0, 90.0, 0.0);
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69464_();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, -15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 15.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 15.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), -14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, 15.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrixStack.m_85850_().m_85861_(), 14.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            RenderSystem.m_69481_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Screen.m_93160_((PoseStack)matrixStack, (int)-10, (int)-10, (int)20, (int)20, (float)98.0f, (float)15.0f, (int)10, (int)10, (int)256, (int)256);
            if (selected) {
                Screen.m_93215_((PoseStack)matrixStack, (Font)mc.f_91062_, (Component)LABEL, (int)0, (int)-30, (int)0xFFFFFF);
            }
        }
    }

    private static class ButtonBindingItem
    extends AbstractRadialItem {
        public ButtonBindingData entry;

        public ButtonBindingItem(ButtonBindingData entry) {
            super((Component)Component.m_237115_((String)entry.getBinding().getLabelKey()).m_130940_(entry.getColor()), (Component)Component.m_237115_((String)entry.getBinding().getCategory()));
            this.entry = entry;
        }

        @Override
        public void onUseItem(RadialMenuHandler radialMenu) {
            radialMenu.setVisibility(false);
            radialMenu.clearAnimation();
            this.entry.getBinding().setActiveAndPressed();
            Controllable.getInput().handleButtonInput(Controllable.getController(), -1, true, true);
        }

        @Override
        protected void draw(PoseStack poseStack, Minecraft mc, boolean left, boolean selected, float animation) {
            int offset;
            poseStack.m_85836_();
            int color = selected ? -3355444 : mc.f_91066_.m_92170_(0.7f);
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color >> 0 & 0xFF) / 255.0f;
            float start = left ? -1.0f : 1.0f;
            float end = (left ? -150.0f : 150.0f) * animation;
            poseStack.m_85837_((double)((1.0f - animation) * (float)(left ? -20 : 20)), 0.0, 0.0);
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69464_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), start, -15.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), start, -14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, -14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, -15.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, -14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), 0.0f, 14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, 14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, -14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), start, 14.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), start, 15.0f, 0.0f).m_85950_(red, green, blue, alpha * animation).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, 15.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            buffer.m_85982_(poseStack.m_85850_().m_85861_(), end, 14.0f, 0.0f).m_85950_(red, green, blue, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.m_69461_();
            RenderSystem.m_69493_();
            RenderSystem.m_69481_();
            if (this.label != null) {
                offset = !left ? 5 : -mc.f_91062_.m_92852_((FormattedText)this.label) - 5;
                Screen.m_93243_((PoseStack)poseStack, (Font)mc.f_91062_, (Component)this.label, (int)offset, (int)-10, (int)0xFFFFFF);
            }
            if (this.description != null) {
                offset = !left ? 5 : -mc.f_91062_.m_92852_((FormattedText)this.description) - 5;
                Screen.m_93243_((PoseStack)poseStack, (Font)mc.f_91062_, (Component)this.description, (int)offset, (int)2, (int)0xFFFFFF);
            }
            poseStack.m_85849_();
        }
    }
}

