/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionDescriptions;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.ControllerIcons;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.event.GatherActionsEvent;
import com.mrcrayfish.controllable.event.RenderAvailableActionsEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    public static final ResourceLocation CONTROLLER_BUTTONS = new ResourceLocation("controllable", "textures/gui/buttons.png");
    private Map<Integer, Action> actions = new HashMap<Integer, Action>();
    private int selectedRadialIndex = -1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START && mc.f_91074_ != null && !mc.f_91066_.f_92062_) {
            this.actions.clear();
            LinkedHashMap<ButtonBinding, Action> actionMap = new LinkedHashMap<ButtonBinding, Action>();
            ActionVisibility visibility = (ActionVisibility)Config.CLIENT.options.showActions.get();
            if (visibility == ActionVisibility.NONE) {
                return;
            }
            boolean verbose = visibility == ActionVisibility.ALL;
            Screen screen = mc.f_91080_;
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                if (mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    if (containerScreen.getSlotUnderMouse() != null && (slot = containerScreen.getSlotUnderMouse()).m_6657_()) {
                        actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PICKUP_STACK, Action.Side.LEFT));
                        actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.SPLIT_STACK, Action.Side.LEFT));
                        actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                    }
                } else {
                    actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(ActionDescriptions.PLACE_STACK, Action.Side.LEFT));
                    actionMap.put(ButtonBindings.SPLIT_STACK, new Action(ActionDescriptions.PLACE_ITEM, Action.Side.LEFT));
                    if (containerScreen.getSlotUnderMouse() != null && (slot = containerScreen.getSlotUnderMouse()).m_6657_()) {
                        actionMap.put(ButtonBindings.QUICK_MOVE, new Action(ActionDescriptions.QUICK_MOVE, Action.Side.LEFT));
                    }
                }
                actionMap.put(ButtonBindings.CLOSE_INVENTORY, new Action(ActionDescriptions.CLOSE_INVENTORY, Action.Side.RIGHT));
            } else if (mc.f_91080_ == null) {
                if (RadialMenuHandler.instance().isVisible()) {
                    if (RadialMenuHandler.instance().getSelected() != null) {
                        actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.PERFORM_ACTION, Action.Side.RIGHT));
                    } else {
                        actionMap.put(ButtonBindings.RADIAL_MENU, new Action(ActionDescriptions.CLOSE_MENU, Action.Side.RIGHT));
                    }
                } else {
                    ItemStack currentItem;
                    ItemStack offHandStack;
                    boolean blockHit = mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                    boolean canOpenBlock = false;
                    if (blockHit) {
                        BlockHitResult blockHitResult = (BlockHitResult)mc.f_91077_;
                        canOpenBlock = mc.f_91073_.m_8055_(blockHitResult.m_82425_()).m_60734_() instanceof BaseEntityBlock;
                    }
                    if (!mc.f_91074_.m_6117_()) {
                        if (blockHit) {
                            actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.BREAK, Action.Side.RIGHT));
                        } else {
                            actionMap.put(ButtonBindings.ATTACK, new Action(ActionDescriptions.ATTACK, Action.Side.RIGHT));
                        }
                    }
                    if ((offHandStack = mc.f_91074_.m_21206_()).m_41780_() != UseAnim.NONE) {
                        switch (offHandStack.m_41780_()) {
                            case EAT: {
                                if (!mc.f_91074_.m_36324_().m_38721_()) break;
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                                break;
                            }
                            case DRINK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                                break;
                            }
                            case BLOCK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                                break;
                            }
                            case BOW: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                            }
                        }
                    }
                    if ((currentItem = mc.f_91074_.f_36096_.m_142621_()).m_41780_() != UseAnim.NONE) {
                        switch (currentItem.m_41780_()) {
                            case EAT: {
                                if (!mc.f_91074_.m_36324_().m_38721_()) break;
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.EAT, Action.Side.RIGHT));
                                break;
                            }
                            case DRINK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.DRINK, Action.Side.RIGHT));
                                break;
                            }
                            case BLOCK: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.BLOCK, Action.Side.RIGHT));
                                break;
                            }
                            case BOW: {
                                actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PULL_BOW, Action.Side.RIGHT));
                            }
                        }
                    } else if (currentItem.m_41720_() instanceof BlockItem) {
                        if (blockHit) {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.PLACE_BLOCK, Action.Side.RIGHT));
                        }
                    } else if (!currentItem.m_41619_() && !mc.f_91074_.m_6117_()) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.USE_ITEM, Action.Side.RIGHT));
                    }
                    if (!mc.f_91074_.m_6047_() && blockHit && canOpenBlock && !mc.f_91074_.m_6117_()) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(ActionDescriptions.INTERACT, Action.Side.RIGHT));
                    }
                    if (verbose) {
                        actionMap.put(ButtonBindings.JUMP, new Action(ActionDescriptions.JUMP, Action.Side.LEFT));
                    }
                    actionMap.put(ButtonBindings.OPEN_INVENTORY, new Action(ActionDescriptions.OPEN_INVENTORY, Action.Side.LEFT));
                    if (!(!verbose || mc.f_91074_.m_21206_().m_41619_() && mc.f_91074_.f_36096_.m_142621_().m_41619_())) {
                        actionMap.put(ButtonBindings.SWAP_HANDS, new Action(ActionDescriptions.SWAP_HANDS, Action.Side.LEFT));
                    }
                    if (mc.f_91074_.m_20159_()) {
                        actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.DISMOUNT, Action.Side.RIGHT));
                    } else if (verbose) {
                        actionMap.put(ButtonBindings.SNEAK, new Action(ActionDescriptions.SNEAK, Action.Side.RIGHT));
                    }
                    if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                        actionMap.put(ButtonBindings.DROP_ITEM, new Action(ActionDescriptions.DROP_ITEM, Action.Side.LEFT));
                    }
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new GatherActionsEvent(actionMap, visibility));
            actionMap.forEach((binding, action) -> this.actions.put(binding.getButton(), (Action)action));
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        if (Controllable.getController() != null) {
            if (Controllable.getInput().getLastUse() > 0) {
                this.renderHints();
                this.renderMiniPlayer();
            }
        } else if (mc.f_91080_ == null && ((Boolean)Config.SERVER.restrictToController.get()).booleanValue()) {
            RenderSystem.m_69465_();
            int width = mc.m_91268_().m_85443_();
            int height = mc.m_91268_().m_85444_();
            Screen.m_93172_((PoseStack)new PoseStack(), (int)0, (int)0, (int)width, (int)height, (int)-1072689136);
            Screen.m_93215_((PoseStack)new PoseStack(), (Font)mc.f_91062_, (Component)Component.m_237115_((String)"controllable.gui.controller_only").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW), (int)(width / 2), (int)(height / 2 - 15), (int)-1);
            Screen.m_93215_((PoseStack)new PoseStack(), (Font)mc.f_91062_, (Component)Component.m_237115_((String)"controllable.gui.plug_in_controller"), (int)(width / 2), (int)(height / 2), (int)-1);
            RenderSystem.m_69482_();
        }
    }

    private void renderHints() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderAvailableActionsEvent())) {
            Minecraft mc = Minecraft.m_91087_();
            Gui guiIngame = mc.f_91065_;
            boolean isChatVisible = mc.f_91080_ == null && guiIngame.m_93076_().f_93761_.stream().anyMatch(chatLine -> guiIngame.m_93079_() - chatLine.f_240350_() < 200);
            int leftIndex = 0;
            int rightIndex = 0;
            for (int button : this.actions.keySet()) {
                int textWidth;
                Action action = this.actions.get(button);
                Action.Side side = action.getSide();
                if (((Boolean)mc.f_91066_.m_231825_().m_231551_()).booleanValue() && mc.f_91080_ == null) {
                    side = Action.Side.LEFT;
                }
                int texU = button * 13;
                int texV = ((ControllerIcons)Config.CLIENT.options.controllerIcons.get()).ordinal() * 13;
                int size = 13;
                int x = side == Action.Side.LEFT ? 5 : mc.m_91268_().m_85445_() - 5 - size;
                int y = mc.m_91268_().m_85446_() + (side == Action.Side.LEFT ? leftIndex : rightIndex) * -15 - size - 5;
                RenderSystem.m_157456_((int)0, (ResourceLocation)CONTROLLER_BUTTONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (isChatVisible && side == Action.Side.LEFT && leftIndex >= 2) continue;
                PoseStack poseStack = new PoseStack();
                Screen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)texU, (float)texV, (int)size, (int)size, (int)256, (int)256);
                if (side == Action.Side.LEFT) {
                    textWidth = mc.f_91062_.m_92852_((FormattedText)action.getDescription());
                    this.drawHintBackground(poseStack, x + 18, y, textWidth, 13);
                    mc.f_91062_.m_92889_(poseStack, action.getDescription(), (float)(x + 18), (float)(y + 3), -1);
                    ++leftIndex;
                    continue;
                }
                textWidth = mc.f_91062_.m_92852_((FormattedText)action.getDescription());
                this.drawHintBackground(poseStack, x - 5 - textWidth, y, textWidth, 13);
                mc.f_91062_.m_92889_(poseStack, action.getDescription(), (float)(x - 5 - textWidth), (float)(y + 3), -1);
                ++rightIndex;
            }
        }
    }

    private void drawHintBackground(PoseStack poseStack, int x, int y, int width, int height) {
        if (!((Boolean)Config.CLIENT.options.hintBackground.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int backgroundColor = mc.f_91066_.m_92170_(0.5f);
        Screen.m_93172_((PoseStack)poseStack, (int)(x - 3 + 1), (int)y, (int)(x + width + 2 - 1), (int)(y + 1), (int)backgroundColor);
        Screen.m_93172_((PoseStack)poseStack, (int)(x - 3), (int)(y + 1), (int)(x + width + 2), (int)(y + height - 1), (int)backgroundColor);
        Screen.m_93172_((PoseStack)poseStack, (int)(x - 3 + 1), (int)(y + height - 1), (int)(x + width + 2 - 1), (int)(y + height), (int)backgroundColor);
    }

    private void renderMiniPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91080_ == null && ((Boolean)Config.CLIENT.options.renderMiniPlayer.get()).booleanValue() && !MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerPreviewEvent())) {
            InventoryScreen.m_98850_((int)20, (int)45, (int)20, (float)0.0f, (float)0.0f, (LivingEntity)mc.f_91074_);
        }
    }
}

