/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ControllerManager;
import com.mrcrayfish.controllable.client.gui.screens.ControllerSelectionScreen;
import com.mrcrayfish.controllable.client.gui.widget.ControllerButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ScreenEvents {
    private static final List<IGuiOverlay> INCLUDED_OVERLAYS;
    private ControllerManager manager;

    public ScreenEvents(ControllerManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onOpenGui(ScreenEvent.Init.Post event) {
        ButtonBinding.resetButtonStates();
        if (event.getScreen() instanceof OptionsScreen) {
            int y = event.getScreen().f_96544_ / 6 + 72 - 6;
            event.addListener((GuiEventListener)new ControllerButton(event.getScreen().f_96543_ / 2 + 5 + 150 + 4, y, button -> Minecraft.m_91087_().m_91152_((Screen)new ControllerSelectionScreen(this.manager, event.getScreen()))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (((Boolean)Config.CLIENT.options.consoleHotbar.get()).booleanValue() && INCLUDED_OVERLAYS.contains(event.getOverlay().overlay())) {
            event.getPoseStack().m_85837_(0.0, -20.0, 0.0);
            if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
                RenderSystem.m_157191_().m_85837_(0.0, -20.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (((Boolean)Config.CLIENT.options.consoleHotbar.get()).booleanValue() && INCLUDED_OVERLAYS.contains(event.getOverlay().overlay())) {
            event.getPoseStack().m_85837_(0.0, 20.0, 0.0);
            if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
                RenderSystem.m_157191_().m_85837_(0.0, 20.0, 0.0);
                RenderSystem.m_157182_();
            }
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)VanillaGuiOverlay.HOTBAR.type().overlay());
        builder.add((Object)VanillaGuiOverlay.PLAYER_HEALTH.type().overlay());
        builder.add((Object)VanillaGuiOverlay.MOUNT_HEALTH.type().overlay());
        builder.add((Object)VanillaGuiOverlay.ARMOR_LEVEL.type().overlay());
        builder.add((Object)VanillaGuiOverlay.EXPERIENCE_BAR.type().overlay());
        builder.add((Object)VanillaGuiOverlay.FOOD_LEVEL.type().overlay());
        builder.add((Object)VanillaGuiOverlay.AIR_LEVEL.type().overlay());
        builder.add((Object)VanillaGuiOverlay.CHAT_PANEL.type().overlay());
        builder.add((Object)VanillaGuiOverlay.RECORD_OVERLAY.type().overlay());
        builder.add((Object)VanillaGuiOverlay.ITEM_NAME.type().overlay());
        builder.add((Object)VanillaGuiOverlay.JUMP_BAR.type().overlay());
        INCLUDED_OVERLAYS = builder.build();
    }
}

