/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.navigation;

import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.util.ReflectUtil;
import java.lang.reflect.Field;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ListWidgetNavigationPoint
extends NavigationPoint {
    private final AbstractWidget widget;
    private final AbstractSelectionList<?> list;
    private final AbstractSelectionList.Entry<?> entry;

    public ListWidgetNavigationPoint(AbstractWidget widget, AbstractSelectionList<?> list, AbstractSelectionList.Entry<?> entry) {
        super(0.0, 0.0, NavigationPoint.Type.WIDGET);
        this.widget = widget;
        this.list = list;
        this.entry = entry;
    }

    @Override
    public double distanceTo(double x, double y) {
        return Math.sqrt(Math.pow(this.getX() - x, 2.0) + Math.pow(this.getY() - y, 2.0));
    }

    @Override
    public double getX() {
        return this.widget.f_93620_ + this.widget.m_5711_() / 2;
    }

    @Override
    public double getY() {
        return this.widget.f_93621_ + this.widget.m_93694_() / 2;
    }

    @Override
    public void onNavigate() {
        double scroll;
        int itemHeight = ReflectUtil.getListItemHeight(this.list);
        int y1 = ListWidgetNavigationPoint.getListY1(this.list);
        int y0 = ListWidgetNavigationPoint.getListY0(this.list);
        int index = this.list.m_6702_().indexOf(this.entry);
        int rowTop = ReflectUtil.getAbstractListRowTop(this.list, index);
        int rowBottom = ReflectUtil.getAbstractListRowBottom(this.list, index);
        if (rowTop < this.list.getTop()) {
            scroll = this.list.m_6702_().indexOf(this.entry) * itemHeight - itemHeight / 2;
            this.list.m_93410_(scroll);
        }
        if (rowBottom > this.list.getBottom()) {
            scroll = this.list.m_6702_().indexOf(this.entry) * itemHeight + itemHeight - (y1 - y0) + 4 + itemHeight / 2;
            this.list.m_93410_(scroll);
        }
    }

    public static int getListY0(AbstractSelectionList<?> list) {
        try {
            Field field = ObfuscationReflectionHelper.findField(AbstractSelectionList.class, (String)"f_93390_");
            field.setAccessible(true);
            return (Integer)field.get(list);
        }
        catch (IllegalAccessException e) {
            return 0;
        }
    }

    public static int getListY1(AbstractSelectionList<?> list) {
        try {
            Field field = ObfuscationReflectionHelper.findField(AbstractSelectionList.class, (String)"f_93391_");
            field.setAccessible(true);
            return (Integer)field.get(list);
        }
        catch (IllegalAccessException e) {
            return 0;
        }
    }
}

