/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class ButtonBindingListMenuScreen
extends ListMenuScreen {
    protected Map<String, List<ButtonBinding>> categories = new LinkedHashMap<String, List<ButtonBinding>>();

    protected ButtonBindingListMenuScreen(Screen parent, Component title, int itemHeight) {
        super(parent, title, itemHeight);
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
        this.categories.put("key.categories.controllable_custom", new ArrayList());
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void updateList(List<ListMenuScreen.Item> entries, boolean showUnbound) {
        this.categories.forEach((category, list) -> list.clear());
        BindingRegistry.getInstance().getBindings().stream().filter(ButtonBinding::isNotReserved).forEach(binding -> {
            if (showUnbound && binding.getButton() != -1) {
                return;
            }
            List list = this.categories.computeIfAbsent(binding.getCategory(), category -> new ArrayList());
            list.add(binding);
        });
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                entries.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (Component)Component.m_237115_((String)category).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                list.forEach(binding -> entries.add(this.createItemFromBinding((ButtonBinding)binding)));
            }
        });
    }

    protected abstract ListMenuScreen.Item createItemFromBinding(ButtonBinding var1);
}

