/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.gui.screens.ButtonBindingListMenuScreen;
import com.mrcrayfish.controllable.client.gui.screens.ConfirmationScreen;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.screens.SelectKeyBindingScreen;
import com.mrcrayfish.controllable.client.gui.widget.ButtonBindingButton;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ButtonBindingScreen
extends ButtonBindingListMenuScreen {
    private Button buttonReset;
    private ButtonBinding selectedBinding = null;

    protected ButtonBindingScreen(Screen parentScreen) {
        super(parentScreen, (Component)Component.m_237115_((String)"controllable.gui.title.button_binding"), 22);
    }

    void setSelectedBinding(ButtonBinding selectedBinding) {
        this.selectedBinding = selectedBinding;
    }

    boolean isWaitingForButtonInput() {
        return this.selectedBinding != null;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.buttonReset = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 32, 100, 20, (Component)Component.m_237115_((String)"controllable.gui.resetBinds"), button -> this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, (Component)Component.m_237115_((String)"controllable.gui.restore_default_buttons"), result -> {
            if (result.booleanValue()) {
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.getBindings().forEach(ButtonBinding::reset);
                registry.resetBindingHash();
                registry.save();
            }
            return true;
        }))));
        this.buttonReset.f_93623_ = BindingRegistry.getInstance().getBindings().stream().noneMatch(ButtonBinding::isDefault);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 32, 100, 20, (Component)Component.m_237115_((String)"controllable.gui.add_key_bind"), button -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new SelectKeyBindingScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 55, this.f_96544_ - 32, 100, 20, CommonComponents.f_130655_, button -> {
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
        }));
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void m_86600_() {
        this.buttonReset.f_93623_ = !BindingRegistry.getInstance().getBindings().stream().allMatch(ButtonBinding::isDefault);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, this.selectedBinding == null ? mouseX : -1, this.selectedBinding == null ? mouseY : -1, partialTicks);
        if (this.selectedBinding != null) {
            RenderSystem.m_69465_();
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            ButtonBindingScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.press_button"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-1);
            RenderSystem.m_69482_();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selectedBinding != null && this.isWaitingForButtonInput()) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (key == 256 && this.selectedBinding != null) {
            this.selectedBinding = null;
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }

    public boolean processButton(int index) {
        if (this.selectedBinding != null) {
            this.selectedBinding.setButton(index);
            this.selectedBinding = null;
            BindingRegistry registry = BindingRegistry.getInstance();
            registry.resetBindingHash();
            registry.save();
            return true;
        }
        return false;
    }

    @Override
    protected ListMenuScreen.Item createItemFromBinding(ButtonBinding binding) {
        return new ButtonBindingItem(binding);
    }

    public class ButtonBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final ButtonBinding binding;
        private final Button bindingButton;
        private final Button deleteButton;
        private final Button removeButton;

        protected ButtonBindingItem(ButtonBinding binding) {
            super((ListMenuScreen)ButtonBindingScreen.this, (Component)Component.m_237115_((String)binding.getLabelKey()));
            this.binding = binding;
            this.bindingButton = new ButtonBindingButton(0, 0, binding, button -> ButtonBindingScreen.this.setSelectedBinding(this.binding));
            this.deleteButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 108, 0, 16, 16, button -> {
                binding.reset();
                BindingRegistry registry = BindingRegistry.getInstance();
                registry.resetBindingHash();
                registry.save();
            });
            this.removeButton = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 0, 0, 16, 16, button -> {
                if (binding instanceof KeyAdapterBinding) {
                    BindingRegistry.getInstance().removeKeyAdapter((KeyAdapterBinding)binding);
                }
                ButtonBindingScreen.this.list.removeEntry(this);
            });
            this.removeButton.f_93624_ = binding instanceof KeyAdapterBinding;
        }

        @Override
        public String getLabel() {
            return this.label.m_6879_().getString();
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.bindingButton, (Object)this.deleteButton);
        }

        public void m_6311_(PoseStack poseStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            int color = this.binding.isConflictingContext() ? ChatFormatting.RED.m_126665_() : ChatFormatting.WHITE.m_126665_();
            ((ButtonBindingScreen)ButtonBindingScreen.this).f_96541_.f_91062_.m_92889_(poseStack, this.label, (float)left, (float)(y + 6), color);
            this.bindingButton.f_93620_ = left + width - 42;
            this.bindingButton.f_93621_ = y;
            this.bindingButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.f_93620_ = left + width - 20;
            this.deleteButton.f_93621_ = y;
            this.deleteButton.f_93623_ = !this.binding.isDefault();
            this.deleteButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 1 && this.bindingButton.m_198029_()) {
                this.binding.setButton(-1);
                this.bindingButton.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, ButtonBindingItem.this.label);
                }
            });
        }
    }
}

