/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.screens.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private Screen parentScreen;
    private LayoutButtonStates states = new LayoutButtonStates();
    private Mappings.Entry entry;
    private Button doneButton;
    private Button resetButton;
    private Button thumbstickButton;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
        Controller controller = Controllable.getController();
        if (controller != null) {
            Mappings.Entry entry = controller.getMapping();
            this.entry = entry != null ? entry.copy() : new Mappings.Entry(controller.getName(), controller.getName(), new HashMap<Integer, Integer>());
        }
    }

    protected void m_7856_() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 32, 100, 20, (Component)Component.m_237115_((String)"controllable.gui.save"), button -> {
            this.updateControllerMapping();
            this.f_96541_.m_91152_(this.parentScreen);
        }));
        this.resetButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 32, 100, 20, (Component)Component.m_237115_((String)"controllable.gui.reset"), button -> {
            this.entry.getReassignments().clear();
            this.entry.setSwitchThumbsticks(false);
            this.entry.setFlipLeftX(false);
            this.entry.setFlipLeftY(false);
            this.entry.setFlipRightX(false);
            this.entry.setFlipRightY(false);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 54, this.f_96544_ - 32, 100, 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> this.f_96541_.m_91152_(this.parentScreen)));
        int width = 190;
        int x = this.f_96543_ / 2 - width / 2;
        int y = this.f_96544_ / 2 - 50 - 35;
        this.thumbstickButton = (Button)this.m_142416_((GuiEventListener)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> this.f_96541_.m_91152_((Screen)new ThumbstickSettingsScreen(this))));
    }

    public void m_86600_() {
        boolean changed = !this.entry.getReassignments().isEmpty();
        changed |= this.entry.isThumbsticksSwitched();
        changed |= this.entry.isFlipLeftX();
        changed |= this.entry.isFlipLeftY();
        changed |= this.entry.isFlipRightX();
        this.resetButton.f_93623_ = changed |= this.entry.isFlipRightY();
        this.validLayout = this.entry.getReassignments().values().stream().noneMatch(b -> b == -1);
        this.doneButton.m_93666_((Component)Component.m_237115_((String)"controllable.gui.save").m_130940_(this.validLayout ? ChatFormatting.WHITE : ChatFormatting.RED));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        ArrayList<Object> components;
        this.m_96626_(0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int width = 190;
        int height = 120;
        int x = this.f_96543_ / 2 - width / 2;
        int y = this.f_96544_ / 2 - 50 - 35;
        ControllerLayoutScreen.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)width, (int)height, (float)50.0f, (float)0.0f, (int)38, (int)24, (int)256, (int)256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(poseStack, x, y, mouseX, mouseY, this.configureButton == controllerButton.getButton()));
        ControllerLayoutScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        this.drawMultiLineCenteredString(poseStack, this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.info").m_130940_(ChatFormatting.GRAY), x + width / 2, y + 135, width + 190, -1);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.m_69465_();
            this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            ControllerLayoutScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"controllable.gui.layout.press_button"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-1);
            RenderSystem.m_69482_();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<Object>();
            components.add(Component.m_237110_((String)"controllable.gui.layout.button", (Object[])new Object[]{Component.m_237115_((String)Buttons.NAMES[button.getButton()]).m_130940_(ChatFormatting.BLUE)}));
            if (button.isMissingMapping()) {
                components.add(Component.m_237115_((String)"controllable.gui.layout.missing_mapping").m_130940_(ChatFormatting.RED));
            } else {
                int remappedButton = button.getButton();
                if (!button.isMissingMapping()) {
                    Map<Integer, Integer> reassignments = this.entry.getReassignments();
                    for (Integer key : reassignments.keySet()) {
                        if (reassignments.get(key) != remappedButton) continue;
                        remappedButton = key;
                        break;
                    }
                }
                components.add(Component.m_237110_((String)"controllable.gui.layout.mapped_to", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(remappedButton)).m_130940_(ChatFormatting.BLUE)}));
            }
            components.add(Component.m_237115_((String)"controllable.gui.layout.remap").m_130940_(ChatFormatting.GRAY));
            this.m_96597_(poseStack, components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.m_198029_()) {
            components = new ArrayList();
            components.add(Component.m_237115_((String)"controllable.gui.layout.warning").m_130940_(ChatFormatting.RED).m_7532_());
            components.addAll(this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"controllable.gui.layout.invalid_layout").m_130940_(ChatFormatting.GRAY), 180));
            this.m_96617_(poseStack, components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.m_198029_()) {
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"controllable.gui.layout.thumbsticks"), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }

    public boolean onButtonInput(int button) {
        if (this.configureButton != -1) {
            Map<Integer, Integer> reassignments = this.entry.getReassignments();
            if (button != this.configureButton) {
                reassignments.putIfAbsent(this.configureButton, -1);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != this.configureButton) continue;
                    reassignments.put(key, -1);
                }
                reassignments.put(button, this.configureButton);
            } else {
                reassignments.remove(button);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != button) continue;
                    reassignments.put(key, -1);
                }
            }
            this.configureButton = -1;
            return true;
        }
        return false;
    }

    private void updateControllerMapping() {
        Controller controller = Controllable.getController();
        if (controller != null) {
            controller.setMapping(this.entry);
            this.entry.save();
        }
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        if (state && this.onButtonInput(index)) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if ((index = this.remap(index)) == -1) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12632_, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12632_, (float)0.9f));
        }
    }

    public int remap(int button) {
        return this.entry.remap(button);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public Map<Integer, Integer> getReassignments() {
        return this.entry.getReassignments();
    }

    public Mappings.Entry getEntry() {
        return this.entry;
    }

    private void drawMultiLineCenteredString(PoseStack matrixStack, Font font, Component component, int x, int y, int width, int color) {
        for (FormattedCharSequence s : font.m_92923_((FormattedText)component, width)) {
            font.m_92877_(matrixStack, s, (float)((double)x - (double)font.m_92724_(s) / 2.0), (float)y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

