/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.client.BindingRegistry;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.KeyAdapterBinding;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class KeyBindingListMenuScreen
extends ListMenuScreen {
    private static final List<KeyMapping> DEFAULT_BINDINGS = (List)Util.m_137537_(() -> {
        Options options = Minecraft.m_91087_().f_91066_;
        ArrayList<KeyMapping> bindings = new ArrayList<KeyMapping>();
        bindings.add(options.f_92096_);
        bindings.add(options.f_92095_);
        bindings.add(options.f_92085_);
        bindings.add(options.f_92086_);
        bindings.add(options.f_92087_);
        bindings.add(options.f_92088_);
        bindings.add(options.f_92089_);
        bindings.add(options.f_92090_);
        bindings.add(options.f_92091_);
        bindings.add(options.f_92094_);
        bindings.add(options.f_92092_);
        bindings.add(options.f_92098_);
        bindings.add(options.f_92099_);
        bindings.add(options.f_92097_);
        bindings.add(options.f_92100_);
        bindings.add(options.f_92102_);
        bindings.add(options.f_92103_);
        bindings.add(options.f_92104_);
        bindings.add(options.f_92105_);
        bindings.add(options.f_92054_);
        bindings.add(options.f_92093_);
        bindings.add(options.f_92057_);
        bindings.add(options.f_92058_);
        bindings.add(options.f_92055_);
        bindings.addAll(Arrays.asList(options.f_92056_));
        return ImmutableList.copyOf(bindings);
    });
    private Map<String, List<KeyMapping>> categories = new LinkedHashMap<String, List<KeyMapping>>();

    protected KeyBindingListMenuScreen(Screen parent, Component title, int itemHeight) {
        super(parent, title, itemHeight);
        this.categories.put("key.categories.movement", new ArrayList());
        this.categories.put("key.categories.gameplay", new ArrayList());
        this.categories.put("key.categories.inventory", new ArrayList());
        this.categories.put("key.categories.creative", new ArrayList());
        this.categories.put("key.categories.multiplayer", new ArrayList());
        this.categories.put("key.categories.ui", new ArrayList());
        this.categories.put("key.categories.misc", new ArrayList());
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        this.updateList(entries, false);
    }

    public void updateList(List<ListMenuScreen.Item> entries, boolean showUnbound) {
        this.categories.forEach((category, list) -> list.clear());
        Stream.of(this.f_96541_.f_91066_.f_92059_).filter(binding -> !DEFAULT_BINDINGS.contains(binding)).forEach(binding -> this.categories.computeIfAbsent(binding.m_90858_(), category -> new ArrayList()).add(binding));
        this.categories.forEach((category, list) -> {
            if (!list.isEmpty()) {
                Collections.sort(list);
                entries.add(new ListMenuScreen.TitleItem((ListMenuScreen)this, (Component)Component.m_237115_((String)category).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
                list.forEach(binding -> entries.add(new KeyBindingItem((KeyMapping)binding)));
            }
        });
    }

    protected void onChange() {
    }

    public class KeyBindingItem
    extends ListMenuScreen.Item
    implements ISearchable {
        private final KeyMapping mapping;
        private Button addBinding;
        private Button removeBinding;

        protected KeyBindingItem(KeyMapping mapping) {
            super((ListMenuScreen)KeyBindingListMenuScreen.this, (Component)Component.m_237115_((String)mapping.m_90860_()));
            this.mapping = mapping;
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 88, 25, 10, 10, button -> {
                BindingRegistry.getInstance().addKeyAdapter(new KeyAdapterBinding(-1, this.mapping));
                this.addBinding.f_93623_ = false;
                this.removeBinding.f_93623_ = true;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.removeBinding = new ImageButton(0, 0, 20, ControllerLayoutScreen.TEXTURE, 98, 15, 10, 10, button -> {
                KeyAdapterBinding keyAdapter = BindingRegistry.getInstance().getKeyAdapterByDescriptionKey(this.mapping.m_90860_() + ".custom");
                if (keyAdapter != null) {
                    BindingRegistry.getInstance().removeKeyAdapter(keyAdapter);
                    RadialMenuHandler.instance().removeBinding(keyAdapter);
                }
                this.addBinding.f_93623_ = true;
                this.removeBinding.f_93623_ = false;
                KeyBindingListMenuScreen.this.onChange();
            });
            this.addBinding.f_93623_ = bindings.stream().noneMatch(entry -> entry.getKeyMapping() == this.mapping);
            this.removeBinding.f_93623_ = bindings.stream().anyMatch(entry -> entry.getKeyMapping() == this.mapping);
        }

        @Override
        public String getLabel() {
            return this.label.m_6879_().getString();
        }

        public void updateButtons() {
            Collection<KeyAdapterBinding> bindings = BindingRegistry.getInstance().getKeyAdapters().values();
            this.addBinding.f_93623_ = bindings.stream().noneMatch(entry -> entry.getKeyMapping() == this.mapping);
            this.removeBinding.f_93623_ = bindings.stream().anyMatch(entry -> entry.getKeyMapping() == this.mapping);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.addBinding, (Object)this.removeBinding);
        }

        public void m_6311_(PoseStack matrixStack, int x, int y, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            ((KeyBindingListMenuScreen)KeyBindingListMenuScreen.this).f_96541_.f_91062_.m_92889_(matrixStack, this.label, (float)left, (float)(y + 6), 0xFFFFFF);
            this.addBinding.f_93620_ = left + width - 42;
            this.addBinding.f_93621_ = y;
            this.addBinding.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.removeBinding.f_93620_ = left + width - 20;
            this.removeBinding.f_93621_ = y;
            this.removeBinding.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, KeyBindingItem.this.label);
                }
            });
        }
    }
}

