/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.client.ISearchable;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class ListMenuScreen
extends Screen {
    protected final Screen parent;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected List<FormattedCharSequence> activeTooltip;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;
    protected Component subTitle;
    protected boolean searchBarVisible = true;
    protected int rowWidth = 240;

    protected ListMenuScreen(Screen parent, Component title, int itemHeight) {
        super(title);
        this.parent = parent;
        this.itemHeight = itemHeight;
    }

    public void setSubTitle(Component subTitle) {
        this.subTitle = subTitle;
    }

    public void setSearchBarVisible(boolean visible) {
        this.searchBarVisible = visible;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
    }

    protected void m_7856_() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries, this.calculateTop());
        this.list.m_93488_(!ClientHelper.isPlayingGame());
        this.m_7787_((GuiEventListener)this.list);
        this.searchTextField = new FocusedEditBox(this.f_96547_, this.f_96543_ / 2 - 110, this.calculateSearchBarY(), 220, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchTextField.m_94151_(s -> {
            this.updateSearchTextFieldSuggestion((String)s);
            this.list.m_5988_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(item -> {
                ISearchable searchable;
                return item instanceof ISearchable && (searchable = (ISearchable)((Object)item)).getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH));
            }).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.m_93410_(0.0);
            }
        });
        this.m_7787_((GuiEventListener)this.searchTextField);
        this.searchTextField.f_93624_ = this.searchBarVisible;
        this.updateSearchTextFieldSuggestion("");
    }

    private int calculateTop() {
        int top = 30;
        if (this.searchBarVisible) {
            top += 20;
        }
        if (this.subTitle != null) {
            top += 14;
        }
        return top;
    }

    private int calculateSearchBarY() {
        return this.subTitle != null ? 36 : 22;
    }

    protected abstract void constructEntries(List<Item> var1);

    public void setActiveTooltip(List<FormattedCharSequence> tooltip) {
        this.activeTooltip = tooltip;
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configured.gui.info"), 200));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int titleY = 7 + (!this.searchBarVisible && this.subTitle == null ? 5 : 0);
        ListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)titleY, (int)0xFFFFFF);
        if (this.subTitle != null) {
            ListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.subTitle, (int)(this.f_96543_ / 2), (int)21, (int)0xFFFFFF);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.updateTooltip(mouseX, mouseY);
        if (this.activeTooltip != null) {
            this.m_96617_(poseStack, this.activeTooltip, mouseX, mouseY);
        } else {
            for (GuiEventListener widget : this.m_6702_()) {
                if (!(widget instanceof Button) || !((Button)widget).m_198029_()) continue;
                ((Button)widget).m_7428_(poseStack, mouseX, mouseY);
                break;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.m_5561_(style);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void updateSearchTextFieldSuggestion(String value) {
        if (!value.isEmpty()) {
            Optional<ISearchable> optional = this.entries.stream().filter(item -> item instanceof ISearchable).map(item -> (ISearchable)((Object)item)).filter(info -> info.getLabel().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(ISearchable::getLabel));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getLabel();
                this.searchTextField.m_94167_(displayName.substring(length));
            } else {
                this.searchTextField.m_94167_("");
            }
        } else {
            this.searchTextField.m_94167_(Component.m_237115_((String)"controllable.gui.search").getString());
        }
    }

    protected class EntryList
    extends ContainerObjectSelectionList<Item> {
        public EntryList(List<Item> entries, int top) {
            super(ListMenuScreen.this.f_96541_, ListMenuScreen.this.f_96543_, ListMenuScreen.this.f_96544_, top, ListMenuScreen.this.f_96544_ - 44, ListMenuScreen.this.itemHeight);
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + ListMenuScreen.this.rowWidth / 2 + 10;
        }

        public int m_5759_() {
            return ListMenuScreen.this.rowWidth;
        }

        public void m_5988_(Collection<Item> entries) {
            super.m_5988_(entries);
        }

        public boolean removeEntry(Item item) {
            return super.m_93502_((AbstractSelectionList.Entry)item);
        }

        @Nullable
        public Item getHovered() {
            return (Item)super.m_168795_();
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.renderToolTips(poseStack, mouseX, mouseY);
        }

        private void renderToolTips(PoseStack poseStack, int mouseX, int mouseY) {
            Item item2;
            if (this.m_5953_(mouseX, mouseY) && mouseX < ListMenuScreen.this.list.m_5747_() + ListMenuScreen.this.list.m_5759_() - 67 && (item2 = (Item)this.m_93412_(mouseX, mouseY)) != null) {
                ListMenuScreen.this.setActiveTooltip(item2.tooltip);
            }
            this.m_6702_().forEach(item -> item.m_6702_().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).m_7428_(poseStack, mouseX, mouseY);
                }
            }));
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            boolean wasDragging = this.m_7282_();
            this.m_7897_(false);
            if (wasDragging && this.m_7222_() != null) {
                return ((Item)this.m_7222_()).m_6348_(mouseX, mouseY, button);
            }
            return false;
        }
    }

    protected class FocusedEditBox
    extends EditBox {
        public FocusedEditBox(Font font, int x, int y, int width, int height, Component label) {
            super(font, x, y, width, height, label);
        }

        protected void m_7207_(boolean focused) {
            super.m_7207_(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.m_93692_(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }
    }

    public class TitleItem
    extends Item {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW));
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }

    protected abstract class Item
    extends ContainerObjectSelectionList.Entry<Item> {
        protected final Component label;
        protected List<FormattedCharSequence> tooltip;

        public Item(Component label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = Component.m_237113_((String)label);
        }

        public void setTooltip(Component text, int maxWidth) {
            this.tooltip = ((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)text, maxWidth);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, Item.this.label);
                }
            });
        }
    }
}

