/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.screens.ListMenuScreen;
import com.mrcrayfish.controllable.client.settings.ControllerOptions;
import com.mrcrayfish.controllable.client.settings.ControllerSetting;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class SettingsScreen
extends ListMenuScreen {
    private List<FormattedCharSequence> hoveredTooltip;
    private int hoveredCounter;

    protected SettingsScreen(Screen parent) {
        super(parent, (Component)Component.m_237115_((String)"controllable.gui.title.settings"), 24);
        this.setSearchBarVisible(false);
        this.setRowWidth(310);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 32, 200, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"controllable.gui.title.general").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        entries.add(new WidgetRow(ControllerOptions.MOUSE_SPEED, ControllerOptions.LIST_SCROLL_SPEED));
        entries.add(new WidgetRow(ControllerOptions.DEAD_ZONE, ControllerOptions.HOVER_MODIFIER));
        entries.add(new WidgetRow(ControllerOptions.RADIAL_THUMBSTICK, ControllerOptions.CURSOR_THUMBSTICK));
        entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"controllable.gui.title.gameplay").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        entries.add(new WidgetRow(ControllerOptions.ROTATION_SPEED));
        entries.add(new WidgetRow(ControllerOptions.PITCH_SENSITIVITY, ControllerOptions.YAW_SENSITIVITY));
        entries.add(new WidgetRow(ControllerOptions.INVERT_LOOK, ControllerOptions.INVERT_ROTATION));
        entries.add(new WidgetRow(ControllerOptions.QUICK_CRAFT, ControllerOptions.SNEAK_MODE));
        entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"controllable.gui.title.display").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        entries.add(new WidgetRow(ControllerOptions.RENDER_MINI_PLAYER, ControllerOptions.CONSOLE_HOTBAR));
        entries.add(new WidgetRow(ControllerOptions.CONTROLLER_ICONS, ControllerOptions.SHOW_ACTIONS));
        entries.add(new WidgetRow(ControllerOptions.CURSOR_TYPE, ControllerOptions.HINT_BACKGROUND));
        entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"controllable.gui.title.sounds").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        entries.add(new WidgetRow(ControllerOptions.UI_SOUNDS));
        entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"controllable.gui.title.advanced").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
        entries.add(new WidgetRow(ControllerOptions.VIRTUAL_MOUSE, ControllerOptions.AUTO_SELECT));
        entries.add(new WidgetRow(ControllerOptions.FPS_POLLING_FIX, null));
    }

    public void m_7379_() {
        Config.save();
    }

    public void m_86600_() {
        if (this.hoveredTooltip != null) {
            if (this.hoveredCounter < 20) {
                ++this.hoveredCounter;
            }
        } else {
            this.hoveredCounter = 0;
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        List<FormattedCharSequence> tooltip = this.getHoveredToolTip(mouseX, mouseY);
        if (this.hoveredTooltip != tooltip || Controllable.isButtonPressed(0)) {
            this.hoveredCounter = 0;
        }
        this.hoveredTooltip = tooltip;
        if (this.hoveredTooltip != null && this.hoveredCounter >= 10) {
            this.m_96617_(poseStack, this.hoveredTooltip, mouseX, mouseY);
        }
    }

    @Nullable
    private List<FormattedCharSequence> getHoveredToolTip(int mouseX, int mouseY) {
        ListMenuScreen.Item item = this.list.getHovered();
        if (item instanceof WidgetRow) {
            WidgetRow item2 = (WidgetRow)item;
            List<? extends GuiEventListener> listeners = item2.m_6702_();
            for (GuiEventListener guiEventListener : listeners) {
                if (!guiEventListener.m_5953_((double)mouseX, (double)mouseY) || !(guiEventListener instanceof TooltipAccessor)) continue;
                TooltipAccessor accessor = (TooltipAccessor)guiEventListener;
                return accessor.m_141932_();
            }
        }
        return null;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean wasDragging = this.m_7282_();
        this.m_7897_(false);
        if (wasDragging && this.m_7222_() != null) {
            return this.m_7222_().m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public class WidgetRow
    extends ListMenuScreen.Item {
        private final AbstractWidget optionOne;
        private final AbstractWidget optionTwo;

        public WidgetRow(ControllerSetting<?> leftWidget) {
            super(CommonComponents.f_237098_);
            this.optionOne = leftWidget.createWidget(0, 0, 310, 20).get();
            this.optionTwo = null;
        }

        public WidgetRow(@Nullable ControllerSetting<?> leftWidget, ControllerSetting<?> rightWidget) {
            super(CommonComponents.f_237098_);
            this.optionOne = leftWidget.createWidget(0, 0, 150, 20).get();
            this.optionTwo = Optional.ofNullable(rightWidget).map(o -> o.createWidget(0, 0, 150, 20).get()).orElse(null);
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.optionOne.f_93620_ = left;
            this.optionOne.f_93621_ = top;
            this.optionOne.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.optionTwo != null) {
                this.optionTwo.f_93620_ = left + width - 150;
                this.optionTwo.f_93621_ = top;
                this.optionTwo.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return this.optionTwo != null ? ImmutableList.of((Object)this.optionOne, (Object)this.optionTwo) : ImmutableList.of((Object)this.optionOne);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            boolean wasDragging = this.m_7282_();
            this.m_7897_(false);
            if (wasDragging && this.m_7222_() != null) {
                return this.m_7222_().m_6348_(mouseX, mouseY, button);
            }
            return false;
        }
    }
}

