/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ControllerIcons;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.SneakMode;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.settings.ControllerEnumSetting;
import com.mrcrayfish.controllable.client.settings.ControllerSetting;
import com.mrcrayfish.controllable.client.settings.ControllerSliderSetting;
import com.mrcrayfish.controllable.client.settings.ControllerToggleSetting;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ControllerOptions {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.#");
    public static final ControllerSetting<Boolean> AUTO_SELECT = ControllerOptions.createToggleSetting("controllable.options.autoSelect", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.autoSelect);
    public static final ControllerSetting<Boolean> RENDER_MINI_PLAYER = ControllerOptions.createToggleSetting("controllable.options.renderMiniPlayer", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.renderMiniPlayer);
    public static final ControllerSetting<Boolean> VIRTUAL_MOUSE = ControllerOptions.createToggleSetting("controllable.options.virtualMouse", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.virtualMouse);
    public static final ControllerSetting<Boolean> CONSOLE_HOTBAR = ControllerOptions.createToggleSetting("controllable.options.consoleHotbar", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.consoleHotbar);
    public static final ControllerSetting<CursorType> CURSOR_TYPE = ControllerOptions.createValuesSetting("controllable.options.cursorType", CursorType.class, Config.CLIENT.options.cursorType);
    public static final ControllerSetting<ControllerIcons> CONTROLLER_ICONS = ControllerOptions.createValuesSetting("controllable.options.controllerIcons", ControllerIcons.class, Config.CLIENT.options.controllerIcons);
    public static final ControllerSetting<Boolean> INVERT_LOOK = ControllerOptions.createToggleSetting("controllable.options.invertLook", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.invertLook);
    public static final ControllerSetting<Boolean> INVERT_ROTATION = ControllerOptions.createToggleSetting("controllable.options.invertRotation", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.invertRotation);
    public static final ControllerSetting<Double> DEAD_ZONE = ControllerOptions.createSliderSetting("controllable.options.deadZone", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.deadZone, 0.01);
    public static final ControllerSetting<Double> ROTATION_SPEED = ControllerOptions.createSliderSetting("controllable.options.rotationSpeed", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.rotationSpeed, 1.0);
    public static final ControllerSetting<Double> PITCH_SENSITIVITY = ControllerOptions.createSliderSetting("controllable.options.pitchSensitivity", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.pitchSensitivity, 0.01);
    public static final ControllerSetting<Double> YAW_SENSITIVITY = ControllerOptions.createSliderSetting("controllable.options.yawSensitivity", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.yawSensitivity, 0.01);
    public static final ControllerSetting<Double> MOUSE_SPEED = ControllerOptions.createSliderSetting("controllable.options.mouseSpeed", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.mouseSpeed, 1.0);
    public static final ControllerSetting<Boolean> QUICK_CRAFT = ControllerOptions.createToggleSetting("controllable.options.quickCraft", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.quickCraft);
    public static final ControllerSetting<Boolean> UI_SOUNDS = ControllerOptions.createToggleSetting("controllable.options.uiSounds", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.uiSounds);
    public static final ControllerSetting<Double> HOVER_MODIFIER = ControllerOptions.createSliderSetting("controllable.options.hoverModifier", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.hoverModifier, 0.05);
    public static final ControllerSetting<ActionVisibility> SHOW_ACTIONS = ControllerOptions.createValuesSetting("controllable.options.showActions", ActionVisibility.class, Config.CLIENT.options.showActions);
    public static final ControllerSetting<Thumbstick> RADIAL_THUMBSTICK = ControllerOptions.createValuesSetting("controllable.options.radialThumbstick", Thumbstick.class, Config.CLIENT.options.radialThumbstick);
    public static final ControllerSetting<SneakMode> SNEAK_MODE = ControllerOptions.createValuesSetting("controllable.options.sneakMode", SneakMode.class, Config.CLIENT.options.sneakMode);
    public static final ControllerSetting<Thumbstick> CURSOR_THUMBSTICK = ControllerOptions.createValuesSetting("controllable.options.cursorThumbstick", Thumbstick.class, Config.CLIENT.options.cursorThumbstick);
    public static final ControllerSetting<Boolean> FPS_POLLING_FIX = ControllerOptions.createToggleSetting("controllable.options.fpsPollingFix", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.fpsPollingFix);
    public static final ControllerSetting<Boolean> HINT_BACKGROUND = ControllerOptions.createToggleSetting("controllable.options.hintBackground", (ForgeConfigSpec.ConfigValue<Boolean>)Config.CLIENT.options.hintBackground);
    public static final ControllerSetting<Double> LIST_SCROLL_SPEED = ControllerOptions.createSliderSetting("controllable.options.listScrollSpeed", (ForgeConfigSpec.ConfigValue<Double>)Config.CLIENT.options.listScrollSpeed, 1.0);

    public static ControllerSetting<Boolean> createToggleSetting(String key, ForgeConfigSpec.ConfigValue<Boolean> configValue) {
        return new ControllerToggleSetting(key, configValue);
    }

    public static <T extends Enum<?>> ControllerSetting<T> createValuesSetting(String key, Class<T> clazz, ForgeConfigSpec.ConfigValue<T> configValue) {
        return new ControllerEnumSetting<T>(key, clazz, configValue);
    }

    public static ControllerSetting<Double> createSliderSetting(String key, ForgeConfigSpec.ConfigValue<Double> configValue, double stepSize) {
        ForgeConfigSpec.ValueSpec spec = ControllerOptions.getValueSpec(configValue);
        if (spec == null) {
            throw new IllegalArgumentException("Invalid config value. Missing value spec");
        }
        Pair<Object, Object> minMax = ControllerOptions.getMinMax(spec.getRange());
        if (minMax == null) {
            throw new IllegalArgumentException("Invalid config value for slider. Can only be of type Double or Integer");
        }
        return new ControllerSliderSetting(key, configValue, (Double)minMax.getLeft(), (Double)minMax.getRight(), stepSize);
    }

    @Nullable
    private static ForgeConfigSpec.ValueSpec getValueSpec(ForgeConfigSpec.ConfigValue<?> value) {
        try {
            Field field = ObfuscationReflectionHelper.findField(ForgeConfigSpec.ConfigValue.class, (String)"spec");
            Object object = field.get(value);
            if (object instanceof ForgeConfigSpec) {
                ForgeConfigSpec configSpec = (ForgeConfigSpec)object;
                return (ForgeConfigSpec.ValueSpec)configSpec.getSpec().get(value.getPath());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static Pair<Object, Object> getMinMax(@Nullable Object range) {
        if (range != null) {
            try {
                Class<?> clazz = Class.forName("net.minecraftforge.common.ForgeConfigSpec$Range");
                Field minField = ObfuscationReflectionHelper.findField(clazz, (String)"min");
                Object min = minField.get(range);
                Field maxField = ObfuscationReflectionHelper.findField(clazz, (String)"max");
                Object max = maxField.get(range);
                return Pair.of((Object)min, (Object)max);
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

