/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractContainerScreen.class})
public abstract class ContainerScreenMixin {
    @Shadow
    private ItemStack f_97724_;
    private Method method;

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V", ordinal=1))
    private void onClicked(AbstractContainerScreen<?> screen, Slot slot, int slotId, int button, ClickType type) {
        if (slotId != -999 && ContainerScreenMixin.canQuickMove()) {
            this.f_97724_ = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
            type = ClickType.QUICK_MOVE;
        }
        this.handleSlotClick(screen, slot, slotId, button, type);
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V", ordinal=9))
    private void onReleased(AbstractContainerScreen<?> screen, Slot slot, int slotId, int button, ClickType type) {
        if (slotId != -999 && ContainerScreenMixin.canQuickMove()) {
            this.f_97724_ = slot != null && slot.m_6657_() ? slot.m_7993_().m_41777_() : ItemStack.f_41583_;
            type = ClickType.QUICK_MOVE;
        }
        this.handleSlotClick(screen, slot, slotId, button, type);
    }

    private void handleSlotClick(AbstractContainerScreen<?> screen, Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (this.method == null) {
            this.method = ObfuscationReflectionHelper.findMethod(AbstractContainerScreen.class, (String)"m_6597_", (Class[])new Class[]{Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class});
        }
        try {
            this.method.invoke(screen, slotIn, slotId, mouseButton, type);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static boolean canQuickMove() {
        Controller controller = Controllable.getController();
        return controller != null && ButtonBindings.QUICK_MOVE.isButtonPressed();
    }
}

