/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    public LocalPlayer f_91074_;

    @ModifyArg(method={"handleKeybinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;continueAttack(Z)V"), index=0)
    private boolean sendClickBlockToController(boolean original) {
        return original || MinecraftMixin.isLeftClicking();
    }

    @Redirect(method={"handleKeybinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z"), to=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;releaseUsingItem(Lnet/minecraft/world/entity/player/Player;)V")))
    private boolean onKeyDown(KeyMapping mapping) {
        return mapping.m_90857_() || MinecraftMixin.isRightClicking();
    }

    private static boolean isRightClicking() {
        Controller controller = Controllable.getController();
        return controller != null && ButtonBindings.USE_ITEM.isButtonDown();
    }

    private static boolean isLeftClicking() {
        Minecraft mc = Minecraft.m_91087_();
        Controller controller = Controllable.getController();
        if (controller != null && ButtonBindings.ATTACK.isButtonDown()) {
            boolean usingVirtualMouse = (Boolean)Config.CLIENT.options.virtualMouse.get() != false && Controllable.getInput().getLastUse() > 0;
            return mc.f_91080_ == null && (mc.f_91067_.m_91600_() || usingVirtualMouse);
        }
        return false;
    }

    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void isEntityGlowing(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_91074_ != null && this.f_91074_.m_5833_() && ButtonBindings.HIGHLIGHT_PLAYERS.isButtonDown() && entity.m_6095_() == EntityType.f_20532_) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isWindowActive"}, at={@At(value="HEAD")}, cancellable=true)
    private void isWindowActiveHead(CallbackInfoReturnable<Boolean> cir) {
        if (Controllable.getController() != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"runTick"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/Minecraft;getFramerateLimit()I"), index=7)
    private int controllableModifyFramerate(int originalFps) {
        Minecraft mc = (Minecraft)this;
        if (mc.m_91265_() == null && ((Boolean)Config.CLIENT.options.fpsPollingFix.get()).booleanValue() && mc.m_91275_() < 40) {
            return 260;
        }
        return originalFps;
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getFramerateLimit()I")})
    private void controllableWaitEvents(boolean outOfMemory, CallbackInfo ci) {
        Minecraft mc = (Minecraft)this;
        if (mc.m_91265_() == null && ((Boolean)Config.CLIENT.options.fpsPollingFix.get()).booleanValue() && mc.m_91275_() < 40) {
            Controllable.queueInputsWait();
        }
    }
}

