/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.entities.DevastatorEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class DevastatorModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "devastator"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private float partialTick;

    public DevastatorModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rotation1 = body.m_171599_("rotation1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-103.8223f, (float)-14.0749f));
        PartDefinition rotation1_r1 = rotation1.m_171599_("rotation1_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-31.0f, -38.0749f, -25.4277f, 57.0f, 53.0f, 64.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)6.5723f, (float)-14.9251f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition neck = rotation1.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.9748f, (float)-41.3215f));
        PartDefinition body5_r1 = neck.m_171599_("body5_r1", CubeListBuilder.m_171558_().m_171514_(198, 73).m_171488_(-22.5f, -16.5f, -22.0f, 45.0f, 33.0f, 44.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-16.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(163, 189).m_171488_(-25.3333f, -38.3739f, -45.0f, 51.0f, 69.0f, 45.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1667f, (float)0.0f, (float)-25.4248f));
        PartDefinition nose_r1 = head.m_171599_("nose_r1", CubeListBuilder.m_171558_().m_171514_(325, 380).m_171488_(-10.0f, -18.25f, -13.0f, 14.0f, 30.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.1667f, (float)30.8761f, (float)-46.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition teeth_head_r1 = head.m_171599_("teeth_head_r1", CubeListBuilder.m_171558_().m_171514_(178, 0).m_171488_(-26.0f, -2.25f, -23.0f, 46.0f, 9.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.6667f, (float)33.8761f, (float)-31.0f, (float)-3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition jawpart = head.m_171599_("jawpart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.6667f, (float)30.8761f, (float)-8.0f));
        PartDefinition teeth_jaw_r1 = jawpart.m_171599_("teeth_jaw_r1", CubeListBuilder.m_171558_().m_171514_(310, 210).m_171488_(-26.0f, -18.4f, -27.0f, 46.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(208, 150).m_171488_(-26.0f, -5.2f, -19.0f, 46.0f, 3.0f, 36.0f, new CubeDeformation(0.0f)).m_171514_(136, 303).m_171488_(-26.0f, -13.3f, -19.0f, 46.0f, 8.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)18.25f, (float)-19.0f, (float)3.1416f, (float)0.0f, (float)-3.1416f));
        PartDefinition illager = head.m_171599_("illager", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.6667f, (float)-38.4025f, (float)-36.1788f));
        PartDefinition head2 = illager.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-24.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head2.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition headwear = head2.m_171599_("headwear", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = illager.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition left_arm = illager.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-22.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.5236f));
        PartDefinition right_arm = illager.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-22.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)-0.5236f));
        PartDefinition left_leg = illager.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = illager.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition arm_left = rotation1.m_171599_("arm_left", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171488_(-3.5f, -3.0f, -4.5f, 7.0f, 21.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)19.0f, (float)32.0723f, (float)-29.4251f));
        PartDefinition arm_right = rotation1.m_171599_("arm_right", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171488_(-3.5f, -3.25f, -4.5f, 7.0f, 21.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-19.0f, (float)32.3223f, (float)-29.4251f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rotation2 = body.m_171599_("rotation2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-104.2721f, (float)-18.9296f));
        PartDefinition rotation2_r1 = rotation2.m_171599_("rotation2_r1", CubeListBuilder.m_171558_().m_171514_(0, 117).m_171488_(-24.5f, -4.9279f, -55.009f, 49.0f, 62.0f, 55.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-27.509f, (float)4.9279f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left1 = rotation2.m_171599_("leg_left1", CubeListBuilder.m_171558_().m_171514_(304, 303).m_171488_(-9.5f, -19.0f, -19.5f, 19.0f, 38.0f, 39.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-33.0f, (float)6.4851f, (float)24.2003f));
        PartDefinition leg1_part1 = leg_left1.m_171599_("leg1_part1", CubeListBuilder.m_171558_().m_171514_(355, 234).m_171488_(-7.5f, 0.0f, 0.0f, 15.0f, 30.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)18.9042f, (float)-6.3459f));
        PartDefinition leg1_part2 = leg1_part1.m_171599_("leg1_part2", CubeListBuilder.m_171558_().m_171514_(208, 347).m_171488_(-7.0f, 0.0f, -20.0f, 14.0f, 38.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.25f, (float)30.003f, (float)21.9447f));
        PartDefinition feet1 = leg1_part2.m_171599_("feet1", CubeListBuilder.m_171558_().m_171514_(338, 155).m_171488_(-9.5f, -9.75f, -26.9332f, 19.0f, 21.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)37.6935f, (float)-10.0f));
        PartDefinition finger1 = feet1.m_171599_("finger1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-9.3443f, (float)4.75f, (float)-26.7637f));
        PartDefinition finger1_r1 = finger1.m_171599_("finger1_r1", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171488_(-4.0f, -6.5f, -9.5f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.25f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)0.48f, (float)0.0f));
        PartDefinition finger2 = feet1.m_171599_("finger2", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171488_(-4.0f, -6.5f, -19.0f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.75f, (float)-26.9332f));
        PartDefinition finger3 = feet1.m_171599_("finger3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)9.2122f, (float)4.75f, (float)-26.7455f));
        PartDefinition finger3_r1 = finger3.m_171599_("finger3_r1", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171480_().m_171488_(-4.0f, -6.5f, -9.5f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.25f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.48f, (float)0.0f));
        PartDefinition rotation_fixer1 = leg1_part1.m_171599_("rotation_fixer1", CubeListBuilder.m_171558_().m_171514_(208, 347).m_171488_(-7.25f, -23.997f, -10.0553f, 14.0f, 38.0f, 20.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)0.0f, (float)36.0f, (float)12.0f));
        PartDefinition leg_left2 = rotation2.m_171599_("leg_left2", CubeListBuilder.m_171558_().m_171514_(304, 303).m_171488_(-9.5f, -19.0f, -19.5f, 19.0f, 38.0f, 39.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)33.0f, (float)6.4851f, (float)24.2003f));
        PartDefinition leg2_part1 = leg_left2.m_171599_("leg2_part1", CubeListBuilder.m_171558_().m_171514_(355, 234).m_171488_(-7.5f, 0.0f, 0.0f, 15.0f, 30.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)18.9042f, (float)-6.3459f));
        PartDefinition leg2_part2 = leg2_part1.m_171599_("leg2_part2", CubeListBuilder.m_171558_().m_171514_(208, 347).m_171488_(-7.0f, 0.0f, -20.0f, 14.0f, 38.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.25f, (float)30.003f, (float)21.9447f));
        PartDefinition feet2 = leg2_part2.m_171599_("feet2", CubeListBuilder.m_171558_().m_171514_(338, 155).m_171488_(-9.5f, -9.75f, -26.9332f, 19.0f, 21.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)37.6935f, (float)-10.0f));
        PartDefinition finger4 = feet2.m_171599_("finger4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-9.3443f, (float)4.75f, (float)-26.7637f));
        PartDefinition finger4_r1 = finger4.m_171599_("finger4_r1", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171488_(-4.0f, -6.5f, -9.5f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.25f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)0.48f, (float)0.0f));
        PartDefinition finger5 = feet2.m_171599_("finger5", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171488_(-4.0f, -6.5f, -19.0f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.75f, (float)-26.9332f));
        PartDefinition finger6 = feet2.m_171599_("finger6", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)9.2122f, (float)4.75f, (float)-26.7455f));
        PartDefinition finger6_r1 = finger6.m_171599_("finger6_r1", CubeListBuilder.m_171558_().m_171514_(267, 305).m_171480_().m_171488_(-4.0f, -6.5f, -9.5f, 8.0f, 13.0f, 19.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.25f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.48f, (float)0.0f));
        PartDefinition rotation_fixer2 = leg2_part1.m_171599_("rotation_fixer2", CubeListBuilder.m_171558_().m_171514_(208, 347).m_171488_(-7.25f, -23.997f, -10.0553f, 14.0f, 38.0f, 20.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)0.0f, (float)36.0f, (float)12.0f));
        PartDefinition tail = rotation2.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)1.0249f, (float)58.8981f));
        PartDefinition tail_r1 = tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(0, 234).m_171488_(-14.5f, -37.0f, 1.0f, 29.0f, 91.0f, 39.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)37.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void animate(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171324_((String)"rotation1").m_171324_((String)"neck").m_171324_((String)"head").f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.m_171324_((String)"rotation1").m_171324_((String)"neck").m_171324_((String)"head").f_104203_ = headPitch * ((float)Math.PI / 180);
        if (entity instanceof DevastatorEntity) {
            float moveZ;
            DevastatorEntity devastator = (DevastatorEntity)entity;
            float moveX = (float)(devastator.m_20185_() - devastator.f_19854_);
            float speed = Mth.m_14116_((float)(moveX * moveX + (moveZ = (float)(devastator.m_20189_() - devastator.f_19856_)) * moveZ));
            if ((double)speed > 0.03) {
                this.animateWalk(devastator.getFrame());
            } else {
                this.body.m_171324_((String)"rotation2").m_171324_((String)"leg_left1").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
                this.body.m_171324_((String)"rotation2").m_171324_((String)"leg_left2").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            }
            if (devastator.m_21224_()) {
                this.animateDeath(devastator.f_20919_);
            }
        }
    }

    public void animateWalk(int fullTick) {
        int actualTick = fullTick % 40;
        float tick = 0.0f;
        tick = (float)actualTick + this.partialTick;
        float f3 = tick / 60.0f;
        ModelPart leg_left1 = this.body.m_171324_("rotation2").m_171324_("leg_left1");
        ModelPart leg_left2 = this.body.m_171324_("rotation2").m_171324_("leg_left2");
        ModelPart leg1_part2 = this.body.m_171324_("rotation2").m_171324_("leg_left1").m_171324_("leg1_part1").m_171324_("leg1_part2");
        ModelPart leg2_part2 = this.body.m_171324_("rotation2").m_171324_("leg_left2").m_171324_("leg2_part1").m_171324_("leg2_part2");
        ModelPart feet1 = this.body.m_171324_("rotation2").m_171324_("leg_left1").m_171324_("leg1_part1").m_171324_("leg1_part2").m_171324_("feet1");
        ModelPart feet2 = this.body.m_171324_("rotation2").m_171324_("leg_left2").m_171324_("leg2_part1").m_171324_("leg2_part2").m_171324_("feet2");
        ModelPart jaw = this.body.m_171324_("rotation1").m_171324_("neck").m_171324_("head").m_171324_("jawpart");
        ModelPart tail = this.body.m_171324_("rotation2").m_171324_("tail");
        float walkMultiplier = 0.76f;
        this.body.f_104201_ = Math.abs(Mth.m_14089_((float)(f3 * 10.0f)) * walkMultiplier * 12.0f) + 24.0f;
        jaw.f_104203_ = Math.abs(Mth.m_14089_((float)(f3 * 10.0f)) * 0.2f);
        leg_left1.f_104203_ = Mth.m_14089_((float)(f3 * 10.0f)) * walkMultiplier;
        leg_left2.f_104203_ = -leg_left1.f_104203_;
        if (leg_left1.f_104203_ > 0.0f) {
            leg_left1.f_104203_ *= 1.5f;
        }
        if (leg_left2.f_104203_ > 0.0f) {
            leg_left2.f_104203_ *= 1.5f;
        }
        leg1_part2.f_104203_ = -Math.min(leg_left1.f_104203_, 0.0f) * 2.0f;
        leg2_part2.f_104203_ = -Math.min(leg_left2.f_104203_, 0.0f) * 2.0f;
        feet1.f_104203_ = Math.min(leg_left1.f_104203_, 0.0f);
        feet2.f_104203_ = Math.min(leg_left2.f_104203_, 0.0f);
        tail.f_104204_ = Mth.m_14089_((float)(f3 * 10.0f)) * 0.6f;
    }

    public void animateDeath(int fullTick) {
        float tick = 0.0f;
        tick = (float)fullTick + this.partialTick;
        float f3 = tick / 60.0f;
        float stopped1 = 0.0f;
        float tick2 = 0.0f;
        float f3_2 = 0.0f;
        float tickk = 0.0f;
        tickk = (float)(fullTick - 6) + this.partialTick;
        float f4 = (float)((double)Mth.m_14036_((float)tick, (float)0.0f, (float)4.0f) * (Math.PI / 180)) * 2.0f;
        float f5 = (float)((double)Mth.m_14036_((float)tickk, (float)0.0f, (float)4.0f) * (Math.PI / 180)) * 2.0f;
        ModelPart rotation1 = this.body.m_171324_("rotation1");
        ModelPart head = this.body.m_171324_("rotation1").m_171324_("neck").m_171324_("head");
        ModelPart jaw = this.body.m_171324_("rotation1").m_171324_("neck").m_171324_("head").m_171324_("jawpart");
        ModelPart tail = this.body.m_171324_("rotation2").m_171324_("tail");
        if (fullTick < 6) {
            rotation1.f_104203_ = f4;
            head.f_104203_ = f4 * 2.0f;
            tail.f_104203_ = -f4;
        } else if (fullTick <= 10) {
            rotation1.f_104203_ = f4 - f5 - f5 * 2.0f;
            head.f_104203_ = f4 * 2.0f - f5 * 2.0f - f5 * 2.0f;
            jaw.f_104203_ = Math.min(1.5707f, 1.5707f / f4 * f5);
            tail.f_104203_ = -f4 - f5 - f5 * 2.0f;
        } else if (fullTick <= 80) {
            tickk = (float)(fullTick - 10) + this.partialTick;
            float f6 = (float)((double)Mth.m_14036_((float)tickk, (float)0.0f, (float)4.0f) * (Math.PI / 180)) * 2.0f;
            tick = (float)(fullTick - 10) + this.partialTick;
            f3 = tick / 60.0f;
            tick2 = (float)(fullTick - 15) + this.partialTick;
            f3_2 = tick2 / 60.0f;
            rotation1.f_104203_ = -f5 * 2.0f;
            head.f_104203_ = -f5 * 2.0f;
            jaw.f_104203_ = 1.5707f;
            tail.f_104203_ = -f5 * 2.0f;
            rotation1.f_104204_ = Mth.m_14031_((float)(f3 * 20.0f)) * 0.3f / f4 * f6;
            rotation1.f_104205_ = Mth.m_14031_((float)(f3 * 20.0f)) * 0.3f / f4 * f6;
            head.f_104204_ = Mth.m_14031_((float)(f3_2 * 20.0f)) * 0.3f / f4 * f6;
            head.f_104205_ = Mth.m_14031_((float)(f3_2 * 20.0f)) * 0.3f / f4 * f6;
        } else if (fullTick <= 120) {
            tickk = (float)(fullTick - 80) + this.partialTick;
            float f6 = Mth.m_14036_((float)tickk, (float)0.0f, (float)40.0f);
            tick = (float)(fullTick - 10) + this.partialTick;
            f3 = tick / 60.0f;
            tick2 = (float)(fullTick - 15) + this.partialTick;
            f3_2 = tick2 / 60.0f;
            float multiplier = Math.max(1.0f - f6 / 40.0f, 0.0f);
            rotation1.f_104203_ = -f5 * 2.0f;
            head.f_104203_ = -f5 * 2.0f;
            jaw.f_104203_ = 1.5707f * multiplier;
            tail.f_104203_ = -f5 * 2.0f;
            rotation1.f_104204_ = Mth.m_14031_((float)(f3 * 20.0f)) * 0.3f * multiplier;
            rotation1.f_104205_ = Mth.m_14031_((float)(f3 * 20.0f)) * 0.3f * multiplier;
            head.f_104204_ = Mth.m_14031_((float)(f3_2 * 20.0f)) * 0.3f * multiplier;
            head.f_104205_ = Mth.m_14031_((float)(f3_2 * 20.0f)) * 0.3f * multiplier;
        } else {
            tickk = (float)(fullTick - 10) + this.partialTick;
            float f6 = (float)((double)Mth.m_14036_((float)tickk, (float)0.0f, (float)4.0f) * (Math.PI / 180));
            tick = (float)(fullTick - 10) + this.partialTick;
            f3 = tick / 60.0f;
            tick2 = (float)(fullTick - 15) + this.partialTick;
            f3_2 = tick2 / 60.0f;
            rotation1.f_104203_ = -f5 * 2.0f;
            head.f_104203_ = -f5 * 2.0f;
            tail.f_104203_ = -f5 * 2.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6839_(T p_102614_, float p_102615_, float p_102616_, float p_102617_) {
        this.partialTick = p_102617_;
    }
}

