/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.entities.ImpEntity;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ImpModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "imp"), "main");
    private final ModelPart body;
    private final ModelPart block;
    private final Random random = new Random();

    public ImpModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.block = root.m_171324_("block");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition horns = head.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(28, 42).m_171488_(-10.0f, -6.0f, 0.0f, 18.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-7.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition pitchfork = right_arm.m_171599_("pitchfork", CubeListBuilder.m_171558_().m_171514_(42, 0).m_171488_(-0.5f, -15.0f, -0.5f, 1.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 0).m_171488_(-2.5f, -16.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 2).m_171488_(1.5f, -20.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(50, 2).m_171488_(-0.5f, -21.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 2).m_171488_(-2.5f, -20.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)8.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition right_leg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition wing1 = body.m_171599_("wing1", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171480_().m_171488_(0.0f, -16.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)6.0f, (float)3.0f));
        PartDefinition wing2 = body.m_171599_("wing2", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-16.0f, -16.0f, 0.0f, 16.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)6.0f, (float)3.0f));
        PartDefinition tail1 = body.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171488_(-0.5f, -8.0f, 0.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)3.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171488_(-0.5f, -8.0f, 0.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)-0.5236f));
        PartDefinition tail3 = tail2.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171488_(-0.5f, -8.0f, 0.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)-0.4363f));
        PartDefinition tail4 = tail3.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(34, 9).m_171488_(-2.0f, -6.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition block = partdefinition.m_171599_("block", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)32.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f3 = ageInTicks / 60.0f;
        this.body.m_171324_((String)"head").f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.m_171324_((String)"head").f_104203_ = headPitch * ((float)Math.PI / 180);
        this.block.f_104200_ = -0.5f + this.random.nextFloat();
        this.block.f_104202_ = -0.5f + this.random.nextFloat();
        if (entity instanceof ImpEntity) {
            ImpEntity imp = (ImpEntity)entity;
            if (imp.getStage() == 1) {
                this.body.f_104207_ = false;
                this.block.f_104207_ = true;
            } else {
                this.body.f_104207_ = true;
                this.block.f_104207_ = false;
            }
            if (imp.getStage() == 3) {
                this.body.m_171324_((String)"left_arm").f_104203_ = -2.0944f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -1.7453f;
                this.body.m_171324_((String)"head").f_104201_ = Mth.m_14031_((float)(f3 * 40.0f)) * 0.5f;
            } else {
                this.body.m_171324_((String)"left_arm").f_104203_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -0.6109f;
                this.body.m_171324_((String)"head").f_104201_ = 0.0f;
            }
            this.body.f_104204_ = imp.getStage() == 2 ? ageInTicks * 25.0f * ((float)Math.PI / 180) : 0.0f;
            this.body.f_104203_ = imp.getStage() == 4 ? 3.14159f : 0.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.block.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

