/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.yellowbrossproductions.illageandspillage.entities.projectile.MagiFireballEntity;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class MagiFireballRenderer
extends EntityRenderer<MagiFireballEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/magispeller/magi_fireball.png");
    private static final float TEXTURE_WIDTH = 16.0f;
    private static final float TEXTURE_HEIGHT = 16.0f;
    private static final float START_RADIUS = 0.75f;
    private final Random random = new Random();

    public MagiFireballRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public Vec3 getRenderOffset(MagiFireballEntity p_114483_, float p_114484_) {
        return new Vec3(this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
    }

    public void render(MagiFireballEntity ball, float entityYaw, float delta, PoseStack poseStack, MultiBufferSource p_114489_, int light) {
        float f = (float)ball.f_19797_ / 35.0f;
        float f1 = Math.min(f, 1.0f);
        VertexConsumer ivertexbuilder = p_114489_.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(ball)));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.2, 0.0);
        this.renderBall(f1, poseStack, ivertexbuilder, light);
        poseStack.m_85849_();
    }

    private void renderBall(float f1, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        this.renderFlatQuad(f1, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderFlatQuad(float f1, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 10.0f;
        float minV = 0.0f;
        float maxU = minU + 1.0f;
        float maxV = minV + 1.0f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f * f1, -0.75f * f1, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f * f1, 0.75f * f1, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f * f1, 0.75f * f1, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f * f1, -0.75f * f1, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(MagiFireballEntity magiFireballEntity) {
        return TEXTURE;
    }
}

